/*
 *----------------------------------------------------------------------
 *
 * PROGRAM  : cgmdump
 *
 * FILE     : cgmdump.c
 *
 * CONTENTS : This program reads a CGM character encoded metafile from
 *	      standard input and writes the code for each character to
 *	      standard output. The format of the code can be specified
 *	      using a flag :-
 *		-o  :  character codes in octal
 *		-d  :  character codes in decimal
 *		-h  :  character codes in hexadecimal
 *		-e  :  character codes in the x/y format used in ISO
 *		       documents for the encoding.
 *
 * DATE     : 24th April 1988
 *
 *---------------------------------------------------------------------
 */
#include <stdio.h>

#define OCTAL		0
#define DECIMAL		1
#define HEXADECIMAL	2
#define ENCODING	3

main(argc, argv)
	int     argc;
	char   *argv[];
{
	int     Output_format = ENCODING,
	        ch,
	        count,
	        argno,
	        ex,
	        ey;

	argno = 1;
	while (argno < argc)
	{
		argv++;
		if (argv[0][0] == '-')
		{
			switch (argv[0][1])
			{
				case 'o':
					Output_format = OCTAL;
					break;
				case 'd':
					Output_format = DECIMAL;
					break;
				case 'h':
					Output_format = HEXADECIMAL;
					break;
				case 'e':
					Output_format = ENCODING;
					break;
				default:
					command_line_error();
			}
		}
		else
			command_line_error();
		argno++;
	}

	count = 0;
	while ((ch = getchar()) != EOF)
	{
		switch (Output_format)
		{
			case OCTAL:
				printf("%3o ", ch);
				break;
			case DECIMAL:
				printf("%3d ", ch);
				break;
			case HEXADECIMAL:
				printf("%2x", ch);
				break;
			case ENCODING:
				ex = ch / 16;
				ey = ch % 16;
				if (ey < 10)
					printf("%d/%d    ", ex, ey);
				else
					printf("%d/%2d   ", ex, ey);
		}
		count = (count + 1) % 8;	/* 8 codes per line */
		if (count == 0)
			putchar('\n');
	}
	putchar('\n');
}


command_line_error()
{
	fprintf(stderr, "Usage : cgmdump [ -o | -d | -h | -e ]\n");
	exit(1);
}
