/* SPDX-License-Identifier: MIT */
/* SPDX-FileCopyrightText: (c) Copyright 2024 Andrew Bower <andrew@bower.uk> */

#ifndef _ROOTFS_H
#define _ROOTFS_H

#include <stdbool.h>

enum special_mount {
 SPECIAL_PROC = 0,
 SPECIAL_MAX
};

struct mount_info {
  char *from;
  char *to;
  bool mounted;
  int rc;
};

struct pivot_state {
  int roots_dir_fd;
  int old_root_fd;
  int new_root_fd;
  char *leaf_dir;
  char *path;
};

extern struct mount_info *special_mounts[SPECIAL_MAX];

static inline struct pivot_state pivot_init(void) {
  return (struct pivot_state) { -1, -1, -1, NULL, NULL };
}

extern bool create_new_root(const char *executable, struct pivot_state *pivot_state);
bool pivot_to_new_root(struct pivot_state *pivot_state);
extern void unmount_temp_rootfs(void);
extern void free_rootfs_data(void);
extern void pivot_tidy(struct pivot_state *pivot_state);

#endif
