/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.util.Vector;
import javax.vecmath.Point3f;
import org.jmol.i18n.GT;
import org.jmol.script.Token;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;

abstract class ScriptCompilationTokenParser {
    protected String script;
    protected short lineCurrent;
    protected int iCommand;
    protected int ichCurrentCommand;
    protected int ichComment;
    protected int ichEnd;
    protected int ichToken;
    protected Token theToken;
    protected Token lastFlowCommand;
    protected Token tokenCommand;
    protected Token lastToken;
    protected Token tokenAndEquals;
    protected int theTok;
    protected int nTokens;
    protected int tokCommand;
    protected int ptNewSetModifier;
    protected boolean isNewSet;
    protected boolean logMessages = false;
    protected Token[] atokenInfix;
    protected int itokenInfix;
    protected boolean isSetBrace;
    protected boolean isMathExpressionCommand;
    protected boolean isSetOrDefine;
    private Vector ltokenPostfix;
    protected boolean isEmbeddedExpression;
    protected boolean isCommaAsOrAllowed;
    private Object theValue;
    boolean haveString;
    private boolean residueSpecCodeGenerated;
    protected String errorMessage;
    protected String errorMessageUntranslated;
    protected String errorLine;
    protected String errorType;
    protected static final int ERROR_badArgumentCount = 0;
    protected static final int ERROR_badContext = 1;
    protected static final int ERROR_commandExpected = 2;
    protected static final int ERROR_endOfCommandUnexpected = 4;
    protected static final int ERROR_invalidExpressionToken = 9;
    protected static final int ERROR_missingEnd = 11;
    protected static final int ERROR_tokenExpected = 15;
    protected static final int ERROR_tokenUnexpected = 16;
    protected static final int ERROR_unrecognizedParameter = 18;
    protected static final int ERROR_unrecognizedToken = 19;
    private static final int ERROR_coordinateExpected = 3;
    private static final int ERROR_endOfExpressionExpected = 5;
    private static final int ERROR_identifierOrResidueSpecificationExpected = 6;
    private static final int ERROR_invalidAtomSpecification = 7;
    private static final int ERROR_invalidChainSpecification = 8;
    private static final int ERROR_invalidModelSpecification = 10;
    private static final int ERROR_numberExpected = 12;
    private static final int ERROR_numberOrVariableNameExpected = 13;
    private static final int ERROR_residueSpecificationExpected = 14;
    private static final int ERROR_unrecognizedExpressionToken = 17;

    ScriptCompilationTokenParser() {
    }

    protected boolean compileExpressions() {
        boolean bl;
        this.isEmbeddedExpression = this.tokCommand != 0 && (this.tokCommand != 135368708 || this.tokenCommand.intValue != Integer.MAX_VALUE) && this.tokCommand != 0x119009 && !Token.tokAttrOr(this.tokCommand, 12288, 20480);
        boolean bl2 = bl = this.isEmbeddedExpression || Token.tokAttr(this.tokCommand, 12288);
        if (this.tokAt(1) == 0x100007 && Token.tokAttr(this.tokCommand, 12288)) {
            bl = false;
        }
        if (bl && !this.compileExpression()) {
            return false;
        }
        int n = this.atokenInfix.length;
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            if (this.tokAt(i) != 1060866) continue;
            ++n2;
        }
        if (this.isNewSet && (n -= n2) == 1) {
            this.atokenInfix[0] = new Token(135368708, 0, this.atokenInfix[0].value);
            this.isNewSet = false;
        }
        if ((this.isNewSet || this.isSetBrace) && n < this.ptNewSetModifier + 2) {
            return this.commandExpected();
        }
        return n == 1 || !Token.tokAttr(this.tokCommand, 262144) ? true : this.error(0);
    }

    protected boolean compileExpression() {
        int n = this.isSetOrDefine && !this.isSetBrace ? 2 : 1;
        this.ltokenPostfix = new Vector();
        this.itokenInfix = 0;
        Token token = null;
        if (this.tokCommand == 12294 && this.tokAt(1) == 1678770178) {
            this.addNextToken();
            this.addNextToken();
        } else {
            for (int i = 0; i < n && this.addNextToken(); ++i) {
            }
        }
        while (this.moreTokens()) {
            if (this.isEmbeddedExpression) {
                while (!this.isExpressionNext() && this.addNextToken()) {
                }
                if (!this.moreTokens()) break;
            }
            if (this.lastToken.tok == 1060866) {
                if (this.clauseDefine()) continue;
                return false;
            }
            if (!this.isMathExpressionCommand) {
                token = new Token(0x100001, "implicitExpressionBegin");
                this.addTokenToPostfix(token);
            }
            if (!this.clauseOr(this.isCommaAsOrAllowed || !this.isMathExpressionCommand && this.tokPeek(0x10100010))) {
                return false;
            }
            if (!(this.isMathExpressionCommand || this.isEmbeddedExpression && this.lastToken == Token.tokenCoordinateEnd)) {
                this.addTokenToPostfix(Token.tokenExpressionEnd);
            }
            if (!this.moreTokens()) continue;
            if (this.tokCommand != 135280129 && !this.isEmbeddedExpression) {
                return this.error(5);
            }
            if (this.tokCommand != 135280129) continue;
            token.intValue = 0;
            this.tokCommand = 0;
            this.isEmbeddedExpression = true;
            this.isMathExpressionCommand = true;
            this.isCommaAsOrAllowed = false;
        }
        this.atokenInfix = new Token[this.ltokenPostfix.size()];
        this.ltokenPostfix.copyInto(this.atokenInfix);
        return true;
    }

    private boolean isExpressionNext() {
        return this.tokPeek(0x10000A) || !this.isMathExpressionCommand && this.tokPeek(0x10100010);
    }

    protected static boolean tokenAttr(Token token, int n) {
        return token != null && Token.tokAttr(token.tok, n);
    }

    private boolean moreTokens() {
        return this.itokenInfix < this.atokenInfix.length;
    }

    protected int tokAt(int n) {
        return n < this.atokenInfix.length ? this.atokenInfix[n].tok : 0;
    }

    private int tokPeek() {
        return this.itokenInfix >= this.atokenInfix.length ? 0 : this.atokenInfix[this.itokenInfix].tok;
    }

    private boolean tokPeek(int n) {
        return this.itokenInfix < this.atokenInfix.length && this.atokenInfix[this.itokenInfix].tok == n;
    }

    private int intPeek() {
        return this.itokenInfix >= this.atokenInfix.length ? Integer.MAX_VALUE : this.atokenInfix[this.itokenInfix].intValue;
    }

    private Object valuePeek() {
        return this.moreTokens() ? this.atokenInfix[this.itokenInfix].value : "";
    }

    private Token tokenNext() {
        return this.itokenInfix >= this.atokenInfix.length ? null : this.atokenInfix[this.itokenInfix++];
    }

    private boolean tokenNext(int n) {
        Token token = this.tokenNext();
        return token != null && token.tok == n;
    }

    private boolean returnToken() {
        --this.itokenInfix;
        return false;
    }

    private Token getToken() {
        this.theToken = this.tokenNext();
        this.theValue = this.theToken == null ? null : this.theToken.value;
        return this.theToken;
    }

    private boolean isToken(int n) {
        return this.theToken != null && this.theToken.tok == n;
    }

    private boolean getNumericalToken() {
        return this.getToken() != null && (this.isToken(2) || this.isToken(3));
    }

    private float floatValue() {
        switch (this.theToken.tok) {
            case 2: {
                return this.theToken.intValue;
            }
            case 3: {
                return ((Float)this.theValue).floatValue();
            }
        }
        return 0.0f;
    }

    private boolean addTokenToPostfix(int n, Object object) {
        return this.addTokenToPostfix(new Token(n, object));
    }

    private boolean addTokenToPostfix(int n, int n2, Object object) {
        return this.addTokenToPostfix(new Token(n, n2, object));
    }

    private boolean addTokenToPostfix(Token token) {
        if (token == null) {
            return false;
        }
        if (this.logMessages) {
            Logger.debug("addTokenToPostfix" + token);
        }
        this.ltokenPostfix.addElement(token);
        this.lastToken = token;
        return true;
    }

    private boolean addNextToken() {
        return this.addTokenToPostfix(this.tokenNext());
    }

    private boolean addNextTokenIf(int n) {
        return this.tokPeek(n) && this.addNextToken();
    }

    private boolean addSubstituteTokenIf(int n, Token token) {
        if (!this.tokPeek(n)) {
            return false;
        }
        ++this.itokenInfix;
        return this.addTokenToPostfix(token);
    }

    private boolean clauseOr(boolean bl) {
        int n;
        this.haveString = false;
        if (!this.clauseAnd()) {
            return false;
        }
        if (this.isEmbeddedExpression && this.lastToken.tok == 0x100002) {
            return true;
        }
        while ((n = this.tokPeek()) == 0x10100050 || n == 0x10100051 || n == 269484114 || bl && n == 0x10100030) {
            if (n == 0x10100030 && !this.haveString) {
                this.addSubstituteTokenIf(0x10100030, Token.tokenOr);
            } else {
                this.addNextToken();
            }
            if (this.clauseAnd()) continue;
            return false;
        }
        return true;
    }

    private boolean clauseAnd() {
        if (!this.clauseNot()) {
            return false;
        }
        if (this.isEmbeddedExpression && this.lastToken.tok == 0x100002) {
            return true;
        }
        while (this.tokPeek(0x10100060)) {
            this.addNextToken();
            if (this.clauseNot()) continue;
            return false;
        }
        return true;
    }

    private boolean clauseNot() {
        if (this.tokPeek(0x10100070)) {
            this.addNextToken();
            return this.clauseNot();
        }
        return this.clausePrimitive();
    }

    private boolean clausePrimitive() {
        int n = this.tokPeek();
        switch (n) {
            case 0: {
                return this.error(4);
            }
            case 9: 
            case 0x100003: 
            case 0x100009: 
            case 0x10000B: 
            case 137363471: 
            case 0x101000A0: {
                return this.addNextToken();
            }
            case 4: {
                this.haveString = true;
                return this.addNextToken();
            }
            case 3: {
                return this.addTokenToPostfix(1048611, this.getToken().intValue, this.theValue);
            }
            case 1095761925: {
                return this.clauseCell();
            }
            case 135266318: {
                return this.clauseConnected();
            }
            case 135266817: {
                return this.clauseSubstructure();
            }
            case 135266317: {
                return this.clauseWithin();
            }
            case 1060866: {
                this.addNextToken();
                if (this.tokPeek() == 0) {
                    return this.error(4);
                }
                return this.clauseDefine();
            }
            case 1678770178: 
            case 1746538503: {
                this.addNextToken();
                if (this.tokPeek(9)) {
                    this.addNextToken();
                } else if (this.tokPeek(1060866)) {
                    this.addNextToken();
                    return this.clauseDefine();
                }
                return true;
            }
            case 0x10100010: {
                this.addNextToken();
                if (!this.clauseOr(true)) {
                    return false;
                }
                if (!this.addNextTokenIf(0x10100011)) {
                    return this.error(15, ")");
                }
                return this.checkForItemSelector();
            }
            case 0x10000A: {
                return this.checkForCoordinate(this.isMathExpressionCommand);
            }
        }
        if (this.clauseResidueSpec()) {
            return true;
        }
        if (this.isError()) {
            return false;
        }
        if (Token.tokAttr(n, 0x40500000)) {
            int n2 = this.itokenInfix;
            boolean bl = this.clauseComparator(Token.tokAttr(n, 0x300000));
            if (bl || this.itokenInfix != n2) {
                return bl;
            }
        }
        if (n == 2 || Token.tokAttr(n, 0x300000)) {
            return this.addNextToken();
        }
        return this.error(17, "" + this.valuePeek());
    }

    private boolean checkForCoordinate(boolean bl) {
        boolean bl2 = false;
        int n = this.ltokenPostfix.size();
        if (bl) {
            this.addTokenToPostfix(Token.tokenExpressionBegin);
            this.tokenNext();
        } else if (this.isEmbeddedExpression) {
            this.tokenNext();
            --n;
        } else {
            this.addNextToken();
        }
        if (!this.clauseOr(false)) {
            return false;
        }
        int n2 = 1;
        while (!this.tokPeek(0x10000E)) {
            boolean bl3 = this.addNextTokenIf(0x10100030);
            if (!this.clauseOr(false)) {
                return bl3 || n2 < 3 ? false : this.error(15, "}");
            }
            ++n2;
        }
        boolean bl4 = bl2 = n2 >= 2;
        if (bl2 && (bl || this.isEmbeddedExpression)) {
            this.ltokenPostfix.set(n, Token.tokenCoordinateBegin);
            this.addTokenToPostfix(Token.tokenCoordinateEnd);
            this.tokenNext();
        } else if (bl) {
            this.addTokenToPostfix(Token.tokenExpressionEnd);
            this.tokenNext();
        } else if (this.isEmbeddedExpression) {
            this.tokenNext();
        } else {
            this.addNextToken();
        }
        return this.checkForItemSelector();
    }

    private boolean checkForItemSelector() {
        for (int i = 0; i < 2 && this.addNextTokenIf(0x10100040); ++i) {
            if (!this.clauseItemSelector()) {
                return false;
            }
            if (this.addNextTokenIf(0x10100041)) continue;
            return this.error(15, "]");
        }
        return true;
    }

    private boolean clauseWithin() {
        this.addNextToken();
        if (!this.addNextTokenIf(0x10100010)) {
            return false;
        }
        if (this.getToken() == null) {
            return false;
        }
        float f = Float.MAX_VALUE;
        String string = null;
        boolean bl = true;
        switch (this.theToken.tok) {
            case 0x10100090: {
                if (this.getToken() == null) {
                    return false;
                }
                if (this.theToken.tok != 2) {
                    return this.error(12);
                }
                f = -this.theToken.intValue;
                break;
            }
            case 2: 
            case 3: {
                f = this.floatValue();
                break;
            }
            case 0x100004: {
                bl = false;
            }
            case 4: 
            case 0x100006: 
            case 137363471: 
            case 0x40D00004: 
            case 1087373318: 
            case 1087375361: 
            case 1087375362: 
            case 1087375365: 
            case 1095761934: 
            case 1095761935: 
            case 1095761938: 
            case 1095766028: 
            case 1104154627: 
            case 1679429641: {
                string = (String)this.theValue;
                break;
            }
            case 0x40000000: {
                string = ((String)this.theValue).toLowerCase();
                break;
            }
            default: {
                return this.error(18, "WITHIN", ": " + this.theToken.value);
            }
        }
        if (string == null) {
            this.addTokenToPostfix(3, new Float(f));
        } else {
            this.addTokenToPostfix(4, string);
        }
        while (this.addNextTokenIf(0x10100030)) {
            int n = this.tokPeek();
            if (f != Float.MAX_VALUE && (n == 0x10000D || n == 0x10000C)) {
                this.addTokenToPostfix(this.getToken());
                if (!this.addNextTokenIf(0x10100030)) break;
                n = this.tokPeek();
            }
            boolean bl2 = false;
            if (string == null) {
                switch (n) {
                    case 0x100006: 
                    case 135266313: 
                    case 135267842: {
                        bl2 = true;
                        this.addNextToken();
                        break;
                    }
                    case 0x10000A: {
                        this.returnToken();
                        bl2 = true;
                        this.addTokenToPostfix(Token.getTokenFromName(f == Float.MAX_VALUE ? "plane" : "coord"));
                    }
                }
                this.addNextTokenIf(0x10100030);
            }
            n = this.tokPeek();
            if (bl2) {
                block17: while (!this.tokPeek(0x10100011)) {
                    switch (this.tokPeek()) {
                        case 0: {
                            return this.error(4);
                        }
                        case 0x10100010: {
                            this.addTokenToPostfix(Token.tokenExpressionBegin);
                            this.addNextToken();
                            if (!this.clauseOr(false)) {
                                return this.error(18, "WITHIN", ": ?");
                            }
                            if (!this.addNextTokenIf(0x10100011)) {
                                return this.error(15, ", / )");
                            }
                            this.addTokenToPostfix(Token.tokenExpressionEnd);
                            continue block17;
                        }
                        case 1060866: {
                            this.addTokenToPostfix(this.getToken());
                            if (this.clauseDefine()) continue block17;
                            return false;
                        }
                    }
                    this.addTokenToPostfix(this.getToken());
                }
                continue;
            }
            if (this.clauseOr(bl)) continue;
            return this.error(0);
        }
        if (!this.addNextTokenIf(0x10100011)) {
            return this.error(15, ")");
        }
        return true;
    }

    private boolean clauseConnected() {
        block10: {
            block12: {
                String string;
                block11: {
                    this.addNextToken();
                    if (!this.addNextTokenIf(0x10100010)) {
                        this.addTokenToPostfix(Token.tokenLeftParen);
                        this.addTokenToPostfix(Token.tokenRightParen);
                        return true;
                    }
                    if (this.addNextTokenIf(2) && !this.addNextTokenIf(0x10100030) || this.addNextTokenIf(2) && !this.addNextTokenIf(0x10100030) || this.addNextTokenIf(3) && !this.addNextTokenIf(0x10100030) || this.addNextTokenIf(3) && !this.addNextTokenIf(0x10100030)) break block10;
                    string = (String)this.getToken().value;
                    int n = JmolConstants.getBondOrderFromString(string);
                    if (n != 131071) break block11;
                    this.returnToken();
                    break block12;
                }
                this.addTokenToPostfix(4, string);
                if (!this.addNextTokenIf(0x10100030)) break block10;
            }
            if (this.addNextTokenIf(0x10100011)) {
                return true;
            }
            if (!this.clauseOr(this.tokPeek(0x10100010))) {
                return false;
            }
            if (this.addNextTokenIf(0x10100011)) {
                return true;
            }
            if (!this.addNextTokenIf(0x10100030)) {
                return false;
            }
            if (!this.clauseOr(this.tokPeek(0x10100010))) {
                return false;
            }
        }
        if (!this.addNextTokenIf(0x10100011)) {
            return this.error(15, ")");
        }
        return true;
    }

    private boolean clauseSubstructure() {
        this.addNextToken();
        if (!this.addNextTokenIf(0x10100010)) {
            return false;
        }
        if (!this.addNextTokenIf(4)) {
            return this.error(15, "\"...\"");
        }
        if (!this.addNextTokenIf(0x10100011)) {
            return this.error(15, ")");
        }
        return true;
    }

    private boolean clauseItemSelector() {
        int n;
        int n2 = 0;
        while ((n = this.tokPeek()) != 0 && n != 0x10100041) {
            this.addNextToken();
            if (n == 0x10100040) {
                ++n2;
            }
            if (this.tokPeek() != 0x10100041 || n2-- <= 0) continue;
            this.addNextToken();
        }
        return true;
    }

    private boolean clauseComparator(boolean bl) {
        Token token = this.tokenNext();
        Token token2 = this.tokenNext();
        if (!ScriptCompilationTokenParser.tokenAttr(token2, 0x10100100)) {
            if (!bl) {
                return this.error(15, "== != < > <= >=");
            }
            if (token2 != null) {
                this.returnToken();
            }
            this.returnToken();
            return false;
        }
        if (ScriptCompilationTokenParser.tokenAttr(token, 0x40D00000) && token2.tok != 269484420 && token2.tok != 269484421) {
            return this.error(15, "== !=");
        }
        if (this.getToken() == null) {
            return this.error(17, "" + this.valuePeek());
        }
        boolean bl2 = this.isToken(0x10100090);
        if (bl2 && this.getToken() == null) {
            return this.error(12);
        }
        switch (this.theToken.tok) {
            case 2: 
            case 3: 
            case 4: 
            case 0x10000A: 
            case 1060866: 
            case 0x40000000: {
                break;
            }
            default: {
                if (Token.tokAttr(this.theToken.tok, 0x40000000)) break;
                return this.error(13);
            }
        }
        this.addTokenToPostfix(token2.tok, token.tok, token2.value + (bl2 ? " -" : ""));
        if (token.tok == 1716520973) {
            this.addTokenToPostfix(token);
        }
        if (this.isToken(0x10000A)) {
            this.returnToken();
            return this.clausePrimitive();
        }
        this.addTokenToPostfix(this.theToken);
        if (this.theToken.tok == 1060866) {
            return this.clauseDefine();
        }
        return true;
    }

    private boolean clauseCell() {
        Point3f point3f = new Point3f();
        this.tokenNext();
        if (!this.tokenNext(269484420)) {
            return this.error(15, "=");
        }
        if (this.getToken() == null) {
            return this.error(3);
        }
        if (this.isToken(2)) {
            int n = this.theToken.intValue;
            point3f.x = n / 100 - 4;
            point3f.y = n % 100 / 10 - 4;
            point3f.z = n % 10 - 4;
            return this.addTokenToPostfix(1095761925, point3f);
        }
        if (!this.isToken(0x10000A) || !this.getNumericalToken()) {
            return this.error(3);
        }
        point3f.x = this.floatValue();
        if (this.tokPeek(0x10100030)) {
            this.tokenNext();
        }
        if (!this.getNumericalToken()) {
            return this.error(3);
        }
        point3f.y = this.floatValue();
        if (this.tokPeek(0x10100030)) {
            this.tokenNext();
        }
        if (!this.getNumericalToken() || !this.tokenNext(0x10000E)) {
            return this.error(3);
        }
        point3f.z = this.floatValue();
        return this.addTokenToPostfix(1095761925, point3f);
    }

    private boolean clauseDefine() {
        if (!this.addSubstituteTokenIf(0x10000A, Token.tokenExpressionBegin)) {
            return this.addNextToken() && this.checkForItemSelector();
        }
        while (this.moreTokens() && !this.tokPeek(0x10000E)) {
            if (this.tokPeek(0x10000A)) {
                if (this.checkForCoordinate(true)) continue;
                return false;
            }
            this.addNextToken();
        }
        return this.addSubstituteTokenIf(0x10000E, Token.tokenExpressionEnd) && this.checkForItemSelector();
    }

    private boolean generateResidueSpecCode(Token token) {
        if (this.residueSpecCodeGenerated) {
            this.addTokenToPostfix(Token.tokenAnd);
        }
        this.addTokenToPostfix(token);
        this.residueSpecCodeGenerated = true;
        return true;
    }

    private boolean clauseResidueSpec() {
        int n = this.tokPeek();
        this.residueSpecCodeGenerated = false;
        boolean bl = false;
        switch (n) {
            case 0: 
            case 0x300002: 
            case 0x300009: {
                return false;
            }
            case 2: 
            case 5: 
            case 0x10100022: 
            case 269484194: {
                break;
            }
            case 0x10100040: 
            case 0x101000A1: 
            case 0x40000000: {
                bl = true;
                break;
            }
            default: {
                if (Token.tokAttr(n, 0x10100100)) {
                    return false;
                }
                String string = "" + this.valuePeek();
                boolean bl2 = bl = string.length() == 2 || string.length() == 3;
                if (bl) break;
                return false;
            }
        }
        boolean bl3 = false;
        if (bl) {
            if (!this.clauseResNameSpec()) {
                return false;
            }
            bl3 = true;
            n = this.tokPeek();
            if (Token.tokAttr(n, 0x10100100)) {
                this.returnToken();
                this.ltokenPostfix.remove(this.ltokenPostfix.size() - 1);
                return false;
            }
        }
        boolean bl4 = false;
        if (n == 0x101000A1 || n == 2 || n == 5) {
            boolean bl5 = bl4 = n == 2;
            if (this.tokPeek(0x101000A1)) {
                this.getToken();
            } else if (!this.clauseSequenceSpec()) {
                return false;
            }
            bl3 = true;
            n = this.tokPeek();
        }
        if (n == 0x10100022 || n == 0x101000A1 || n == 0x40000000 || n == 2 && !bl4) {
            if (!this.clauseChainSpec(n)) {
                return false;
            }
            bl3 = true;
            n = this.tokPeek();
        }
        if (n == 0x100008) {
            if (!this.clauseAtomSpec()) {
                return false;
            }
            bl3 = true;
            n = this.tokPeek();
        }
        if (n == 269484194) {
            if (!this.clauseAlternateSpec()) {
                return false;
            }
            bl3 = true;
            n = this.tokPeek();
        }
        if (n == 0x10100022 || n == 0x101000A0) {
            if (!this.clauseModelSpec()) {
                return false;
            }
            bl3 = true;
            n = this.tokPeek();
        }
        if (!bl3) {
            return this.error(14);
        }
        if (!this.residueSpecCodeGenerated) {
            this.addTokenToPostfix(Token.tokenAll);
        }
        return true;
    }

    private boolean clauseResNameSpec() {
        this.getToken();
        switch (this.theToken.tok) {
            case 0x101000A1: {
                return true;
            }
            case 0x10100040: {
                int n;
                String string = "";
                while (this.getToken() != null && !this.isToken(0x10100041)) {
                    string = string + this.theValue;
                }
                if (!this.isToken(0x10100041)) {
                    return false;
                }
                if (string == "") {
                    return true;
                }
                if (string.length() > 0 && (n = string.indexOf("*")) >= 0 && n != string.length() - 1) {
                    return this.error(14);
                }
                string = string.toUpperCase();
                return this.generateResidueSpecCode(new Token(1048612, string));
            }
        }
        String string = (String)this.theValue;
        if (this.tokPeek(0x101000A1)) {
            string = this.theValue + "*";
            this.getToken();
        }
        return this.generateResidueSpecCode(new Token(0x40000000, string));
    }

    private boolean clauseSequenceSpec() {
        Token token = this.getSequenceCode(false);
        if (token == null) {
            return false;
        }
        int n = this.tokPeek();
        if (n == 0x10100090 || n == 2 && this.intPeek() < 0) {
            if (n == 0x10100090) {
                this.tokenNext();
            } else {
                int n2;
                this.tokenNext().intValue = n2 = -this.intPeek();
                this.returnToken();
            }
            token.tok = 1048615;
            this.generateResidueSpecCode(token);
            return this.addTokenToPostfix(this.getSequenceCode(true));
        }
        return this.generateResidueSpecCode(token);
    }

    private Token getSequenceCode(boolean bl) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = this.tokPeek();
        if (n3 == 5) {
            n = this.tokenNext().intValue;
        } else if (n3 == 2) {
            n2 = this.tokenNext().intValue;
        } else if (!bl) {
            return null;
        }
        return new Token(1048614, n2, new Integer(n));
    }

    private boolean clauseChainSpec(int n) {
        char c;
        if (n == 0x10100022) {
            this.tokenNext();
            n = this.tokPeek();
            if (this.isSpecTerminator(n)) {
                return this.generateResidueSpecCode(new Token(0x100021, 0, "spec_chain"));
            }
        }
        switch (n) {
            case 0x101000A1: {
                return this.getToken() != null;
            }
            case 2: {
                this.getToken();
                int n2 = this.theToken.intValue;
                if (n2 < 0 || n2 > 9) {
                    return this.error(8);
                }
                c = (char)(48 + n2);
                break;
            }
            default: {
                String string = "" + this.getToken().value;
                if (string.length() != 1) {
                    return this.error(8);
                }
                c = string.charAt(0);
                if (c != '?') break;
                return true;
            }
        }
        return this.generateResidueSpecCode(new Token(0x100021, c, "spec_chain"));
    }

    private boolean isSpecTerminator(int n) {
        switch (n) {
            case 0: 
            case 0x10100011: 
            case 0x10100030: 
            case 0x10100050: 
            case 0x10100060: 
            case 0x10100070: 
            case 0x101000A0: 
            case 269484194: {
                return true;
            }
        }
        return false;
    }

    private boolean clauseAlternateSpec() {
        this.tokenNext();
        int n = this.tokPeek();
        if (this.isSpecTerminator(n)) {
            return this.generateResidueSpecCode(new Token(0x10001F, null));
        }
        String string = (String)this.getToken().value;
        switch (this.theToken.tok) {
            case 2: 
            case 4: 
            case 0x101000A1: 
            case 0x40000000: {
                break;
            }
            default: {
                return this.error(10);
            }
        }
        return this.generateResidueSpecCode(new Token(0x10001F, string));
    }

    private boolean clauseModelSpec() {
        this.getToken();
        if (this.tokPeek(0x101000A1)) {
            this.getToken();
            return true;
        }
        switch (this.tokPeek()) {
            case 2: {
                return this.generateResidueSpecCode(new Token(0x100022, new Integer(this.getToken().intValue)));
            }
            case 3: {
                return this.generateResidueSpecCode(new Token(0x100022, this.getToken().intValue, this.theValue));
            }
            case 0: 
            case 0x10000E: 
            case 0x10100030: {
                return this.generateResidueSpecCode(new Token(0x100022, new Integer(1)));
            }
        }
        return this.error(10);
    }

    private boolean clauseAtomSpec() {
        if (!this.tokenNext(0x100008)) {
            return this.error(7);
        }
        if (this.getToken() == null) {
            return true;
        }
        String string = "";
        if (this.isToken(2)) {
            string = string + "" + this.theToken.intValue;
            if (this.getToken() == null) {
                return this.error(7);
            }
        }
        switch (this.theToken.tok) {
            case 0x101000A1: {
                return true;
            }
        }
        string = string + "" + this.theToken.value;
        if (this.tokPeek(0x101000A1)) {
            this.tokenNext();
            string = string + "*";
        }
        return this.generateResidueSpecCode(new Token(0x100020, string));
    }

    static String errorString(int n, String string, String string2, boolean bl) {
        String string3;
        boolean bl2 = false;
        if (!bl && (bl2 = GT.getDoTranslate())) {
            GT.setDoTranslate(false);
        }
        switch (n) {
            default: {
                string3 = "Unknown compiler error message number: " + n;
                break;
            }
            case 0: {
                string3 = GT._("bad argument count");
                break;
            }
            case 1: {
                string3 = GT._("invalid context for {0}");
                break;
            }
            case 2: {
                string3 = GT._("command expected");
                break;
            }
            case 3: {
                string3 = GT._("{ number number number } expected");
                break;
            }
            case 4: {
                string3 = GT._("unexpected end of script command");
                break;
            }
            case 5: {
                string3 = GT._("end of expression expected");
                break;
            }
            case 6: {
                string3 = GT._("identifier or residue specification expected");
                break;
            }
            case 7: {
                string3 = GT._("invalid atom specification");
                break;
            }
            case 8: {
                string3 = GT._("invalid chain specification");
                break;
            }
            case 9: {
                string3 = GT._("invalid expression token: {0}");
                break;
            }
            case 10: {
                string3 = GT._("invalid model specification");
                break;
            }
            case 11: {
                string3 = GT._("missing END for {0}");
                break;
            }
            case 12: {
                string3 = GT._("number expected");
                break;
            }
            case 13: {
                string3 = GT._("number or variable name expected");
                break;
            }
            case 14: {
                string3 = GT._("residue specification (ALA, AL?, A*) expected");
                break;
            }
            case 15: {
                string3 = GT._("{0} expected");
                break;
            }
            case 16: {
                string3 = GT._("{0} unexpected");
                break;
            }
            case 17: {
                string3 = GT._("unrecognized expression token: {0}");
                break;
            }
            case 18: {
                string3 = GT._("unrecognized {0} parameter");
                break;
            }
            case 19: {
                string3 = GT._("unrecognized token: {0}");
            }
        }
        if (string3.indexOf("{0}") < 0) {
            if (string != null) {
                string3 = string3 + ": " + string;
            }
        } else if ((string3 = TextFormat.simpleReplace(string3, "{0}", string)).indexOf("{1}") >= 0) {
            string3 = TextFormat.simpleReplace(string3, "{1}", string2);
        } else if (string2 != null) {
            string3 = string3 + ": " + string2;
        }
        if (!bl) {
            GT.setDoTranslate(bl2);
        }
        return string3;
    }

    protected boolean commandExpected() {
        this.ichToken = this.ichCurrentCommand;
        return this.error(2);
    }

    protected boolean error(int n) {
        return this.error(n, null, null);
    }

    protected boolean error(int n, String string) {
        return this.error(n, string, null);
    }

    protected boolean error(int n, String string, String string2) {
        String string3 = ScriptCompilationTokenParser.errorString(n, string, string2, true);
        String string4 = GT.getDoTranslate() ? ScriptCompilationTokenParser.errorString(n, string, string2, false) : null;
        return this.error(string3, string4);
    }

    private boolean isError() {
        return this.errorMessage != null;
    }

    protected boolean error(String string, String string2) {
        this.errorMessage = string;
        this.errorMessageUntranslated = string2;
        return false;
    }
}

