"""Add 'occupant_id' column to Participant

Revision ID: b7a06a86416a
Revises: 86d980dbb426
Create Date: 2025-12-14 21:39:45.025086

"""

from typing import Sequence, Union

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "b7a06a86416a"
down_revision: Union[str, None] = "86d980dbb426"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    op.execute("DELETE FROM participant")
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("participant", schema=None) as batch_op:
        batch_op.add_column(sa.Column("occupant_id", sa.String(), nullable=False))
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("participant", schema=None) as batch_op:
        batch_op.drop_column("occupant_id")
    # ### end Alembic commands ###
