if(APPLE_11_00_X)
	set(OSXMINVER "11.00" CACHE STRING "OSX 11.00")
	if (WANT_OSX_SDK)
		if(EXISTS("/Applications/Xcode-beta.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.16.sdk"))
			set(CMAKE_OSX_SYSROOT "/Applications/Xcode-beta.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.16.sdk")
		elseif(EXISTS("/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.16.sdk"))
			set(CMAKE_OSX_SYSROOT "/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.16.sdk")
		elseif(EXISTS("/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX11.00.sdk"))
			set(CMAKE_OSX_SYSROOT "/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX11.00.sdk")
		elseif(EXISTS("/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.15.sdk"))
			set(CMAKE_OSX_SYSROOT "/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.15.sdk")
		endif()
	endif()
endif()
if(APPLE_10_15_X)
	set(OSXMINVER "10.15" CACHE STRING "OSX 10.15")
	if (WANT_OSX_SDK)
		if(EXISTS("/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.15.sdk"))
			set(CMAKE_OSX_SYSROOT "/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.15.sdk")
		elseif(EXISTS("/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.14.sdk"))
			set(CMAKE_OSX_SYSROOT "/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.14.sdk")
		endif()
	endif()
endif()
if(APPLE_10_14_X)
	set(OSXMINVER "10.14" CACHE STRING "OSX 10.14")
	if (WANT_OSX_SDK)
		if(EXISTS("/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.15.sdk"))
			set(CMAKE_OSX_SYSROOT "/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.15.sdk")
		elseif(EXISTS("/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.14.sdk"))
			set(CMAKE_OSX_SYSROOT "/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.14.sdk")
		elseif(EXISTS("/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.13.sdk"))
			set(CMAKE_OSX_SYSROOT "/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.13.sdk")
		endif()
	endif()
endif()
if(APPLE_10_13_X)
	set(OSXMINVER "10.13" CACHE STRING "OSX 10.13")
	if (WANT_OSX_SDK)
		if(EXISTS("/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.13.sdk"))
			set(CMAKE_OSX_SYSROOT "/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.13.sdk")
		elseif(EXISTS("/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.12.sdk"))
			set(CMAKE_OSX_SYSROOT "/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.12.sdk")
		endif()
	endif()
endif()
if(APPLE_10_12_X)
	set(OSXMINVER "10.12" CACHE STRING "OSX 10.12")
	if (WANT_OSX_SDK)
		if(EXISTS("/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.12.sdk"))
			set(CMAKE_OSX_SYSROOT "/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.12.sdk")
		elseif(EXISTS("/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.11.sdk"))
			set(CMAKE_OSX_SYSROOT "/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.11.sdk")
		endif()
	endif()
endif()
if(APPLE_10_11_X)
	set(OSXMINVER "10.11" CACHE STRING "OSX 10.11")
	if (WANT_OSX_SDK)
		set(CMAKE_OSX_SYSROOT "/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.11.sdk")
	endif()
endif()
if(APPLE_10_10_X)
	set(OSXMINVER "10.10" CACHE STRING "OSX 10.10")
	set(CMAKE_OSX_DEPLOYMENT_TARGET "10.10")
	if (WANT_OSX_SDK)
		if(EXISTS("/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.10.sdk"))
			set(CMAKE_OSX_SYSROOT "/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.10.sdk")
		elseif(EXISTS("/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.11.sdk"))
			set(CMAKE_OSX_SYSROOT "/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.11.sdk")
		endif()
	endif()
endif()
if(APPLE_10_9_X)
	set(OSXMINVER "10.9" CACHE STRING "OSX 10.9")
	if (WANT_OSX_SDK)
		set(CMAKE_OSX_SYSROOT "/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.9.sdk")
	endif()
endif()
if(APPLE_10_8_X)
	set(OSXMINVER "10.8" CACHE STRING "OSX 10.8")
	if (WANT_OSX_SDK)
		set(CMAKE_OSX_SYSROOT "/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.8.sdk")
	endif()
endif()
if(APPLE_10_7_X)
	set(OSXMINVER "10.7" CACHE STRING "OSX 10.7")
	if (WANT_OSX_SDK)
		set(CMAKE_OSX_SYSROOT "/Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.7.sdk")
	endif()
endif()
if(APPLE_10_6_X)
	set(OSXMINVER "10.6" CACHE STRING "OSX 10.6")
	if (WANT_OSX_SDK)
		set(CMAKE_OSX_SYSROOT "/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.6.sdk")
	endif()
endif()
if(APPLE_10_5_X)
	set(OSXMINVER "10.5" CACHE STRING "OSX 10.5")
	if (WANT_OSX_SDK)
		set(CMAKE_OSX_SYSROOT "/Developer/SDKs/MacOSX10.5.sdk")
	endif()
endif()
if(APPLE_10_4_X)
	set(OSXMINVER "10.4" CACHE STRING "OSX 10.4")
	if (WANT_OSX_SDK)
		set(CMAKE_OSX_SYSROOT "/Developer/SDKs/MacOSX10.4u.sdk")
	endif()
endif()
# gcc/mac
if(WANT_UNIVERSAL_BUNDLE)
	message(STATUS "Setting Universal (PPC/i386) Architecture for OSX Build/Bundle")
	set(CMAKE_OSX_ARCHITECTURES "ppc;i386" )
	set(CMAKE_TRY_COMPILE_OSX_ARCHITECTURES "ppc;i386" )
	if (WANT_OSX_SDK)
		set(CMAKE_OSX_DEPLOYMENT_TARGET "10.4")
	endif()
else()
	if(ARCH_PPC OR ARCH_PPC_64)
		message(STATUS "Setting PPC Architecture for OSX Build/Bundle")
		set(CMAKE_OSX_ARCHITECTURES "ppc" )
		set(CMAKE_TRY_COMPILE_OSX_ARCHITECTURES "ppc" )
	else()
		if (WANT_OSX_SDK)
			set(CMAKE_OSX_DEPLOYMENT_TARGET "${OSXMINVER}")
		endif()
		if(APPLE_10_6_X OR APPLE_10_7_X OR APPLE_10_8_X OR APPLE_10_9_X OR APPLE_10_10_X OR APPLE_10_11_X OR APPLE_10_12_X OR APPLE_10_13_X OR APPLE_10_14_X OR APPLE_10_15_X OR APPLE_10_16_X)
			message(STATUS "Setting x86_64 Architecture for OSX Build/Bundle")
			set(CMAKE_OSX_ARCHITECTURES "x86_64" )
			set(CMAKE_TRY_COMPILE_OSX_ARCHITECTURES "x86_64" )
		else()
			message(STATUS "Setting i386 Architecture for OSX Build/Bundle")
			set(CMAKE_OSX_ARCHITECTURES "i386" )
			set(CMAKE_TRY_COMPILE_OSX_ARCHITECTURES "i386" )
		endif()
	endif()
endif()
message(STATUS "Apple Architecture: ${CMAKE_OSX_ARCHITECTURES}")
message(STATUS "Apple SDK: ${CMAKE_OSX_SYSROOT}")
set(ENV{MACOSX_DEPLOYMENT_TARGET} ${OSXMINVER} )
set(ENV{LD_PREBIND} 1 )
set(ENV{LD_PREBIND_ALLOW_OVERLAP} 1 )
if (WANT_DEBUG)
	set(CMAKE_CXX_FLAGS_DEBUG "${CMAKE_CXX_FLAGS_DEBUG} -O0 -g -fno-inline-functions -Wall -mmacosx-version-min=${OSXMINVER}")
	set(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -O0 -g -fno-inline-functions -Wall -mmacosx-version-min=${OSXMINVER}")
endif()
if (WANT_RELEASEWITHDEBUG)
	set(CMAKE_CXX_FLAGS_RELWITHDEBINFO "${CMAKE_CXX_FLAGS_RELWITHDEBINFO} -O2 -g -fno-inline-functions -Wall -mmacosx-version-min=${OSXMINVER}")
	set(CMAKE_C_FLAGS_RELWITHDEBINFO "${CMAKE_C_FLAGS_RELWITHDEBINFO} -O2 -g -fno-inline-functions -Wall -mmacosx-version-min=${OSXMINVER}")
endif()
if (NOT WANT_DEBUG AND NOT WANT_RELEASEWITHDEBUG)
	set(CMAKE_CXX_FLAGS_RELEASE "${CMAKE_CXX_FLAGS_RELEASE} -O2 -fno-inline-functions -Wall -mmacosx-version-min=${OSXMINVER}")
	set(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE} -O2 -fno-inline-functions -Wall -mmacosx-version-min=${OSXMINVER}")
endif()
