# 2023-04-18 Triage Log

A busy two weeks (as last week perf triage was not done). Overall improvements outweigh regressions with an average improvement of -2.6% across a large swath of the test cases. Of particular note was the move to use SipHash-1-3 instead of SipHash-2-4 for StableHasher which improved 184 benchmark tests by an average of 2.3%! 

Triage done by **@rylev**.
Revision range: [7c96e40..74864f](https://perf.rust-lang.org/?start=7c96e40da81165beef4f273f44e96eeef5a1bd30&end=74864fa496997a6498e623f0d2019ccb7eb6dad0&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 3.1%  | [0.2%, 24.4%]   | 11    |
| Regressions ❌ <br /> (secondary)  | 4.9%  | [0.4%, 37.4%]   | 32    |
| Improvements ✅ <br /> (primary)   | -2.9% | [-20.4%, -0.3%] | 205   |
| Improvements ✅ <br /> (secondary) | -4.0% | [-43.5%, -0.3%] | 160   |
| All ❌✅ (primary)                 | -2.6% | [-20.4%, 24.4%] | 216   |


6 Regressions, 8 Improvements, 11 Mixed; 6 of them in rollups
119 artifact comparisons made in total

#### Regressions

Erase query cache values [#109333](https://github.com/rust-lang/rust/pull/109333) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0534655d9b5f61dbd75cf142ec8d2d3f68b550ee&end=f5b8f44e5d5dee0f60cec1729b5a107659779d94&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.2%, 0.6%] | 43    |
| Regressions ❌ <br /> (secondary)  | 0.4% | [0.3%, 0.7%] | 13    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.2%, 0.6%] | 43    |
* Author has some ideas for how to tackle this [here](https://github.com/rust-lang/rust/pull/109333#issuecomment-1509269857) 

Rollup of 7 pull requests [#110012](https://github.com/rust-lang/rust/pull/110012) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f5b8f44e5d5dee0f60cec1729b5a107659779d94&end=de74dab880447f5227030b261dbd0f2bc4f32dba&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6% | [0.6%, 0.7%] | 2     |
| Regressions ❌ <br /> (secondary)  | 1.9% | [1.5%, 2.2%] | 6     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.6% | [0.6%, 0.7%] | 2     |


resolve: Preserve reexport chains in ModChildren [#109500](https://github.com/rust-lang/rust/pull/109500) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=56e0626836d92973cd12cb505179eef9795efc61&end=7201301df6afe8b68c6a8f5d2abba67bbba435ea&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.4%, 1.0%] | 17    |
| Regressions ❌ <br /> (secondary)  | 1.3% | [0.4%, 5.7%] | 22    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.4%, 1.0%] | 17    |
* There are a few more regressions in the post merge perf run, but they seem to follow the same pattern as the regressions found pre-merge. I think we can just take this as a necessary trade off we need to make for the fixes that landed (as identified by @oli-obk [here](https://github.com/rust-lang/rust/pull/109500#issuecomment-1501119286)).


Better diagnostic when pattern matching tuple structs [#109760](https://github.com/rust-lang/rust/pull/109760) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=39bf7777aab9ac1f6b0802cd52cd91d6e021aa91&end=696aaad58c57a589f6fb2ecff5bae2eec581cb71&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 6.4% | [3.1%, 9.1%] | 3     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 6.4% | [3.1%, 9.1%] | 3     |
* Looks like the regression was a blip as [the next run reverses the regressions](https://perf.rust-lang.org/compare.html?start=696aaad58c57a589f6fb2ecff5bae2eec581cb71&end=3c2e2dd5c516acc60ababd12e5dba684d71c2315&stat=instructions:u).


Rollup of 3 pull requests [#110401](https://github.com/rust-lang/rust/pull/110401) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=18109d5032b0fd95ae81e30857a71e31e263044a&end=1b50ea9abb65b33aac7285dbe36b37f9e33381a2&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.3%] | 5     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.3%] | 5     |
* This is likely noise (bitmaps is a fairly noisy benchmark).


Bypass the varint path when encoding InitMask [#110343](https://github.com/rust-lang/rust/pull/110343) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=31656e7295ebd5f2f6597f10c011e2ac4ba3ef39&end=56e28e904d6b3404abaaeb65d33636cc35ca3f4b&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.1% | [0.2%, 2.9%] | 11    |
| Regressions ❌ <br /> (secondary)  | 3.7% | [0.2%, 8.1%] | 11    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.1% | [0.2%, 2.9%] | 11    |
* Marked as triaged since this was identified as most likely being noise. 


#### Improvements

Use SipHash-1-3 instead of SipHash-2-4 for StableHasher [#107925](https://github.com/rust-lang/rust/pull/107925) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b2b676d886ded452125712a304c524c08360f916&end=2e486be8d29d198d48bc26bfce5712a4822814f5&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -               | 0     |
| Improvements ✅ <br /> (primary)   | -2.3% | [-4.0%, -0.2%]  | 184   |
| Improvements ✅ <br /> (secondary) | -2.6% | [-32.1%, -0.2%] | 153   |
| All ❌✅ (primary)                 | -2.3% | [-4.0%, -0.2%]  | 184   |


resolve: Restore some effective visibility optimizations [#109437](https://github.com/rust-lang/rust/pull/109437) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2e486be8d29d198d48bc26bfce5712a4822814f5&end=2eaeb1eee1b21772de8b935236d16ff8e03fdcf5&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.3%] | 6     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.6%, -0.3%] | 12    |
| All ❌✅ (primary)                 | -0.3% | [-0.4%, -0.3%] | 6     |


Rollup of 6 pull requests [#110024](https://github.com/rust-lang/rust/pull/110024) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=28a29282f6dde2e4aba6e1e4cfea5c9430a00217&end=c934ce9e0a267340920a8bef96d7c59a46910c55&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.7%, -0.6%] | 2     |
| Improvements ✅ <br /> (secondary) | -1.8% | [-2.1%, -1.5%] | 6     |
| All ❌✅ (primary)                 | -0.7% | [-0.7%, -0.6%] | 2     |


Rollup of 6 pull requests [#110127](https://github.com/rust-lang/rust/pull/110127) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=696aaad58c57a589f6fb2ecff5bae2eec581cb71&end=3c2e2dd5c516acc60ababd12e5dba684d71c2315&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -5.9% | [-8.4%, -3.0%] | 3     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -5.9% | [-8.4%, -3.0%] | 3     |


`rustc_metadata`: Filter encoded data more aggressively using DefKind [#109765](https://github.com/rust-lang/rust/pull/109765) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8e1162f07e8b7d59f6a0e0a5576352d888defa78&end=dfe024e1041d1cba1d3191024de3b7128c6734e6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.7%, 0.7%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-1.8%, -0.2%] | 101   |
| Improvements ✅ <br /> (secondary) | -1.2% | [-3.6%, -0.1%] | 34    |
| All ❌✅ (primary)                 | -0.9% | [-1.8%, 0.7%]  | 102   |


Update cargo [#110198](https://github.com/rust-lang/rust/pull/110198) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=87a2408b06e7651f078a09f627940554da6137d5&end=9df3a39fb30575d808e70800f9fad5362aac57a2&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.1% | [-1.1%, -1.1%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -1.1% | [-1.1%, -1.1%] | 1     |


resolve: Pre-compute non-reexport module children [#110160](https://github.com/rust-lang/rust/pull/110160) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=367661b1fc58239fa5df5f472ad2047f97dc5465&end=7a78c4ffd56f11d3a84c99a1cc737cf7bde2660d&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-1.5%, -0.2%] | 26    |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 1     |
| All ❌✅ (primary)                 | -0.8% | [-1.5%, -0.2%] | 26    |


Implement StableHasher::write_u128 via write_u64 [#110410](https://github.com/rust-lang/rust/pull/110410) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e279f902f31af1e111f2a951781c9eed82f8c360&end=386025117a6b7cd9e7f7c96946793db2ec8aa24c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-2.8%, -0.2%] | 13    |
| Improvements ✅ <br /> (secondary) | -1.9% | [-7.5%, -0.2%] | 24    |
| All ❌✅ (primary)                 | -0.7% | [-2.8%, -0.2%] | 13    |


#### Mixed

Check pattern refutability on THIR [#108504](https://github.com/rust-lang/rust/pull/108504) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ce3cb03927f711f653ae2937c10ba40a5ede62c7&end=0534655d9b5f61dbd75cf142ec8d2d3f68b550ee&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.3%, 0.3%]   | 3     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.5%, -0.2%] | 4     |
| Improvements ✅ <br /> (secondary) | -3.0% | [-3.2%, -2.8%] | 6     |
| All ❌✅ (primary)                 | -0.4% | [-0.5%, -0.2%] | 4     |
* Marked as triaged since the improvements outweigh the regressions and the regressions are small and in secondary benchmarks.


Refactor unwind in MIR [#102906](https://github.com/rust-lang/rust/pull/102906) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b6f6104a1f62a0eec7d2e2ccdc07709fcc4c83f0&end=da140814682407ee326d36f5256bc883899a7388&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.1%  | [0.3%, 1.9%]   | 2     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.6%, -0.3%] | 10    |
| Improvements ✅ <br /> (secondary) | -0.6% | [-0.8%, -0.2%] | 8     |
| All ❌✅ (primary)                 | -0.2% | [-0.6%, 1.9%]  | 12    |
* Perf wins outweigh losses.


Make elaboration generic over input [#110031](https://github.com/rust-lang/rust/pull/110031) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d1be642ce3c24d1a0517c9bf91af926740618b01&end=f8ed97ecc11a7d8cd392607ed5a4f6592496c880&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 2.0%  | [2.0%, 2.0%]   | 1     |
| Improvements ✅ <br /> (primary)   | -1.1% | [-2.0%, -0.4%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.5%, -0.5%] | 1     |
| All ❌✅ (primary)                 | -1.1% | [-2.0%, -0.4%] | 3     |
* Not enough perf changes here to be a problem.


Make elaboration generic over input [#109900](https://github.com/rust-lang/rust/pull/109900) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=825c70658e0190bccd93d477907b06e05ad9ccc3&end=67e273ba0e8d0bacc98905c0e536b249f53fc011&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.3%, 1.0%]   | 8     |
| Regressions ❌ <br /> (secondary)  | 13.9% | [0.2%, 29.6%]  | 6     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-1.5%, -0.3%] | 13    |
| Improvements ✅ <br /> (secondary) | -1.1% | [-1.8%, -0.1%] | 14    |
| All ❌✅ (primary)                 | -0.2% | [-1.5%, 1.0%]  | 21    |
* Not enough perf changes here to be a problem.


Permit MIR inlining without #[inline] [#109247](https://github.com/rust-lang/rust/pull/109247) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=23eb90ffa77943153d203c3d184c182490d758e7&end=5546cb64f6fbba70529582bbe58a40ba4a8ed9fc&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0%  | [0.2%, 25.6%]   | 135   |
| Regressions ❌ <br /> (secondary)  | 1.4%  | [0.2%, 8.8%]    | 97    |
| Improvements ✅ <br /> (primary)   | -1.8% | [-5.3%, -0.3%]  | 52    |
| Improvements ✅ <br /> (secondary) | -9.6% | [-43.2%, -1.2%] | 21    |
| All ❌✅ (primary)                 | 0.2%  | [-5.3%, 25.6%]  | 187   |
* perf may be worse than in the original perf run before merge. Of particular concern is that the cargo incr-patched: println test case has regressed significantly (42% increase in wall time). Pinged the author and reviewer about this.


Alloc hir::Lit in an arena to remove the destructor from Expr [#109588](https://github.com/rust-lang/rust/pull/109588) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5546cb64f6fbba70529582bbe58a40ba4a8ed9fc&end=53ac4f8e2fc15e49ef3a04f98622a9b9db755fd4&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.6%  | [0.7%, 2.7%]   | 4     |
| Regressions ❌ <br /> (secondary)  | 6.3%  | [5.0%, 8.1%]   | 6     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.6%, -0.1%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-2.4%, -0.3%] | 21    |
| All ❌✅ (primary)                 | 0.7%  | [-0.6%, 2.7%]  | 7     |
* Does look like something has made keccak noisy again. The bump *starts* with this PR but I suppose that could be due to the the previous change kicking off some bimodal behaivor. 


Alloc hir::Lit in an arena to remove the destructor from Expr [#110440](https://github.com/rust-lang/rust/pull/110440) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=53ac4f8e2fc15e49ef3a04f98622a9b9db755fd4&end=bdb32bd4bbcabb0d32a04a0b45e6a8ceaa5e54d6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.3%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.2%, 1.1%]   | 9     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-0.9%, -0.7%] | 4     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.3% | [-0.9%, 0.3%]  | 7     |


Remove some suspicious cast truncations [#110367](https://github.com/rust-lang/rust/pull/110367) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bdb32bd4bbcabb0d32a04a0b45e6a8ceaa5e54d6&end=e49122fb1ca87a6c3e3c22abb315fc75cfe8daed&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 1.1%]   | 52    |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.3%, 0.8%]   | 13    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.9% | [-1.5%, -0.2%] | 6     |
| All ❌✅ (primary)                 | 0.4%  | [0.2%, 1.1%]   | 52    |
* Looks like this was fixed in #110410 so marking as triaged


Rollup of 9 pull requests [#110458](https://github.com/rust-lang/rust/pull/110458) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e49122fb1ca87a6c3e3c22abb315fc75cfe8daed&end=31656e7295ebd5f2f6597f10c011e2ac4ba3ef39&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 1.2%  | [1.2%, 1.2%]   | 3     |
| Improvements ✅ <br /> (primary)   | -1.1% | [-2.9%, -0.3%] | 12    |
| Improvements ✅ <br /> (secondary) | -3.5% | [-7.7%, -0.2%] | 11    |
| All ❌✅ (primary)                 | -1.1% | [-2.9%, -0.3%] | 12    |
* Looks like this is all noise: keccak, cranelift-codegen and diesel have just started being noisy.


Rollup of 7 pull requests [#110481](https://github.com/rust-lang/rust/pull/110481) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=386025117a6b7cd9e7f7c96946793db2ec8aa24c&end=74864fa496997a6498e623f0d2019ccb7eb6dad0&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.5%, 0.5%]    | 3     |
| Improvements ✅ <br /> (primary)   | -7.9% | [-19.2%, -0.6%] | 3     |
| Improvements ✅ <br /> (secondary) | -1.6% | [-1.8%, -1.3%]  | 2     |
| All ❌✅ (primary)                 | -7.9% | [-19.2%, -0.6%] | 3     |
* regression is noise


ci: add a runner for vanilla LLVM 16 [#110242](https://github.com/rust-lang/rust/pull/110242) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=74864fa496997a6498e623f0d2019ccb7eb6dad0&end=5fe3528be5ef12be3d12c7a9ee1b0bff9e3b35e4&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.7%  | [0.8%, 2.8%]   | 4     |
| Regressions ❌ <br /> (secondary)  | 6.4%  | [5.2%, 8.0%]   | 6     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-0.6%, -0.6%] | 3     |
| All ❌✅ (primary)                 | 1.3%  | [-0.2%, 2.8%]  | 5     |
* Noise

