# 2024-03-26 Triage Log

An overall fairly quiet week with the unfortunate one exception of large instruction count and binary size regressions caused by changes in const evaluation. This was largely balanced out (at least in instruction count) by a group of small improvements, but the compiler did end up 0.2% slower on average across 97 benchmarks.

Triage done by **@rylev**.
Revision range: [21d94a3..73476d](https://perf.rust-lang.org/?start=21d94a3d2c63cacf8eaf9d0ca770c0b450c558d4&end=73476d49904751f8d90ce904e16dfbc278083d2c&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0%  | [0.2%, 3.2%]   | 56    |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.1%, 1.9%]   | 38    |
| Improvements ✅ <br /> (primary)   | -0.8% | [-1.5%, -0.2%] | 41    |
| Improvements ✅ <br /> (secondary) | -1.2% | [-5.2%, -0.4%] | 13    |
| All ❌✅ (primary)                 | 0.2%  | [-1.5%, 3.2%]  | 97    |


4 Regressions, 6 Improvements, 2 Mixed; 4 of them in rollups
63 artifact comparisons made in total

#### Regressions

recursively evaluate the constants in everything that is 'mentioned' [#122568](https://github.com/rust-lang/rust/pull/122568) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=47dd709bedda8127e8daec33327e0a9d0cdae845&end=df8ac8f1d74cffb96a93ae702d16e224f5b9ee8c&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0% | [0.3%, 2.2%] | 67    |
| Regressions ❌ <br /> (secondary)  | 0.8% | [0.2%, 2.9%] | 24    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.0% | [0.3%, 2.2%] | 67    |
- An unfortunately large regression in instruction count that has to happen for correctness reasons.
- Additional regressions in binary size and an issue has been opened for it: #122936


Rollup of 8 pull requests [#122900](https://github.com/rust-lang/rust/pull/122900) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=85e449a3237e82c9ade8936a82bd4fc64cfe1057&end=0ad5e0d2deb8ac4b079923f3cc5a3a1c63efe4c8&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -    | -            | 0     |
| Regressions ❌ <br /> (secondary)  | 0.5% | [0.4%, 0.6%] | 11    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | -    | -            | 0     |
- Seems that [#122784](https://github.com/rust-lang/rust/pull/122784) is the cause. Author and reviewer were pinged.


Replace visibility test with reachability test in dead code detection [#119552](https://github.com/rust-lang/rust/pull/119552) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0ad5e0d2deb8ac4b079923f3cc5a3a1c63efe4c8&end=c3087265993c74057fdbab07b44b80a55045070b&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 2.1% | [1.0%, 3.2%] | 4     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 2.1% | [1.0%, 3.2%] | 4     |
- More warnings are now emitted from ripgrep so this is to be expected


Rollup of 9 pull requests [#122966](https://github.com/rust-lang/rust/pull/122966) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9b8d12cf4c2311203aea83315552b15993bd4f81&end=548e14b43963882fb758deb89e8258d9b8c2fc2a&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.3%, 0.3%] | 1     |
| Regressions ❌ <br /> (secondary)  | 0.3% | [0.2%, 0.4%] | 6     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.3%, 0.3%] | 1     |
- The regressions are probably too small here for us to need to dig much deeper.


#### Improvements

clean up `Sized` checking [#122493](https://github.com/rust-lang/rust/pull/122493) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=148a41c6b5687f941c5256d9ef8145eb03b72094&end=196ff446d20088406b9d69978dddccc4682bd006&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.6%, -0.3%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-3.2%, -0.3%] | 11    |
| All ❌✅ (primary)                 | -0.4% | [-0.6%, -0.3%] | 2     |


Move more intrinsics to rustc_intrinsic [#122037](https://github.com/rust-lang/rust/pull/122037) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f296c162d8c6f84bcfee99c152d4fd63aaef3e38&end=200e3f7995e231535fdea3be9cb9a3f098b4c856&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.2%] | 4     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.3% | [-0.3%, -0.2%] | 4     |


Update cargo [#122753](https://github.com/rust-lang/rust/pull/122753) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bd459c2877fe909ea57952ea2543b727e321f183&end=a77c20c4b987e74eb1a867d21d1edb8035a11660&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-0.9%, -0.5%] | 5     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-0.8%, -0.4%] | 8     |
| All ❌✅ (primary)                 | -0.8% | [-0.9%, -0.5%] | 5     |


select Vec::from_iter impls in a const block to optimize compile times [#122785](https://github.com/rust-lang/rust/pull/122785) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a0569fa8f91b5271e92d2f73fd252de7d3d05b9c&end=0ad927c0c07b65fc0dae37105e09c877c87c296a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-1.5%, -0.3%] | 10    |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.6% | [-1.5%, -0.3%] | 10    |


Replace `mir_built` query with a hook and use mir_const everywhere instead [#122721](https://github.com/rust-lang/rust/pull/122721) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0824b300eb0dae5d9ed59719d3f2732016683d66&end=13dac8fb731945ebc116cc65f23a260930e774e0&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.5%, 0.5%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.9%, -0.2%] | 17    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.8%, -0.2%] | 11    |
| All ❌✅ (primary)                 | -0.3% | [-0.9%, 0.5%]  | 18    |


Don't emit load metadata in debug mode [#122849](https://github.com/rust-lang/rust/pull/122849) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8b9e47c136aeee998effdcae356e134b8de65891&end=73476d49904751f8d90ce904e16dfbc278083d2c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-1.1%, -0.4%] | 13    |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.7% | [-1.1%, -0.4%] | 13    |


#### Mixed

Rollup of 10 pull requests [#122735](https://github.com/rust-lang/rust/pull/122735) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a385e5667c11098a01368c06e7c0c9236cd477cc&end=e760daa6a729b3d52a38804e9766f7d89dc27357&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.1%, 0.6%]   | 5     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.8%, -0.3%] | 11    |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 1     |
| All ❌✅ (primary)                 | -0.7% | [-0.8%, -0.3%] | 11    |
- The improvements outweigh the regressions so there's not a huge incentive to investigate further.


Rollup of 8 pull requests [#122830](https://github.com/rust-lang/rust/pull/122830) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7d01878bd0d1c4383c1158adeff0c392446ea3a2&end=a0569fa8f91b5271e92d2f73fd252de7d3d05b9c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.1%  | [0.1%, 0.1%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -1.2% | [-1.7%, -0.8%] | 8     |
| All ❌✅ (primary)                 | -0.3% | [-0.4%, -0.2%] | 2     |
- With only small regressions on stress tests, I think it's fine if we don't investigate this too deeply.

