/*
 * NetHSM
 *
 * All endpoints expect exactly the specified JSON. Additional properties will cause a Bad Request Error (400). All HTTP errors contain a JSON structure with an explanation of type string. All [base64](https://tools.ietf.org/html/rfc4648#section-4) encoded values are Big Endian.
 *
 * The version of the OpenAPI document: v1
 * Contact: Nitrokey <info@nitrokey.com>
 * Generated by: https://openapi-generator.tech
 */

/// DistinguishedName : Data used for creation of CSRs. If subjectAltNames is omitted, it is set to the same value as commonName. If it is set to an empty list, no SAN Extension is added.

#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
#[non_exhaustive]
pub struct DistinguishedName {
    #[serde(rename = "countryName", skip_serializing_if = "Option::is_none")]
    pub country_name: Option<String>,
    #[serde(
        rename = "stateOrProvinceName",
        skip_serializing_if = "Option::is_none"
    )]
    pub state_or_province_name: Option<String>,
    #[serde(rename = "localityName", skip_serializing_if = "Option::is_none")]
    pub locality_name: Option<String>,
    #[serde(rename = "organizationName", skip_serializing_if = "Option::is_none")]
    pub organization_name: Option<String>,
    #[serde(
        rename = "organizationalUnitName",
        skip_serializing_if = "Option::is_none"
    )]
    pub organizational_unit_name: Option<String>,
    #[serde(rename = "commonName")]
    pub common_name: String,
    #[serde(rename = "emailAddress", skip_serializing_if = "Option::is_none")]
    pub email_address: Option<String>,
    #[serde(rename = "subjectAltNames", skip_serializing_if = "Option::is_none")]
    pub subject_alt_names: Option<Vec<String>>,
}

impl DistinguishedName {
    /// Data used for creation of CSRs. If subjectAltNames is omitted, it is set to the same value as commonName. If it is set to an empty list, no SAN Extension is added.
    pub fn new(common_name: String) -> DistinguishedName {
        DistinguishedName {
            country_name: None,
            state_or_province_name: None,
            locality_name: None,
            organization_name: None,
            organizational_unit_name: None,
            common_name,
            email_address: None,
            subject_alt_names: None,
        }
    }
}
