#include "environ.h"
#include <cstdlib>

#ifdef __APPLE__
#include <crt_externs.h>
#endif

char **get_environ() {
#ifdef __APPLE__
  // on macOS, environ is not directly accessible
  return *_NSGetEnviron();
#else
  /* some platforms fail to expose environ in a header (e.g. FreeBSD), so
   * declare it ourselves and assume it will be available when linking
   */
  extern char **environ;

  return environ;
#endif
}
