/*--------------------------------------------------------------------
 * Symbols referenced in this file:
 * - ScanKeywords
 * - ScanKeywords_kw_string
 * - ScanKeywords_kw_offsets
 * - ScanKeywords_hash_func
 *--------------------------------------------------------------------
 */

/*-------------------------------------------------------------------------
 *
 * kwlist_d.h
 *    List of keywords represented as a ScanKeywordList.
 *
 * Portions Copyright (c) 1996-2020, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * NOTES
 *  ******************************
 *  *** DO NOT EDIT THIS FILE! ***
 *  ******************************
 *
 *  It has been GENERATED by src/tools/gen_keywordlist.pl
 *
 *-------------------------------------------------------------------------
 */

#ifndef KWLIST_D_H
#define KWLIST_D_H

#include "common/kwlookup.h"

static const char ScanKeywords_kw_string[] =
	"abort\0"
	"absolute\0"
	"access\0"
	"action\0"
	"add\0"
	"admin\0"
	"after\0"
	"aggregate\0"
	"all\0"
	"also\0"
	"alter\0"
	"always\0"
	"analyse\0"
	"analyze\0"
	"and\0"
	"any\0"
	"array\0"
	"as\0"
	"asc\0"
	"assertion\0"
	"assignment\0"
	"asymmetric\0"
	"at\0"
	"attach\0"
	"attribute\0"
	"authorization\0"
	"backward\0"
	"before\0"
	"begin\0"
	"between\0"
	"bigint\0"
	"binary\0"
	"bit\0"
	"boolean\0"
	"both\0"
	"by\0"
	"cache\0"
	"call\0"
	"called\0"
	"cascade\0"
	"cascaded\0"
	"case\0"
	"cast\0"
	"catalog\0"
	"chain\0"
	"char\0"
	"character\0"
	"characteristics\0"
	"check\0"
	"checkpoint\0"
	"class\0"
	"close\0"
	"cluster\0"
	"coalesce\0"
	"collate\0"
	"collation\0"
	"column\0"
	"columns\0"
	"comment\0"
	"comments\0"
	"commit\0"
	"committed\0"
	"concurrently\0"
	"configuration\0"
	"conflict\0"
	"connection\0"
	"constraint\0"
	"constraints\0"
	"content\0"
	"continue\0"
	"conversion\0"
	"copy\0"
	"cost\0"
	"create\0"
	"cross\0"
	"csv\0"
	"cube\0"
	"current\0"
	"current_catalog\0"
	"current_date\0"
	"current_role\0"
	"current_schema\0"
	"current_time\0"
	"current_timestamp\0"
	"current_user\0"
	"cursor\0"
	"cycle\0"
	"data\0"
	"database\0"
	"day\0"
	"deallocate\0"
	"dec\0"
	"decimal\0"
	"declare\0"
	"default\0"
	"defaults\0"
	"deferrable\0"
	"deferred\0"
	"definer\0"
	"delete\0"
	"delimiter\0"
	"delimiters\0"
	"depends\0"
	"desc\0"
	"detach\0"
	"dictionary\0"
	"disable\0"
	"discard\0"
	"distinct\0"
	"do\0"
	"document\0"
	"domain\0"
	"double\0"
	"drop\0"
	"each\0"
	"else\0"
	"enable\0"
	"encoding\0"
	"encrypted\0"
	"end\0"
	"enum\0"
	"escape\0"
	"event\0"
	"except\0"
	"exclude\0"
	"excluding\0"
	"exclusive\0"
	"execute\0"
	"exists\0"
	"explain\0"
	"expression\0"
	"extension\0"
	"external\0"
	"extract\0"
	"false\0"
	"family\0"
	"fetch\0"
	"filter\0"
	"first\0"
	"float\0"
	"following\0"
	"for\0"
	"force\0"
	"foreign\0"
	"forward\0"
	"freeze\0"
	"from\0"
	"full\0"
	"function\0"
	"functions\0"
	"generated\0"
	"global\0"
	"grant\0"
	"granted\0"
	"greatest\0"
	"group\0"
	"grouping\0"
	"groups\0"
	"handler\0"
	"having\0"
	"header\0"
	"hold\0"
	"hour\0"
	"identity\0"
	"if\0"
	"ilike\0"
	"immediate\0"
	"immutable\0"
	"implicit\0"
	"import\0"
	"in\0"
	"include\0"
	"including\0"
	"increment\0"
	"index\0"
	"indexes\0"
	"inherit\0"
	"inherits\0"
	"initially\0"
	"inline\0"
	"inner\0"
	"inout\0"
	"input\0"
	"insensitive\0"
	"insert\0"
	"instead\0"
	"int\0"
	"integer\0"
	"intersect\0"
	"interval\0"
	"into\0"
	"invoker\0"
	"is\0"
	"isnull\0"
	"isolation\0"
	"join\0"
	"key\0"
	"label\0"
	"language\0"
	"large\0"
	"last\0"
	"lateral\0"
	"leading\0"
	"leakproof\0"
	"least\0"
	"left\0"
	"level\0"
	"like\0"
	"limit\0"
	"listen\0"
	"load\0"
	"local\0"
	"localtime\0"
	"localtimestamp\0"
	"location\0"
	"lock\0"
	"locked\0"
	"logged\0"
	"mapping\0"
	"match\0"
	"materialized\0"
	"maxvalue\0"
	"method\0"
	"minute\0"
	"minvalue\0"
	"mode\0"
	"month\0"
	"move\0"
	"name\0"
	"names\0"
	"national\0"
	"natural\0"
	"nchar\0"
	"new\0"
	"next\0"
	"nfc\0"
	"nfd\0"
	"nfkc\0"
	"nfkd\0"
	"no\0"
	"none\0"
	"normalize\0"
	"normalized\0"
	"not\0"
	"nothing\0"
	"notify\0"
	"notnull\0"
	"nowait\0"
	"null\0"
	"nullif\0"
	"nulls\0"
	"numeric\0"
	"object\0"
	"of\0"
	"off\0"
	"offset\0"
	"oids\0"
	"old\0"
	"on\0"
	"only\0"
	"operator\0"
	"option\0"
	"options\0"
	"or\0"
	"order\0"
	"ordinality\0"
	"others\0"
	"out\0"
	"outer\0"
	"over\0"
	"overlaps\0"
	"overlay\0"
	"overriding\0"
	"owned\0"
	"owner\0"
	"parallel\0"
	"parser\0"
	"partial\0"
	"partition\0"
	"passing\0"
	"password\0"
	"placing\0"
	"plans\0"
	"policy\0"
	"position\0"
	"preceding\0"
	"precision\0"
	"prepare\0"
	"prepared\0"
	"preserve\0"
	"primary\0"
	"prior\0"
	"privileges\0"
	"procedural\0"
	"procedure\0"
	"procedures\0"
	"program\0"
	"publication\0"
	"quote\0"
	"range\0"
	"read\0"
	"real\0"
	"reassign\0"
	"recheck\0"
	"recursive\0"
	"ref\0"
	"references\0"
	"referencing\0"
	"refresh\0"
	"reindex\0"
	"relative\0"
	"release\0"
	"rename\0"
	"repeatable\0"
	"replace\0"
	"replica\0"
	"reset\0"
	"restart\0"
	"restrict\0"
	"returning\0"
	"returns\0"
	"revoke\0"
	"right\0"
	"role\0"
	"rollback\0"
	"rollup\0"
	"routine\0"
	"routines\0"
	"row\0"
	"rows\0"
	"rule\0"
	"savepoint\0"
	"schema\0"
	"schemas\0"
	"scroll\0"
	"search\0"
	"second\0"
	"security\0"
	"select\0"
	"sequence\0"
	"sequences\0"
	"serializable\0"
	"server\0"
	"session\0"
	"session_user\0"
	"set\0"
	"setof\0"
	"sets\0"
	"share\0"
	"show\0"
	"similar\0"
	"simple\0"
	"skip\0"
	"smallint\0"
	"snapshot\0"
	"some\0"
	"sql\0"
	"stable\0"
	"standalone\0"
	"start\0"
	"statement\0"
	"statistics\0"
	"stdin\0"
	"stdout\0"
	"storage\0"
	"stored\0"
	"strict\0"
	"strip\0"
	"subscription\0"
	"substring\0"
	"support\0"
	"symmetric\0"
	"sysid\0"
	"system\0"
	"table\0"
	"tables\0"
	"tablesample\0"
	"tablespace\0"
	"temp\0"
	"template\0"
	"temporary\0"
	"text\0"
	"then\0"
	"ties\0"
	"time\0"
	"timestamp\0"
	"to\0"
	"trailing\0"
	"transaction\0"
	"transform\0"
	"treat\0"
	"trigger\0"
	"trim\0"
	"true\0"
	"truncate\0"
	"trusted\0"
	"type\0"
	"types\0"
	"uescape\0"
	"unbounded\0"
	"uncommitted\0"
	"unencrypted\0"
	"union\0"
	"unique\0"
	"unknown\0"
	"unlisten\0"
	"unlogged\0"
	"until\0"
	"update\0"
	"user\0"
	"using\0"
	"vacuum\0"
	"valid\0"
	"validate\0"
	"validator\0"
	"value\0"
	"values\0"
	"varchar\0"
	"variadic\0"
	"varying\0"
	"verbose\0"
	"version\0"
	"view\0"
	"views\0"
	"volatile\0"
	"when\0"
	"where\0"
	"whitespace\0"
	"window\0"
	"with\0"
	"within\0"
	"without\0"
	"work\0"
	"wrapper\0"
	"write\0"
	"xml\0"
	"xmlattributes\0"
	"xmlconcat\0"
	"xmlelement\0"
	"xmlexists\0"
	"xmlforest\0"
	"xmlnamespaces\0"
	"xmlparse\0"
	"xmlpi\0"
	"xmlroot\0"
	"xmlserialize\0"
	"xmltable\0"
	"year\0"
	"yes\0"
	"zone";

static const uint16 ScanKeywords_kw_offsets[] = {
	0,
	6,
	15,
	22,
	29,
	33,
	39,
	45,
	55,
	59,
	64,
	70,
	77,
	85,
	93,
	97,
	101,
	107,
	110,
	114,
	124,
	135,
	146,
	149,
	156,
	166,
	180,
	189,
	196,
	202,
	210,
	217,
	224,
	228,
	236,
	241,
	244,
	250,
	255,
	262,
	270,
	279,
	284,
	289,
	297,
	303,
	308,
	318,
	334,
	340,
	351,
	357,
	363,
	371,
	380,
	388,
	398,
	405,
	413,
	421,
	430,
	437,
	447,
	460,
	474,
	483,
	494,
	505,
	517,
	525,
	534,
	545,
	550,
	555,
	562,
	568,
	572,
	577,
	585,
	601,
	614,
	627,
	642,
	655,
	673,
	686,
	693,
	699,
	704,
	713,
	717,
	728,
	732,
	740,
	748,
	756,
	765,
	776,
	785,
	793,
	800,
	810,
	821,
	829,
	834,
	841,
	852,
	860,
	868,
	877,
	880,
	889,
	896,
	903,
	908,
	913,
	918,
	925,
	934,
	944,
	948,
	953,
	960,
	966,
	973,
	981,
	991,
	1001,
	1009,
	1016,
	1024,
	1035,
	1045,
	1054,
	1062,
	1068,
	1075,
	1081,
	1088,
	1094,
	1100,
	1110,
	1114,
	1120,
	1128,
	1136,
	1143,
	1148,
	1153,
	1162,
	1172,
	1182,
	1189,
	1195,
	1203,
	1212,
	1218,
	1227,
	1234,
	1242,
	1249,
	1256,
	1261,
	1266,
	1275,
	1278,
	1284,
	1294,
	1304,
	1313,
	1320,
	1323,
	1331,
	1341,
	1351,
	1357,
	1365,
	1373,
	1382,
	1392,
	1399,
	1405,
	1411,
	1417,
	1429,
	1436,
	1444,
	1448,
	1456,
	1466,
	1475,
	1480,
	1488,
	1491,
	1498,
	1508,
	1513,
	1517,
	1523,
	1532,
	1538,
	1543,
	1551,
	1559,
	1569,
	1575,
	1580,
	1586,
	1591,
	1597,
	1604,
	1609,
	1615,
	1625,
	1640,
	1649,
	1654,
	1661,
	1668,
	1676,
	1682,
	1695,
	1704,
	1711,
	1718,
	1727,
	1732,
	1738,
	1743,
	1748,
	1754,
	1763,
	1771,
	1777,
	1781,
	1786,
	1790,
	1794,
	1799,
	1804,
	1807,
	1812,
	1822,
	1833,
	1837,
	1845,
	1852,
	1860,
	1867,
	1872,
	1879,
	1885,
	1893,
	1900,
	1903,
	1907,
	1914,
	1919,
	1923,
	1926,
	1931,
	1940,
	1947,
	1955,
	1958,
	1964,
	1975,
	1982,
	1986,
	1992,
	1997,
	2006,
	2014,
	2025,
	2031,
	2037,
	2046,
	2053,
	2061,
	2071,
	2079,
	2088,
	2096,
	2102,
	2109,
	2118,
	2128,
	2138,
	2146,
	2155,
	2164,
	2172,
	2178,
	2189,
	2200,
	2210,
	2221,
	2229,
	2241,
	2247,
	2253,
	2258,
	2263,
	2272,
	2280,
	2290,
	2294,
	2305,
	2317,
	2325,
	2333,
	2342,
	2350,
	2357,
	2368,
	2376,
	2384,
	2390,
	2398,
	2407,
	2417,
	2425,
	2432,
	2438,
	2443,
	2452,
	2459,
	2467,
	2476,
	2480,
	2485,
	2490,
	2500,
	2507,
	2515,
	2522,
	2529,
	2536,
	2545,
	2552,
	2561,
	2571,
	2584,
	2591,
	2599,
	2612,
	2616,
	2622,
	2627,
	2633,
	2638,
	2646,
	2653,
	2658,
	2667,
	2676,
	2681,
	2685,
	2692,
	2703,
	2709,
	2719,
	2730,
	2736,
	2743,
	2751,
	2758,
	2765,
	2771,
	2784,
	2794,
	2802,
	2812,
	2818,
	2825,
	2831,
	2838,
	2850,
	2861,
	2866,
	2875,
	2885,
	2890,
	2895,
	2900,
	2905,
	2915,
	2918,
	2927,
	2939,
	2949,
	2955,
	2963,
	2968,
	2973,
	2982,
	2990,
	2995,
	3001,
	3009,
	3019,
	3031,
	3043,
	3049,
	3056,
	3064,
	3073,
	3082,
	3088,
	3095,
	3100,
	3106,
	3113,
	3119,
	3128,
	3138,
	3144,
	3151,
	3159,
	3168,
	3176,
	3184,
	3192,
	3197,
	3203,
	3212,
	3217,
	3223,
	3234,
	3241,
	3246,
	3253,
	3261,
	3266,
	3274,
	3280,
	3284,
	3298,
	3308,
	3319,
	3329,
	3339,
	3353,
	3362,
	3368,
	3376,
	3389,
	3398,
	3403,
	3407,
};

#define SCANKEYWORDS_NUM_KEYWORDS 450

static int
ScanKeywords_hash_func(const void *key, size_t keylen)
{
	static const int16 h[901] = {
		  -172,  32767,  32767,  32767,      0,     56,    362,  32767,
		     0,     90,   -251,    332,  32767,     66,    298,      0,
		 32767,     88,     27,     22,   -125,    317,      0,  32767,
		   -35,      0,  32767,  32767,  32767,     52,  32767,    275,
		 32767,   -277,  32767,  32767,    316,    177,  32767,      0,
		   398,     58,    272,    -88,      0,   -147,    242,    143,
		   401,      0,  32767,      0,    293,    355,      0,      0,
		   303,  32767,    225,    580,      0,    378,      0,      0,
		 32767,    -25,   -312,  32767,   -210,      0,  32767,    -19,
		 32767,     91,    307,    354,  32767,  32767,    -18,     36,
		 32767,  32767,    402,    292,    165,    274,      0,  32767,
		    10,    -20,  32767,    294,  32767,   -622,    326,  32767,
		  -128,      0,     33,  32767,  32767,    325,  32767,    276,
		   343,  32767,     96,    173,  32767,  32767,  32767,      0,
		 32767,    320,   -128,  32767,    357,     24,     -9,    427,
		 32767,  32767,      0,  32767,      0,      0,  32767,  32767,
		   405,  32767,    125,  32767,      0,  32767,    -40,  32767,
		     0,     80,      0,  32767,      0,     95,   -146,      0,
		 32767,     26,    165,  32767,     41,  32767,    418,  32767,
		 32767,     40,  32767,    147,  32767,  32767,  32767,     91,
		   110,      9,    305,   -340,  32767,    103,  32767,      0,
		   329,  32767,  32767,    310,  32767,  32767,    147,   -262,
		   422,    393,    382,    136,  32767,    177,      0,  32767,
		 32767,    102,      0,  32767,     83,    141,     28,    167,
		  -421,  32767,     38,    111,      0,    479,  32767,  32767,
		    29,    439,  32767,    427,     -6,    182,  32767,     74,
		 32767,    360,    236,  32767,  32767,    327,    -63,    162,
		   154,    184,     90,    263,    115,    127,    539,    347,
		   -72,  32767,   -159,  32767,   -249,    152,  32767,    357,
		   404,   -110,  32767,    404,    345,  32767,     80,    352,
		   422,     61,  32767,  32767,  32767,    243,    126,    117,
		 32767,      0,  32767,  32767,    208,  32767,  32767,    -20,
		   430,   -195,  32767,  32767,  32767,    118,    -62,  32767,
		 32767,     98,    136,      0,      0,  32767,    261,  32767,
		     0,  32767,    230,     37,    750,    154,  32767,    -86,
		    87,  32767,      6,     61,  32767,    205,  32767,    517,
		   107,     66,    304,  32767,      0,  32767,  32767,  32767,
		   333,  32767,    357,    239,  32767,  32767,    437,    -26,
		 32767,    210,      0,     20,    369,     10,  32767,    -78,
		   616,     70,      0,  32767,     86,  32767,      0,  32767,
		    14,     60,     32,  32767,    373,  32767,   -218,    320,
		 32767,    268,  32767,  32767,    425,    -67,      0,  32767,
		   252,  32767,    -93,    193,   -362,   -140,  32767,   -328,
		 32767,      0,    319,    336,  32767,    121,      0,  32767,
		   207,  32767,    481,   -176,    276,     47,    235,  32767,
		     0,    221,  32767,    228,  32767,     84,  32767,  32767,
		 32767,  32767,  32767,  32767,    290,  32767,  32767,     84,
		  -170,     82,    246,    -43,    201,    155,     -7,    299,
		 32767,  32767,    241,  32767,   -418,  32767,  32767,   -303,
		 32767,  32767,    -40,    308,  32767,      0,    178,    -67,
		 32767,    273,  32767,      0,  32767,     69,    387,  32767,
		   341,      0,      0,    -19,    324,    -88,    166,  32767,
		     6,     20,  32767,     17,     22,    359,  32767,  32767,
		   172,      0,  32767,      0,    206,     88,      0,  32767,
		    35,      0,    275,    114,    339,  32767,  32767,  32767,
		 32767,  32767,    524,      0,    -52,    191,   -115,      9,
		   200,    102,      0,  32767,      3,      0,      0,      0,
		  -288,      0,   -132,  32767,      0,  32767,    300,      0,
		     0,      0,    212,  32767,    260,  32767,   -279,    104,
		   506,      0,    640,     38,    268,  32767,    131,  32767,
		 32767,  32767,  32767,      0,      0,  32767,  32767,     18,
		   100,     44,     67,    270,    245,    283,    224,    -66,
		 32767,  32767,  32767,    -67,  32767,    389,  32767,      0,
		   125,    354,  32767,  32767,    -21,    124,      0,    204,
		 32767,      0,     99,  32767,    267,  32767,      0,  32767,
		 32767,    231,  32767,   -129,   -113,    108,     23,      0,
		     0,  32767,  32767,      0,  32767,    269,  32767,  32767,
		  -133,  32767,   -384,  32767,  32767,      0,  32767,  32767,
		 32767,      0,  32767,  32767,  32767,      0,    322,    424,
		   117,    -29,  32767,  32767,    145,      0,      0,    323,
		   119,  32767,  32767,  32767,    392,   -164,   -143,    -25,
		  -106,      0,     97,  32767,  32767,    235,  32767,      0,
		 32767,    411,    363,  32767,     31,  32767,    443,  32767,
		    76,     29,  32767,    323,  32767,    142,  32767,      0,
		   244,      0,  32767,     28,  32767,      0,    377,     -8,
		   -45,  32767,     37,      0,    350,      0,  32767,  32767,
		    38,    416,  32767,    265,    -78,   -308,    -51,    705,
		 32767,  32767,      0,     66,      0,  32767,  32767,  32767,
		    81,   -250,  32767,      1,    421,  32767,  32767,      0,
		 32767,    401,    198,  32767,    256,    290,    210,  32767,
		 32767,  32767,  32767,      0,    444,    211,    -99,    220,
		    64,  32767,  32767,  32767,  32767,    190,     19,      0,
		   216,  32767,    262,  32767,    404,    562,   -222,      0,
		     0,   -162,  32767,    192,     65,  32767,    150,    191,
		     0,    218,    267,  32767,  32767,  32767,    399,    189,
		   356,    532,      0,  32767,    429,  32767,  32767,     54,
		   279,    151,      0,    353,    394,    176,    215,  32767,
		    15,    153,    137,     92,    420,     47,    253,      0,
		   298,  32767,  32767,  32767,    234,    164,    241,  32767,
		     0,    409,      0,  32767,      0,  32767,      0,     70,
		 32767,  32767,  32767,      0,  32767,  32767,  32767,   -138,
		 32767,  32767,    -46,  32767,     97,  32767,      0,   -126,
		 32767,    169,    322,    392,  32767,      0,  32767,  32767,
		     0,    282,    296,  32767,      0,    403,  32767,    -24,
		 32767,    -34,  32767,  32767,  32767,    418,  32767,      0,
		    97,    238,  32767,    144,    428,  32767,      2,  32767,
		 32767,  32767,    194,   -182,     12,  32767,    391,  32767,
		   880,  32767,  32767,     50,    331,      0,      0,    358,
		    20,  32767,  32767,    222,    317,  32767,      0,    125,
		 32767,      0,  32767,    284,  32767,  32767,    197,      0,
		    63,  32767,      0,    188,  32767,  32767,    147,    190,
		   344,  32767,    -42,  32767,      0,    187,  32767,  32767,
		   350,  32767,      0,      0,    127,  32767,  32767,    161,
		 32767,      0,      0,    382,  32767,  32767,    316,    130,
		 32767,    379,  32767,    383,    368,     93,   -195,      0,
		   233,     73,  32767,    100,  32767,    338,     90,  32767,
		   258,  32767,  32767,    235,    175,  32767,  32767,      0,
		    -9,      0,      0,  32767,  32767,    111,    417,    330,
		     0,      0,    225,  32767,      0,      0,  32767,      0,
		    64,  32767,  32767,     16,    113,     29,      0,  32767,
		 32767,      0,     43,      0,    365,    -41,   -284,      0,
		     0,      0,     61,    314,    255,      0,  32767,    145,
		 32767,   -445,  32767,  32767,    154,
	};

	const unsigned char *k = (const unsigned char *) key;
	uint32		a = 0;
	uint32		b = 3;

	while (keylen--)
	{
		unsigned char c = *k++ | 0x20;

		a = a * 31 + c;
		b = b * 127 + c;
	}
	return h[a % 901] + h[b % 901];
}

const ScanKeywordList ScanKeywords = {
	ScanKeywords_kw_string,
	ScanKeywords_kw_offsets,
	ScanKeywords_hash_func,
	SCANKEYWORDS_NUM_KEYWORDS,
	17
};

#endif							/* KWLIST_D_H */
