% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condition_message_linter.R
\name{condition_message_linter}
\alias{condition_message_linter}
\title{Block usage of \code{paste()} and \code{paste0()} with messaging functions using \code{...}}
\usage{
condition_message_linter()
}
\description{
This linter discourages combining condition functions like \code{\link[=stop]{stop()}} with string concatenation
functions \code{\link[base:paste]{base::paste()}} and \code{\link[base:paste]{base::paste0()}}. This is because
\itemize{
\item \code{stop(paste0(...))} is redundant as it is exactly equivalent to \code{stop(...)}
\item \code{stop(paste(...))} is similarly equivalent to \code{stop(...)} with separators (see examples)
}

The same applies to the other default condition functions as well, i.e., \code{\link[=warning]{warning()}}, \code{\link[=message]{message()}},
and \code{\link[=packageStartupMessage]{packageStartupMessage()}}.
}
\examples{
# will produce lints
lint(
  text = 'stop(paste("a string", "another"))',
  linters = condition_message_linter()
)

lint(
  text = 'warning(paste0("a string", " another"))',
  linters = condition_message_linter()
)

# okay
lint(
  text = 'stop("a string", " another")',
  linters = condition_message_linter()
)

lint(
  text = 'warning("a string", " another")',
  linters = condition_message_linter()
)

lint(
  text = 'warning(paste("a string", "another", sep = "-"))',
  linters = condition_message_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=consistency_linters]{consistency}
}
