% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian-year-day.R
\name{year-day-count-between}
\alias{year-day-count-between}
\alias{calendar_count_between.clock_year_day}
\title{Counting: year-day}
\usage{
\method{calendar_count_between}{clock_year_day}(start, end, precision, ..., n = 1L)
}
\arguments{
\item{start, end}{\verb{[clock_year_day]}

A pair of year-day vectors. These will be recycled to their
common size.}

\item{precision}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"year"}
}}

\item{...}{These dots are for future extensions and must be empty.}

\item{n}{\verb{[positive integer(1)]}

A single positive integer specifying a multiple of \code{precision} to use.}
}
\value{
An integer representing the number of \code{precision} units between
\code{start} and \code{end}.
}
\description{
This is a year-day method for the \code{\link[=calendar_count_between]{calendar_count_between()}} generic.
It counts the number of \code{precision} units between \code{start} and \code{end}
(i.e., the number of years).
}
\examples{
# Compute an individual's age in years
x <- year_day(2001, 100)
y <- year_day(2021, c(99, 101))

calendar_count_between(x, y, "year")

# Or in a whole number multiple of years
calendar_count_between(x, y, "year", n = 3)
}
