% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowMaxs.R
\name{rowMaxs}
\alias{rowMaxs}
\alias{rowMaxs,matrix_OR_array_OR_table_OR_numeric-method}
\alias{rowMaxs,ANY-method}
\alias{colMaxs}
\alias{colMaxs,matrix_OR_array_OR_table_OR_numeric-method}
\alias{colMaxs,ANY-method}
\title{Calculates the maximum for each row (column) of a matrix-like object}
\usage{
rowMaxs(x, rows = NULL, cols = NULL, na.rm = FALSE, ...)

\S4method{rowMaxs}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL, cols = NULL, na.rm = FALSE, dim. = dim(x), ...)

\S4method{rowMaxs}{ANY}(x, rows = NULL, cols = NULL, na.rm = FALSE, ...)

colMaxs(x, rows = NULL, cols = NULL, na.rm = FALSE, ...)

\S4method{colMaxs}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL, cols = NULL, na.rm = FALSE, dim. = dim(x), ...)

\S4method{colMaxs}{ANY}(x, rows = NULL, cols = NULL, na.rm = FALSE, ...)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, \code{\link{NA}}s
are excluded first, otherwise not.}

\item{...}{Additional arguments passed to specific methods.}

\item{dim.}{An \code{\link{integer}} \code{\link{vector}} of length two
specifying the dimension of \code{x}, essential when x is a
\code{\link{numeric}} vector. Note, that this is not a generic
argument and not all methods need provide it.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the maximum for each row (column) of a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, or \code{\link{numeric}} call
\code{matrixStats::rowMaxs}
/ \code{matrixStats::colMaxs}.
}
\examples{
  mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
  mat[2, 1] <- NA
  mat[3, 3] <- Inf
  mat[4, 1] <- 0
  
  print(mat)
  
  rowMaxs(mat)
  colMaxs(mat)
  
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:rowRanges]{rowMaxs}()} and
\code{matrixStats::\link[matrixStats:rowRanges]{colMaxs}()} which are used
when the input is a \code{matrix} or \code{numeric} vector.
\item For min estimates, see \code{\link{rowMins}()}.
}
}
\keyword{array}
\keyword{iteration}
\keyword{robust}
\keyword{univar}
