# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.durabletask import DurableTaskMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-durabletask
# USAGE
    python retention_policies_create_or_replace_maximum_set_gen.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = DurableTaskMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.retention_policies.begin_create_or_replace(
        resource_group_name="rgdurabletask",
        scheduler_name="testscheduler",
        resource={
            "properties": {
                "retentionPolicies": [
                    {"retentionPeriodInDays": 30},
                    {"orchestrationState": "Failed", "retentionPeriodInDays": 10},
                ]
            }
        },
    ).result()
    print(response)


# x-ms-original-file: 2025-11-01/RetentionPolicies_CreateOrReplace_MaximumSet_Gen.json
if __name__ == "__main__":
    main()
