# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AsymmetricEncryptedSecret(Model):
    """Represent the secrets intended for encryption with asymmetric key pair.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The value of the secret.
    :type value: str
    :param encryption_cert_thumbprint: Thumbprint certificate used to encrypt
     \\"Value\\". If the value is unencrypted, it will be null.
    :type encryption_cert_thumbprint: str
    :param encryption_algorithm: Required. The algorithm used to encrypt
     "Value". Possible values include: 'None', 'AES256', 'RSAES_PKCS1_v_1_5'
    :type encryption_algorithm: str or
     ~azure.mgmt.edgegateway.models.EncryptionAlgorithm
    """

    _validation = {
        'value': {'required': True},
        'encryption_algorithm': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'encryption_cert_thumbprint': {'key': 'encryptionCertThumbprint', 'type': 'str'},
        'encryption_algorithm': {'key': 'encryptionAlgorithm', 'type': 'str'},
    }

    def __init__(self, *, value: str, encryption_algorithm, encryption_cert_thumbprint: str=None, **kwargs) -> None:
        super(AsymmetricEncryptedSecret, self).__init__(**kwargs)
        self.value = value
        self.encryption_cert_thumbprint = encryption_cert_thumbprint
        self.encryption_algorithm = encryption_algorithm
