# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from azure.core.exceptions import ODataV4Format

from .. import _model_base
from .._model_base import rest_field

if TYPE_CHECKING:
    from .. import models as _models


class DeidentificationContent(_model_base.Model):
    """Request body for de-identification operation.

    :ivar input_text: Input text to de-identify. Required.
    :vartype input_text: str
    :ivar operation_type: Operation to perform on the input documents. Known values are: "Redact",
     "Surrogate", and "Tag".
    :vartype operation_type: str or
     ~azure.health.deidentification.models.DeidentificationOperationType
    :ivar customizations: Customization parameters to override default service behaviors.
    :vartype customizations:
     ~azure.health.deidentification.models.DeidentificationCustomizationOptions
    """

    input_text: str = rest_field(name="inputText", visibility=["read", "create", "update", "delete", "query"])
    """Input text to de-identify. Required."""
    operation_type: Optional[Union[str, "_models.DeidentificationOperationType"]] = rest_field(
        name="operation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Operation to perform on the input documents. Known values are: \"Redact\", \"Surrogate\", and
     \"Tag\"."""
    customizations: Optional["_models.DeidentificationCustomizationOptions"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Customization parameters to override default service behaviors."""

    @overload
    def __init__(
        self,
        *,
        input_text: str,
        operation_type: Optional[Union[str, "_models.DeidentificationOperationType"]] = None,
        customizations: Optional["_models.DeidentificationCustomizationOptions"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeidentificationCustomizationOptions(_model_base.Model):
    """Customizations options to override default service behaviors for synchronous usage.

    :ivar redaction_format: Format of the redacted output. Only valid when Operation is Redact.
     Please refer to
     `https://learn.microsoft.com/azure/healthcare-apis/deidentification/redaction-format
     <https://learn.microsoft.com/azure/healthcare-apis/deidentification/redaction-format>`_ for
     more details.
    :vartype redaction_format: str
    :ivar surrogate_locale: Locale in which the output surrogates are written.
    :vartype surrogate_locale: str
    """

    redaction_format: Optional[str] = rest_field(
        name="redactionFormat", visibility=["read", "create", "update", "delete", "query"]
    )
    """Format of the redacted output. Only valid when Operation is Redact.
     Please refer to
     `https://learn.microsoft.com/azure/healthcare-apis/deidentification/redaction-format
     <https://learn.microsoft.com/azure/healthcare-apis/deidentification/redaction-format>`_ for
     more details."""
    surrogate_locale: Optional[str] = rest_field(
        name="surrogateLocale", visibility=["read", "create", "update", "delete", "query"]
    )
    """Locale in which the output surrogates are written."""

    @overload
    def __init__(
        self,
        *,
        redaction_format: Optional[str] = None,
        surrogate_locale: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeidentificationDocumentDetails(_model_base.Model):
    """Details of a single document in a job.

    :ivar id: Id of the document details. Required.
    :vartype id: str
    :ivar input_location: Location for the input. Required.
    :vartype input_location: ~azure.health.deidentification.models.DeidentificationDocumentLocation
    :ivar output_location: Location for the output.
    :vartype output_location:
     ~azure.health.deidentification.models.DeidentificationDocumentLocation
    :ivar status: Status of the document. Required. Known values are: "NotStarted", "Running",
     "Succeeded", "Failed", and "Canceled".
    :vartype status: str or ~azure.health.deidentification.models.OperationStatus
    :ivar error: Error when document fails.
    :vartype error: ~azure.core.ODataV4Format
    """

    id: str = rest_field(visibility=["read"])
    """Id of the document details. Required."""
    input_location: "_models.DeidentificationDocumentLocation" = rest_field(
        name="input", visibility=["read", "create", "update", "delete", "query"]
    )
    """Location for the input. Required."""
    output_location: Optional["_models.DeidentificationDocumentLocation"] = rest_field(
        name="output", visibility=["read", "create", "update", "delete", "query"]
    )
    """Location for the output."""
    status: Union[str, "_models.OperationStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Status of the document. Required. Known values are: \"NotStarted\", \"Running\", \"Succeeded\",
     \"Failed\", and \"Canceled\"."""
    error: Optional[ODataV4Format] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error when document fails."""

    @overload
    def __init__(
        self,
        *,
        input_location: "_models.DeidentificationDocumentLocation",
        status: Union[str, "_models.OperationStatus"],
        output_location: Optional["_models.DeidentificationDocumentLocation"] = None,
        error: Optional[ODataV4Format] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeidentificationDocumentLocation(_model_base.Model):
    """Location of a document.

    :ivar location: Location of document in storage. Required.
    :vartype location: str
    :ivar etag: The entity tag for this resource. Required.
    :vartype etag: str
    """

    location: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Location of document in storage. Required."""
    etag: str = rest_field(visibility=["read"])
    """The entity tag for this resource. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeidentificationJob(_model_base.Model):
    """A job containing a batch of documents to de-identify.

    :ivar job_name: The name of a job. Required.
    :vartype job_name: str
    :ivar operation_type: Operation to perform on the input documents. Known values are: "Redact",
     "Surrogate", and "Tag".
    :vartype operation_type: str or
     ~azure.health.deidentification.models.DeidentificationOperationType
    :ivar source_location: Storage location to perform the operation on. Required.
    :vartype source_location: ~azure.health.deidentification.models.SourceStorageLocation
    :ivar target_location: Target location to store output of operation. Required.
    :vartype target_location: ~azure.health.deidentification.models.TargetStorageLocation
    :ivar customizations: Customization parameters to override default service behaviors.
    :vartype customizations:
     ~azure.health.deidentification.models.DeidentificationJobCustomizationOptions
    :ivar status: Current status of a job. Required. Known values are: "NotStarted", "Running",
     "Succeeded", "Failed", and "Canceled".
    :vartype status: str or ~azure.health.deidentification.models.OperationStatus
    :ivar error: Error when job fails in it's entirety.
    :vartype error: ~azure.core.ODataV4Format
    :ivar last_updated_at: Date and time when the job was completed.

     If the job is canceled, this is the time when the job was canceled.

     If the job failed, this is the time when the job failed. Required.
    :vartype last_updated_at: ~datetime.datetime
    :ivar created_at: Date and time when the job was created. Required.
    :vartype created_at: ~datetime.datetime
    :ivar started_at: Date and time when the job was started.
    :vartype started_at: ~datetime.datetime
    :ivar summary: Summary of a job. Exists only when the job is completed.
    :vartype summary: ~azure.health.deidentification.models.DeidentificationJobSummary
    """

    job_name: str = rest_field(name="name", visibility=["read"])
    """The name of a job. Required."""
    operation_type: Optional[Union[str, "_models.DeidentificationOperationType"]] = rest_field(
        name="operation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Operation to perform on the input documents. Known values are: \"Redact\", \"Surrogate\", and
     \"Tag\"."""
    source_location: "_models.SourceStorageLocation" = rest_field(
        name="sourceLocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Storage location to perform the operation on. Required."""
    target_location: "_models.TargetStorageLocation" = rest_field(
        name="targetLocation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Target location to store output of operation. Required."""
    customizations: Optional["_models.DeidentificationJobCustomizationOptions"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Customization parameters to override default service behaviors."""
    status: Union[str, "_models.OperationStatus"] = rest_field(visibility=["read"])
    """Current status of a job. Required. Known values are: \"NotStarted\", \"Running\",
     \"Succeeded\", \"Failed\", and \"Canceled\"."""
    error: Optional[ODataV4Format] = rest_field(visibility=["read"])
    """Error when job fails in it's entirety."""
    last_updated_at: datetime.datetime = rest_field(name="lastUpdatedAt", visibility=["read"], format="rfc3339")
    """Date and time when the job was completed.
     
     If the job is canceled, this is the time when the job was canceled.
     
     If the job failed, this is the time when the job failed. Required."""
    created_at: datetime.datetime = rest_field(name="createdAt", visibility=["read"], format="rfc3339")
    """Date and time when the job was created. Required."""
    started_at: Optional[datetime.datetime] = rest_field(name="startedAt", visibility=["read"], format="rfc3339")
    """Date and time when the job was started."""
    summary: Optional["_models.DeidentificationJobSummary"] = rest_field(visibility=["read"])
    """Summary of a job. Exists only when the job is completed."""

    @overload
    def __init__(
        self,
        *,
        source_location: "_models.SourceStorageLocation",
        target_location: "_models.TargetStorageLocation",
        operation_type: Optional[Union[str, "_models.DeidentificationOperationType"]] = None,
        customizations: Optional["_models.DeidentificationJobCustomizationOptions"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeidentificationJobCustomizationOptions(_model_base.Model):
    """Customizations options to override default service behaviors for job usage.

    :ivar redaction_format: Format of the redacted output. Only valid when Operation is Redact.
     Please refer to
     `https://learn.microsoft.com/azure/healthcare-apis/deidentification/redaction-format
     <https://learn.microsoft.com/azure/healthcare-apis/deidentification/redaction-format>`_ for
     more details.
    :vartype redaction_format: str
    :ivar surrogate_locale: Locale in which the output surrogates are written.
    :vartype surrogate_locale: str
    """

    redaction_format: Optional[str] = rest_field(
        name="redactionFormat", visibility=["read", "create", "update", "delete", "query"]
    )
    """Format of the redacted output. Only valid when Operation is Redact.
     Please refer to
     `https://learn.microsoft.com/azure/healthcare-apis/deidentification/redaction-format
     <https://learn.microsoft.com/azure/healthcare-apis/deidentification/redaction-format>`_ for
     more details."""
    surrogate_locale: Optional[str] = rest_field(
        name="surrogateLocale", visibility=["read", "create", "update", "delete", "query"]
    )
    """Locale in which the output surrogates are written."""

    @overload
    def __init__(
        self,
        *,
        redaction_format: Optional[str] = None,
        surrogate_locale: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeidentificationJobSummary(_model_base.Model):
    """Summary metrics of a job.

    :ivar successful_count: Number of documents that have completed. Required.
    :vartype successful_count: int
    :ivar failed_count: Number of documents that have failed. Required.
    :vartype failed_count: int
    :ivar canceled_count: Number of documents that have been canceled. Required.
    :vartype canceled_count: int
    :ivar total_count: Number of documents total. Required.
    :vartype total_count: int
    :ivar bytes_processed: Number of bytes processed. Required.
    :vartype bytes_processed: int
    """

    successful_count: int = rest_field(name="successful", visibility=["read", "create", "update", "delete", "query"])
    """Number of documents that have completed. Required."""
    failed_count: int = rest_field(name="failed", visibility=["read", "create", "update", "delete", "query"])
    """Number of documents that have failed. Required."""
    canceled_count: int = rest_field(name="canceled", visibility=["read", "create", "update", "delete", "query"])
    """Number of documents that have been canceled. Required."""
    total_count: int = rest_field(name="total", visibility=["read", "create", "update", "delete", "query"])
    """Number of documents total. Required."""
    bytes_processed: int = rest_field(name="bytesProcessed", visibility=["read", "create", "update", "delete", "query"])
    """Number of bytes processed. Required."""

    @overload
    def __init__(
        self,
        *,
        successful_count: int,
        failed_count: int,
        canceled_count: int,
        total_count: int,
        bytes_processed: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeidentificationResult(_model_base.Model):
    """Response body for de-identification operation.

    :ivar output_text: Output text after de-identification. Not available for "Tag" operation.
    :vartype output_text: str
    :ivar tagger_result: Result of the "Tag" operation. Only available for "Tag" Operation.
    :vartype tagger_result: ~azure.health.deidentification.models.PhiTaggerResult
    """

    output_text: Optional[str] = rest_field(
        name="outputText", visibility=["read", "create", "update", "delete", "query"]
    )
    """Output text after de-identification. Not available for \"Tag\" operation."""
    tagger_result: Optional["_models.PhiTaggerResult"] = rest_field(
        name="taggerResult", visibility=["read", "create", "update", "delete", "query"]
    )
    """Result of the \"Tag\" operation. Only available for \"Tag\" Operation."""

    @overload
    def __init__(
        self,
        *,
        output_text: Optional[str] = None,
        tagger_result: Optional["_models.PhiTaggerResult"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PhiEntity(_model_base.Model):
    """PHI Entity tag in the input.

    :ivar category: PHI Category of the entity. Required. Known values are: "Unknown", "Account",
     "Age", "BioID", "City", "CountryOrRegion", "Date", "Device", "Doctor", "Email", "Fax",
     "HealthPlan", "Hospital", "IDNum", "IPAddress", "License", "LocationOther", "MedicalRecord",
     "Organization", "Patient", "Phone", "Profession", "SocialSecurity", "State", "Street", "Url",
     "Username", "Vehicle", and "Zip".
    :vartype category: str or ~azure.health.deidentification.models.PhiCategory
    :ivar offset: Starting index of the location from within the input text. Required.
    :vartype offset: ~azure.health.deidentification.models.StringIndex
    :ivar length: Length of the input text. Required.
    :vartype length: ~azure.health.deidentification.models.StringIndex
    :ivar text: Text of the entity.
    :vartype text: str
    :ivar confidence_score: Confidence score of the category match.
    :vartype confidence_score: float
    """

    category: Union[str, "_models.PhiCategory"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """PHI Category of the entity. Required. Known values are: \"Unknown\", \"Account\", \"Age\",
     \"BioID\", \"City\", \"CountryOrRegion\", \"Date\", \"Device\", \"Doctor\", \"Email\", \"Fax\",
     \"HealthPlan\", \"Hospital\", \"IDNum\", \"IPAddress\", \"License\", \"LocationOther\",
     \"MedicalRecord\", \"Organization\", \"Patient\", \"Phone\", \"Profession\",
     \"SocialSecurity\", \"State\", \"Street\", \"Url\", \"Username\", \"Vehicle\", and \"Zip\"."""
    offset: "_models.StringIndex" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Starting index of the location from within the input text. Required."""
    length: "_models.StringIndex" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Length of the input text. Required."""
    text: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Text of the entity."""
    confidence_score: Optional[float] = rest_field(
        name="confidenceScore", visibility=["read", "create", "update", "delete", "query"]
    )
    """Confidence score of the category match."""

    @overload
    def __init__(
        self,
        *,
        category: Union[str, "_models.PhiCategory"],
        offset: "_models.StringIndex",
        length: "_models.StringIndex",
        text: Optional[str] = None,
        confidence_score: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PhiTaggerResult(_model_base.Model):
    """Result of the "Tag" operation.

    :ivar entities: List of entities detected in the input. Required.
    :vartype entities: list[~azure.health.deidentification.models.PhiEntity]
    """

    entities: List["_models.PhiEntity"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of entities detected in the input. Required."""

    @overload
    def __init__(
        self,
        *,
        entities: List["_models.PhiEntity"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SourceStorageLocation(_model_base.Model):
    """Storage location.

    :ivar location: URL to storage location. Required.
    :vartype location: str
    :ivar prefix: Prefix to filter path by. Required.
    :vartype prefix: str
    :ivar extensions: List of extensions to filter path by.
    :vartype extensions: list[str]
    """

    location: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """URL to storage location. Required."""
    prefix: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Prefix to filter path by. Required."""
    extensions: Optional[List[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of extensions to filter path by."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        prefix: str,
        extensions: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StringIndex(_model_base.Model):
    """String index encoding model.

    :ivar utf8: The offset or length of the substring in UTF-8 encoding. Required.
    :vartype utf8: int
    :ivar utf16: The offset or length of the substring in UTF-16 encoding.

     Primary encoding used by .NET, Java, and JavaScript. Required.
    :vartype utf16: int
    :ivar code_point: The offset or length of the substring in CodePoint encoding.

     Primary encoding used by Python. Required.
    :vartype code_point: int
    """

    utf8: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The offset or length of the substring in UTF-8 encoding. Required."""
    utf16: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The offset or length of the substring in UTF-16 encoding.
     
     Primary encoding used by .NET, Java, and JavaScript. Required."""
    code_point: int = rest_field(name="codePoint", visibility=["read", "create", "update", "delete", "query"])
    """The offset or length of the substring in CodePoint encoding.
     
     Primary encoding used by Python. Required."""

    @overload
    def __init__(
        self,
        *,
        utf8: int,
        utf16: int,
        code_point: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TargetStorageLocation(_model_base.Model):
    """Storage location.

    :ivar location: URL to storage location. Required.
    :vartype location: str
    :ivar prefix: Replaces the input prefix of a file path with the output prefix, preserving the
     rest of the path structure.

     Example:
     File full path: documents/user/note.txt
     Input Prefix: "documents/user/"
     Output Prefix: "output_docs/"

     Output file: "output_docs/note.txt". Required.
    :vartype prefix: str
    :ivar overwrite: When set to true during a job, the service will overwrite the output location
     if it already exists.
    :vartype overwrite: bool
    """

    location: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """URL to storage location. Required."""
    prefix: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Replaces the input prefix of a file path with the output prefix, preserving the rest of the
     path structure.
     
     Example:
     File full path: documents/user/note.txt
     Input Prefix: \"documents/user/\"
     Output Prefix: \"output_docs/\"
     
     Output file: \"output_docs/note.txt\". Required."""
    overwrite: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """When set to true during a job, the service will overwrite the output location if it already
     exists."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        prefix: str,
        overwrite: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
