// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef AVTMATSPECIESMETADATA_H
#define AVTMATSPECIESMETADATA_H
#include <dbatts_exports.h>
#include <string>
#include <AttributeSubject.h>


// ****************************************************************************
// Class: avtMatSpeciesMetaData
//
// Purpose:
//    Contains material species metadata attributes
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class DBATTS_API avtMatSpeciesMetaData : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    avtMatSpeciesMetaData();
    avtMatSpeciesMetaData(const avtMatSpeciesMetaData &obj);
protected:
    // These constructors are for objects derived from this class
    avtMatSpeciesMetaData(private_tmfs_t tmfs);
    avtMatSpeciesMetaData(const avtMatSpeciesMetaData &obj, private_tmfs_t tmfs);
public:
    virtual ~avtMatSpeciesMetaData();

    virtual avtMatSpeciesMetaData& operator = (const avtMatSpeciesMetaData &obj);
    virtual bool operator == (const avtMatSpeciesMetaData &obj) const;
    virtual bool operator != (const avtMatSpeciesMetaData &obj) const;
private:
    void Init();
    void Copy(const avtMatSpeciesMetaData &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    avtMatSpeciesMetaData(int, const stringVector &);

    // IDs that can be used to identify fields in case statements
    enum {
        ID_numSpecies = 0,
        ID_speciesNames,
        ID_validVariable,
        ID__LAST
    };

public:
    int          numSpecies;
    stringVector speciesNames;
    bool         validVariable;

private:
    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define AVTMATSPECIESMETADATA_TMFS "is*b"

#endif
