/*
 * Copyright (c) 2007, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
  @test
  @key headful
  @bug 6479820
  @library ../../../regtesthelpers
  @build Util
  @summary verify that enter/exit events still comes correctly
  @author andrei dmitriev: area=awt.event
  @run main SpuriousExitEnter_3
*/

/**
 * SpuriousExitEnter_3.java
 *
            "There is a plain JFrame with JButton in it.",
            "Let A area is the area inside JButton.",
            "Let B area is the area inside JFrame but not inside JButton.",
            "Let C area is the area outside JFrame.",
            "Now check that the correct events and are in the correct number generates when you",
            "move the pointer between those areas.",
            " 1) Verify that the Enter and Exit events comes to JButton and JFrame when ",
            " you move the pointer between A and B areas.",
            " 2) Verify that the Enter and Exit events comes to JButton when you",
            " move the pointer between A to C.",
            " 3) Verify that the Enter and Exit events comes to JFrame when you",
            " move the pointer between B to C.",
 */

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;

import test.java.awt.regtesthelpers.Util;

import javax.swing.JButton;
import javax.swing.JFrame;

public class SpuriousExitEnter_3 {
    static JFrame frame;
    static JButton jbutton;

    static Frame frame1;
    static Button button1;

    static final Robot r = Util.createRobot();

    static volatile EnterExitAdapter frameAdapter;
    static volatile EnterExitAdapter buttonAdapter;
    static volatile Point centerA;
    static volatile Point centerB;
    static volatile Point centerC_1 ;
    static volatile Point centerC_2;

    public static void testCase(Window w, Component comp) throws InterruptedException, InvocationTargetException {
        EventQueue.invokeAndWait(()-> {
            frameAdapter = new EnterExitAdapter(w);
            buttonAdapter = new EnterExitAdapter(comp);

            w.addMouseListener(frameAdapter);
            comp.addMouseListener(buttonAdapter);

            w.setSize(200, 200);
            w.add(comp, BorderLayout.NORTH);
            w.setLocationRelativeTo(null);
            w.setVisible(true);
        });

        r.waitForIdle();
        r.delay(1000);

        EventQueue.invokeAndWait(()-> {
            centerA = new Point(comp.getLocationOnScreen().x + comp.getWidth() / 2,
                    comp.getLocationOnScreen().y + comp.getHeight() / 2);
            centerB = new Point(w.getLocationOnScreen().x + w.getWidth() / 2,
                    w.getLocationOnScreen().y + w.getHeight() / 2);
            //for moving from A outside: don't cross the A area. Move straight to the right.
            centerC_1 = new Point(w.getLocationOnScreen().x + w.getWidth() + 20,  /