// SPDX-License-Identifier: GPL-2.0-or-later
// Copyright The Music Player Daemon Project

#pragma once

#include <cstdint>

/**
 * Codes for the type of a tag item.
 */
enum TagType : uint8_t {
	TAG_ARTIST,
	TAG_ARTIST_SORT,
	TAG_ALBUM,
	TAG_ALBUM_SORT,
	TAG_ALBUM_ARTIST,
	TAG_ALBUM_ARTIST_SORT,
	TAG_TITLE,
	TAG_TITLE_SORT,
	TAG_TRACK,
	TAG_NAME,
	TAG_GENRE,
	TAG_MOOD,
	TAG_DATE,
	TAG_ORIGINAL_DATE,
	TAG_COMPOSER,
	TAG_COMPOSERSORT,
	TAG_PERFORMER,
	TAG_CONDUCTOR,
	TAG_WORK,
	TAG_MOVEMENT,
	TAG_MOVEMENTNUMBER,
	TAG_SHOWMOVEMENT,
	TAG_ENSEMBLE,
	TAG_LOCATION,
	TAG_GROUPING,
	TAG_COMMENT,
	TAG_DISC,
	TAG_LABEL,

	TAG_MUSICBRAINZ_ARTISTID,
	TAG_MUSICBRAINZ_ALBUMID,
	TAG_MUSICBRAINZ_ALBUMARTISTID,
	TAG_MUSICBRAINZ_TRACKID,
	TAG_MUSICBRAINZ_RELEASETRACKID,
	TAG_MUSICBRAINZ_WORKID,
	TAG_MUSICBRAINZ_RELEASEGROUPID,

	TAG_NUM_OF_ITEM_TYPES
};
