document {
    Key => {
	 selectVariables,
	(selectVariables, List, PolynomialRing)
    },
    Headline => "make a subring of a polynomial ring generated by selected variables",
    Usage => "(S,F) = selectVariables(v,R)",
    Inputs => {
	"v" => {"a sorted list of numbers specifying which variables to select"},
	"R"
    },
    Outputs => {
	"S" => PolynomialRing => {"a polynomial ring generated as a subring of R by the variables whose indices
	    occur in the list v, together with the induced monomial ordering"
	},
	"F" => RingMap => {"the inclusion map from S to R"}
    },
    EXAMPLE lines ///
        R = QQ[a..h, Weights => 1..8]
        (S,F) = selectVariables({2,4}, R);
	describe S
	options S
	F
    ///
}
