# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::IM;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230307181420;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8001111',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '845464',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              3873|
              5(?:
                242|
                39[4-6]
              )|
              (?:
                697|
                768
              )[347]|
              9467
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{4,5})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              [2-69][02-9]|
              [78]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [25]|
            7(?:
              0|
              6(?:
                [03-9]|
                2[356]
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[1389]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          1624(?:
            230|
            [5-8]\\d\\d
          )\\d{3}
        ',
                'geographic' => '
          1624(?:
            230|
            [5-8]\\d\\d
          )\\d{3}
        ',
                'mobile' => '
          76245[06]\\d{4}|
          7(?:
            4576|
            [59]24\\d|
            624[0-4689]
          )\\d{5}
        ',
                'pager' => '',
                'personal_number' => '70\\d{8}',
                'specialrate' => '(
          8(?:
            440[49]06|
            72299\\d
          )\\d{3}|
          (?:
            8(?:
              45|
              70
            )|
            90[0167]
          )624\\d{4}
        )|(
          3440[49]06\\d{3}|
          (?:
            3(?:
              08162|
              3\\d{4}|
              45624|
              7(?:
                0624|
                2299
              )
            )|
            55\\d{4}
          )\\d{4}
        )',
                'toll_free' => '808162\\d{4}',
                'voip' => '56\\d{8}'
              };
my %areanames = ();
$areanames{en} = {"441695", "Skelmersdale",
"441255", "Clacton\-on\-Sea",
"441234", "Bedford",
"441432", "Hereford",
"441600", "Monmouth",
"441285", "Cirencester",
"4419759", "Alford\ \(Aberdeen\)",
"441208", "Bodmin",
"44241", "Coventry",
"441939", "Wem",
"441595", "Lerwick\,\ Foula\ \&\ Fair\ Isle",
"4415394", "Hawkshead",
"441905", "Worcester",
"441446", "Barry",
"4418518", "Stornoway",
"441872", "Truro",
"441529", "Sleaford",
"441501", "Harthill",
"441629", "Matlock",
"441918", "Tyneside",
"441306", "Dorking",
"441988", "Wigtown",
"4414239", "Boroughbridge",
"4418905", "Ayton",
"441676", "Meriden",
"441661", "Prudhoe",
"441778", "Bourne",
"441424", "Hastings",
"441450", "Hawick",
"442837", "Armagh",
"441480", "Huntingdon",
"441366", "Downham\ Market",
"442870", "Coleraine",
"441371", "Great\ Dunmow",
"441561", "Laurencekirk",
"441576", "Lockerbie",
"441451", "Stow\-on\-the\-Wold",
"441733", "Peterborough",
"4418479", "Tongue",
"4416861", "Newtown\/Llanidloes",
"441481", "Guernsey",
"4415078", "Alford\ \(Lincs\)",
"441337", "Ladybank",
"4415242", "Hornby",
"442871", "Londonderry",
"441887", "Aberfeldy",
"4414344", "Bellingham",
"442866", "Enniskillen",
"441857", "Sanday",
"4414371", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441745", "Rhyl",
"441268", "Basildon",
"441560", "Moscow",
"441562", "Kidderminster",
"441938", "Welshpool",
"44287", "Northern\ Ireland",
"4414378", "Haverfordwest",
"441647", "Moretonhampstead",
"441372", "Esher",
"441209", "Redruth",
"4418473", "Thurso",
"441904", "York",
"44141", "Glasgow",
"441547", "Knighton",
"4416868", "Newtown",
"4415071", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"4412296", "Barrow\-in\-Furness",
"441806", "Shetland",
"441989", "Ross\-on\-Wye",
"441959", "Westerham",
"441628", "Maidenhead",
"441919", "Durham",
"441243", "Chichester",
"441726", "St\ Austell",
"441594", "Lydney",
"441482", "Kingston\-upon\-Hull",
"441694", "Church\ Stretton",
"4414233", "Boroughbridge",
"441235", "Abingdon",
"441254", "Blackburn",
"441528", "Laggan",
"441452", "Gloucester",
"441284", "Bury\ St\ Edmunds",
"441499", "Inveraray",
"441744", "St\ Helens",
"441837", "Okehampton",
"441753", "Slough",
"441431", "Helmsdale",
"4418511", "Great\ Bernera\/Stornoway",
"441870", "Isle\ of\ Benbecula",
"4413395", "Aboyne",
"441992", "Lea\ Valley",
"441387", "Dumfries",
"442893", "Ballyclare",
"441357", "Strathaven",
"441779", "Peterhead",
"4419753", "Strathdon",
"441269", "Ammanford",
"4417683", "Appleby",
"441502", "Lowestoft",
"441477", "Holmes\ Chapel",
"442887", "Dungannon",
"441871", "Castlebay",
"441797", "Rye",
"441866", "Kilchrenan",
"441425", "Ringwood",
"4413885", "Stanhope\ \(Eastgate\)",
"44116", "Leicester",
"441344", "Bracknell",
"441669", "Rothbury",
"441438", "Stevenage",
"441833", "Barnard\ Castle",
"4418901", "Coldstream\/Ayton",
"441383", "Dunfermline",
"441202", "Bournemouth",
"441757", "Selby",
"441845", "Thirsk",
"441379", "Diss",
"441569", "Stonehaven",
"441353", "Ely",
"441404", "Honiton",
"441787", "Sudbury",
"442897", "Saintfield",
"442844", "Downpatrick",
"4414375", "Clynderwen\ \(Clunderwen\)",
"441489", "Bishops\ Waltham",
"441878", "Lochboisdale",
"441473", "Ipswich",
"441912", "Tyneside",
"442879", "Magherafelt",
"441952", "Telford",
"442883", "Northern\ Ireland",
"441793", "Swindon",
"441982", "Builth\ Wells",
"441397", "Fort\ William",
"4416865", "Newtown",
"442826", "Northern\ Ireland",
"441584", "Ludlow",
"441772", "Preston",
"441520", "Lochcarron",
"441228", "Carlisle",
"441554", "Llanelli",
"441535", "Keighley",
"441643", "Minehead",
"441294", "Ardrossan",
"441543", "Cannock",
"441620", "North\ Berwick",
"441654", "Machynlleth",
"441635", "Newbury",
"441931", "Shap",
"441684", "Malvern",
"441492", "Colwyn\ Bay",
"441977", "Pontefract",
"441326", "Falmouth",
"441609", "Northallerton",
"441509", "Loughborough",
"441464", "Insch",
"441621", "Maldon",
"4413398", "Aboyne",
"441262", "Bridlington",
"441925", "Warrington",
"441932", "Weybridge",
"4418515", "Stornoway",
"441568", "Leominster",
"441260", "Congleton",
"441491", "Henley\-on\-Thames",
"4414237", "Harrogate",
"4413391", "Aboyne\/Ballater",
"4416973", "Wigton",
"441439", "Helmsley",
"442845", "Northern\ Ireland",
"441766", "Porthmadog",
"441771", "Maud",
"441668", "Bamburgh",
"44291", "Cardiff",
"441276", "Camberley",
"4418477", "Tongue",
"4419750", "Alford\ \(Aberdeen\)\/Strathdon",
"441490", "Corwen",
"441844", "Thame",
"4413881", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441737", "Redhill",
"441261", "Banff",
"441405", "Goole",
"441622", "Maidstone",
"441333", "Peat\ Inn\ \(Leven\ \(Fife\)\)",
"441946", "Whitehaven",
"4419646", "Patrington",
"441879", "Scarinish",
"441488", "Hungerford",
"441522", "Lincoln",
"441883", "Caterham",
"441458", "Glastonbury",
"441770", "Isle\ of\ Arran",
"4414306", "Market\ Weighton",
"441465", "Girvan",
"441980", "Amesbury",
"4415075", "Spilsby\ \(Horncastle\)",
"441910", "Tyneside\/Durham\/Sunderland",
"4414342", "Bellingham",
"441924", "Wakefield",
"441950", "Sandwick",
"4419757", "Strathdon",
"4418470", "Thurso\/Tongue",
"4417687", "Keswick",
"4418908", "Coldstream",
"441981", "Wormbridge",
"441295", "Banbury",
"441655", "Maybole",
"441634", "Medway",
"441200", "Clitheroe",
"441951", "Colonsay",
"441508", "Brooke",
"441911", "Tyneside\/Durham\/Sunderland",
"441685", "Merthyr\ Tydfil",
"4414230", "Harrogate\/Boroughbridge",
"441706", "Rochdale",
"441608", "Chipping\ Norton",
"441534", "Jersey",
"441555", "Lanark",
"441963", "Wincanton",
"4419649", "Hornsea",
"441394", "Felixstowe",
"4414309", "Market\ Weighton",
"441721", "Peebles",
"441709", "Rotherham",
"4415072", "Spilsby\ \(Horncastle\)",
"441895", "Uxbridge",
"4414345", "Haltwhistle",
"442847", "Northern\ Ireland",
"441328", "Fakenham",
"4418904", "Coldstream",
"441829", "Tarporley",
"441784", "Staines",
"44286", "Northern\ Ireland",
"442894", "Antrim",
"441572", "Oakham",
"441407", "Holyhead",
"441720", "Isles\ of\ Scilly",
"441362", "Dereham",
"441754", "Skegness",
"441226", "Barnsley",
"441743", "Shrewsbury",
"442828", "Larne",
"441672", "Marlborough",
"441347", "Easingwold",
"441302", "Doncaster",
"441279", "Bishops\ Stortford",
"441283", "Burton\-on\-Trent",
"441949", "Whatton",
"44280", "Northern\ Ireland",
"441253", "Blackpool",
"441467", "Inverurie",
"441876", "Lochmaddy",
"441244", "Chester",
"441593", "Lybster",
"4418512", "Stornoway",
"441442", "Hemel\ Hempstead",
"44117", "Bristol",
"441974", "Llanon",
"441687", "Mallaig",
"441903", "Worthing",
"441297", "Axminster",
"441436", "Helensburgh",
"441557", "Kirkcudbright",
"441769", "South\ Molton",
"4415395", "Grange\-over\-Sands",
"441329", "Fareham",
"441708", "Romford",
"441862", "Tain",
"441606", "Northwich",
"442895", "Belfast",
"441785", "Stafford",
"441506", "Bathgate",
"4419467", "Gosforth",
"441301", "Arrochar",
"4412290", "Barrow\-in\-Furness\/Millom",
"442829", "Kilrea",
"441440", "Haverhill",
"4413394", "Ballater",
"441395", "Budleigh\ Salterton",
"441828", "Coupar\ Angus",
"441300", "Cerne\ Abbas",
"441456", "Glenurquhart",
"441670", "Morpeth",
"441948", "Whitchurch",
"441722", "Salisbury",
"441360", "Killearn",
"441637", "Newquay",
"441570", "Lampeter",
"441278", "Bridgwater",
"4413873", "Langholm",
"4416862", "Llanidloes",
"441768", "Penrith",
"441671", "Newton\ Stewart",
"441666", "Malmesbury",
"441245", "Chelmsford",
"4412297", "Millom",
"4414372", "Clynderwen\ \(Clunderwen\)",
"441361", "Duns",
"4419643", "Patrington",
"441376", "Braintree",
"441566", "Launceston",
"441571", "Lochinver",
"4414303", "North\ Cave",
"441233", "Ashford\ \(Kent\)",
"441271", "Barnstaple",
"4413392", "Aboyne",
"442868", "Kesh",
"441869", "Bicester",
"441545", "Llanarth",
"441633", "Newport",
"441322", "Dartford",
"441760", "Swaffham",
"441270", "Crewe",
"441578", "Lauder",
"441496", "Port\ Ellen",
"441368", "Dunbar",
"4413882", "Stanhope\ \(Eastgate\)",
"4412299", "Millom",
"441923", "Watford",
"442822", "Northern\ Ireland",
"441678", "Bala",
"441761", "Temple\ Cloud",
"441237", "Bideford",
"441776", "Stranraer",
"441986", "Bungay",
"441308", "Bridport",
"441835", "St\ Boswells",
"441854", "Ullapool",
"4414341", "Bellingham\/Haltwhistle\/Hexham",
"441916", "Tyneside",
"4414374", "Clynderwen\ \(Clunderwen\)",
"441729", "Settle",
"441884", "Tiverton",
"441334", "St\ Andrews",
"441355", "East\ Kilbride",
"4416864", "Llanidloes",
"441843", "Thanet",
"441821", "Kinrossie",
"441475", "Greenock",
"441206", "Colchester",
"441700", "Rothesay",
"441427", "Gainsborough",
"441795", "Sittingbourne",
"442885", "Ballygawley",
"441809", "Tomdoun",
"441287", "Guisborough",
"441257", "Coppull",
"441702", "Southend\-on\-Sea",
"441463", "Inverness",
"441697", "Brampton",
"441597", "Llandrindod\ Wells",
"4418902", "Coldstream",
"441683", "Moffat",
"4419756", "Strathdon",
"441293", "Crawley",
"441544", "Kington",
"4415074", "Alford\ \(Lincs\)",
"441653", "Malton",
"441369", "Dunoon",
"441553", "Kings\ Lynn",
"4414348", "Hexham",
"4419640", "Hornsea\/Patrington",
"441644", "New\ Galloway",
"4414300", "North\ Cave\/Market\ Weighton",
"441583", "Carradale",
"441822", "Tavistock",
"441579", "Liskeard",
"441449", "Stowmarket",
"4419647", "Patrington",
"442820", "Ballycastle",
"441967", "Strontian",
"4414307", "Market\ Weighton",
"441526", "Martin",
"442884", "Northern\ Ireland",
"441794", "Romsey",
"441626", "Newton\ Abbot",
"4418476", "Tongue",
"441942", "Wigan",
"441728", "Saxmundham",
"441474", "Gravesend",
"4412293", "Millom",
"441309", "Forres",
"442843", "Newcastle\ \(Co\.\ Down\)",
"441354", "Chatteris",
"441335", "Ashbourne",
"442821", "Martinstown",
"441320", "Fort\ Augustus",
"4418514", "Great\ Bernera",
"441403", "Horsham",
"441808", "Tomatin",
"441384", "Dudley",
"441747", "Shaftesbury",
"4414236", "Harrogate",
"441855", "Ballachulish",
"441834", "Narberth",
"441343", "Elgin",
"441885", "Pencombe",
"441865", "Oxford",
"441674", "Montrose",
"441549", "Lairg",
"441993", "Witney",
"441207", "Consett",
"441364", "Ashburton",
"441752", "Plymouth",
"441782", "Stoke\-on\-Trent",
"442892", "Lisburn",
"441503", "Looe",
"441917", "Sunderland",
"441957", "Mid\ Yell",
"441603", "Norwich",
"441987", "Ebbsfleet",
"441392", "Exeter",
"4414343", "Haltwhistle",
"4414376", "Haverfordwest",
"441236", "Coatbridge",
"441777", "Retford",
"441563", "Kilmarnock",
"441359", "Pakenham",
"441373", "Frome",
"442838", "Portadown",
"441389", "Dumbarton",
"4412298", "Barrow\-in\-Furness",
"4416866", "Newtown",
"441730", "Petersfield",
"441663", "New\ Mills",
"441725", "Rockbourne",
"441497", "Hay\-on\-Wye",
"441972", "Glenborrodale",
"441444", "Haywards\ Heath",
"441799", "Saffron\ Walden",
"441242", "Cheltenham",
"442889", "Fivemiletown",
"441805", "Torrington",
"441479", "Grantown\-on\-Spey",
"441888", "Turriff",
"441483", "Guildford",
"441858", "Market\ Harborough",
"441304", "Dover",
"441267", "Carmarthen",
"441453", "Dursley",
"441937", "Wetherby",
"441746", "Bridgnorth",
"441223", "Cambridge",
"441548", "Kingsbridge",
"44239", "Portsmouth",
"441892", "Tunbridge\ Wells",
"441970", "Aberystwyth",
"4412291", "Barrow\-in\-Furness\/Millom",
"4415076", "Louth",
"4417684", "Pooley\ Bridge",
"441732", "Sevenoaks",
"441575", "Kirriemuir",
"4419754", "Alford\ \(Aberdeen\)",
"441864", "Abington\ \(Crawford\)",
"441241", "Arbroath",
"441675", "Coleshill",
"441527", "Redditch",
"441971", "Scourie",
"442891", "Bangor\ \(Co\.\ Down\)",
"441838", "Dalmally",
"4414349", "Bellingham",
"441433", "Hathersage",
"441751", "Pickering",
"441305", "Dorchester",
"441445", "Gairloch",
"441388", "Bishop\ Auckland",
"4414305", "North\ Cave",
"4419645", "Hornsea",
"4418474", "Thurso",
"441358", "Ellon",
"441780", "Stamford",
"441859", "Harris",
"442890", "Belfast",
"4418516", "Great\ Bernera",
"441724", "Scunthorpe",
"441889", "Rugeley",
"441478", "Isle\ of\ Skye\ \-\ Portree",
"441750", "Selkirk",
"441873", "Abergavenny",
"441798", "Pulborough",
"441256", "Basingstoke",
"442888", "Northern\ Ireland",
"441286", "Caernarfon",
"4414234", "Boroughbridge",
"442824", "Northern\ Ireland",
"441586", "Campbeltown",
"441899", "Biggar",
"4414347", "Hexham",
"441381", "Fortrose",
"442880", "Carrickmore",
"441556", "Castle\ Douglas",
"441790", "Spilsby",
"441656", "Bridgend",
"4419752", "Alford\ \(Aberdeen\)",
"441758", "Pwllheli",
"441296", "Aylesbury",
"441470", "Isle\ of\ Skye\ \-\ Edinbane",
"442898", "Belfast",
"441788", "Rugby",
"441350", "Dunkeld",
"441324", "Falkirk",
"441877", "Callander",
"442881", "Newtownstewart",
"4418906", "Ayton",
"441380", "Devizes",
"441471", "Isle\ of\ Skye\ \-\ Broadford",
"441825", "Uckfield",
"441466", "Huntly",
"441830", "Kirkwhelpington",
"441398", "Dulverton",
"441933", "Wellingborough",
"44247", "Coventry",
"441346", "Fraserburgh",
"4414232", "Harrogate",
"441227", "Canterbury",
"441641", "Strathy",
"441275", "Clevedon",
"441945", "Wisbech",
"441406", "Holbeach",
"441978", "Wrexham",
"4418472", "Thurso",
"442846", "Northern\ Ireland",
"44283", "Northern\ Ireland",
"441540", "Kingussie",
"441248", "Bangor\ \(Gwynedd\)",
"441765", "Ripon",
"441623", "Mansfield",
"441332", "Derby",
"441882", "Kinloch\ Rannoch",
"4414308", "Market\ Weighton",
"441852", "Kilmelford",
"44238", "Southampton",
"4414340", "Bellingham\/Haltwhistle\/Hexham",
"4419648", "Hornsea",
"441773", "Ripley",
"441567", "Killin",
"442899", "Northern\ Ireland",
"4414301", "North\ Cave\/Market\ Weighton",
"441824", "Ruthin",
"441789", "Stratford\-upon\-Avon",
"442311", "Southampton",
"441926", "Warwick",
"4419641", "Hornsea\/Patrington",
"441642", "Middlesbrough",
"441377", "Driffield",
"441759", "Pocklington",
"441880", "Tarbert",
"441325", "Darlington",
"441330", "Banchory",
"441542", "Keith",
"441493", "Great\ Yarmouth",
"441667", "Nairn",
"441636", "Newark\-on\-Trent",
"442310", "Portsmouth",
"441738", "Perth",
"442877", "Limavady",
"441487", "Warboys",
"442830", "Newry",
"441704", "Southport",
"442825", "Ballymena",
"441263", "Cromer",
"441457", "Glossop",
"441536", "Kettering",
"4413396", "Ballater",
"441832", "Clopton",
"4416974", "Raughton\ Head",
"44281", "Northern\ Ireland",
"441997", "Strathpeffer",
"441382", "Dundee",
"441352", "Mold",
"441764", "Crieff",
"441274", "Bradford",
"441472", "Grimsby",
"44114", "Sheffield",
"441944", "West\ Heslerton",
"442882", "Omagh",
"44131", "Edinburgh",
"4412295", "Barrow\-in\-Furness",
"441792", "Swansea",
"441249", "Chippenham",
"441913", "Durham",
"441953", "Wymondham",
"441983", "Isle\ of\ Wight",
"441375", "Grays\ Thurrock",
"441740", "Sedgefield",
"4413399", "Ballater",
"441565", "Knutsford",
"441723", "Scarborough",
"441246", "Chesterfield",
"441665", "Alnwick",
"441874", "Brecon",
"442848", "Northern\ Ireland",
"441327", "Daventry",
"4416867", "Llanidloes",
"441803", "Torquay",
"441408", "Golspie",
"4412292", "Barrow\-in\-Furness",
"4414377", "Haverfordwest",
"441455", "Hinckley",
"442827", "Ballymoney",
"441348", "Fishguard",
"441485", "Hunstanton",
"441639", "Neath",
"4414370", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441591", "Llanwrtyd\ Wells",
"441863", "Ardgay",
"441900", "Workington",
"441691", "Oswestry",
"4416860", "Newtown\/Llanidloes",
"441995", "Garstang",
"441539", "Kendal",
"441688", "Isle\ of\ Mull\ \-\ Tobermory",
"441786", "Stirling",
"441505", "Johnstone",
"442896", "Belfast",
"4418903", "Coldstream",
"441929", "Wareham",
"441298", "Buxton",
"441756", "Skipton",
"441590", "Lymington",
"441690", "Betws\-y\-Coed",
"441250", "Blairgowrie",
"441558", "Llandeilo",
"441224", "Aberdeen",
"441422", "Halifax",
"441588", "Bishops\ Castle",
"441280", "Buckingham",
"442849", "Northern\ Ireland",
"441282", "Burnley",
"441303", "Folkestone",
"441420", "Alton",
"441454", "Chipping\ Sodbury",
"441435", "Heathfield",
"441252", "Aldershot",
"441707", "Welwyn\ Garden\ City",
"441484", "Huddersfield",
"441692", "North\ Walsham",
"441592", "Kirkcaldy",
"4418517", "Stornoway",
"441848", "Thornhill",
"4418909", "Ayton",
"441443", "Pontypridd",
"4414235", "Harrogate",
"441664", "Melton\ Mowbray",
"44121", "Birmingham",
"441349", "Dingwall",
"4415070", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441875", "Tranent",
"441902", "Wolverhampton",
"4414304", "North\ Cave",
"4418475", "Thurso",
"441827", "Tamworth",
"4419644", "Patrington",
"441409", "Holsworthy",
"441564", "Lapworth",
"441225", "Bath",
"441962", "Winchester",
"441538", "Ipstones",
"441604", "Northampton",
"4419755", "Alford\ \(Aberdeen\)",
"4415077", "Louth",
"441947", "Whitby",
"441469", "Killingholme",
"441277", "Brentwood",
"441638", "Newmarket",
"441736", "Penzance",
"441573", "Kelso",
"441767", "Sandy",
"441896", "Galashiels",
"441994", "St\ Clears",
"441559", "Llandysul",
"441363", "Crediton",
"4418510", "Great\ Bernera\/Stornoway",
"441659", "Sanquhar",
"441928", "Runcorn",
"441299", "Bewdley",
"441689", "Orpington",
"4413393", "Aboyne",
"441673", "Market\ Rasen",
"441856", "Orkney",
"4414373", "Clynderwen\ \(Clunderwen\)",
"441631", "Oban",
"4419642", "Hornsea",
"441984", "Watchet\ \(Williton\)",
"44118", "Reading",
"441599", "Kyle",
"441886", "Bromyard\ \(Knightwick\/Leigh\ Sinton\)",
"441914", "Tyneside",
"4414302", "North\ Cave",
"441920", "Ware",
"442867", "Lisnaskea",
"441954", "Madingley",
"44115", "Nottingham",
"441935", "Yeovil",
"4416863", "Llanidloes",
"441259", "Alloa",
"4415396", "Sedbergh",
"4415079", "Alford\ \(Lincs\)",
"441943", "Guiseley",
"441289", "Berwick\-upon\-Tweed",
"4418478", "Thurso",
"442842", "Kircubbin",
"441273", "Brighton",
"441531", "Ledbury",
"441630", "Market\ Drayton",
"441625", "Macclesfield",
"441577", "Kinross",
"441763", "Royston",
"441204", "Bolton",
"441367", "Faringdon",
"4418900", "Coldstream\/Ayton",
"441909", "Worksop",
"441530", "Coalville",
"441525", "Leighton\ Buzzard",
"441677", "Bedale",
"4414238", "Harrogate",
"441342", "East\ Grinstead",
"441307", "Forfar",
"441264", "Andover",
"441841", "Newquay\ \(Padstow\)",
"44161", "Manchester",
"441462", "Hitchin",
"44151", "Liverpool",
"4418907", "Ayton",
"4418519", "Great\ Bernera",
"441969", "Leyburn",
"44292", "Cardiff",
"441494", "High\ Wycombe",
"441840", "Camelford",
"441652", "Brigg",
"4419758", "Strathdon",
"441292", "Ayr",
"441749", "Shepton\ Mallet",
"441428", "Haslemere",
"441582", "Luton",
"4414346", "Hexham",
"441823", "Taunton",
"441288", "Bude",
"441580", "Cranbrook",
"441524", "Lancaster",
"442886", "Cookstown",
"441550", "Llandovery",
"441258", "Blandford",
"441796", "Pitlochry",
"441698", "Motherwell",
"441598", "Lynton",
"4412294", "Barrow\-in\-Furness",
"441290", "Cumnock",
"441476", "Grantham",
"441461", "Gretna",
"441624", "Isle\ of\ Man",
"441650", "Cemmaes\ Road",
"441842", "Thetford",
"4413880", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441205", "Boston",
"441680", "Isle\ of\ Mull\ \-\ Craignure",
"4419751", "Alford\ \(Aberdeen\)\/Strathdon",
"441239", "Cardigan",
"441356", "Brechin",
"441581", "New\ Luce",
"4418513", "Stornoway",
"441908", "Milton\ Keynes",
"441386", "Evesham",
"441651", "Oldmeldrum",
"441460", "Chard",
"441291", "Chepstow",
"441985", "Warminster",
"4413390", "Aboyne\/Ballater",
"441681", "Isle\ of\ Mull\ \-\ Fionnphort",
"441955", "Wick",
"441934", "Weston\-super\-Mare",
"44113", "Leeds",
"441915", "Sunderland",
"441340", "Craigellachie\ \(Aberlour\)",
"442841", "Rostrevor",
"4420", "London",
"441968", "Penicuik",
"441775", "Spalding",
"4413397", "Ballater",
"4414231", "Harrogate\/Boroughbridge",
"441495", "Pontypool",
"441727", "St\ Albans",
"441323", "Eastbourne",
"441400", "Honington",
"441429", "Hartlepool",
"4415073", "Louth",
"441807", "Ballindalloch",
"442840", "Banbridge",
"441341", "Barmouth",
"4416869", "Newtown",
"4418471", "Thurso\/Tongue",
"441546", "Lochgilphead",
"441922", "Walsall",
"441646", "Milford\ Haven",
"441748", "Richmond",
"4414379", "Haverfordwest",
"442823", "Northern\ Ireland",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+44|\D)//g;
      my $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:([25-8]\d{5})$|0)//;
      $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;