# localslackirc
# Copyright (C) 2020-2025 Salvo "LtWorf" Tomaselli
#
# localslackirc is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# author Salvo "LtWorf" Tomaselli <tiposchi@tiscali.it>

import os
import unittest
import subprocess
import tempfile
from pathlib import Path


if os.path.exists("./localslackirc"):
    # inside source directory
    localslackirc = "./localslackirc"
else:
    # test installed program
    localslackirc = "localslackirc"


class TestStart(unittest.TestCase):

    def test_print_help(self):
        subprocess.check_call([localslackirc, '--help'], stdout=subprocess.DEVNULL)

    def test_test_status_file(self):
        with self.assertRaises(subprocess.CalledProcessError):
            subprocess.check_call([localslackirc, '--status-file', '/a', '--port', '12345'], env={'TOKEN':'123'})

        t = Path(tempfile.mktemp())
        t.write_bytes(b'')
        t.chmod(0o000)
        with self.assertRaises(subprocess.CalledProcessError):
            subprocess.check_call([localslackirc, '--status-file', t, '--port', '12345'], env={'TOKEN':'123'})
        t.unlink()

    def test_downloads_dir(self):
        with self.assertRaises(subprocess.CalledProcessError):
            subprocess.check_call([localslackirc, '--downloads-directory', '/', '--port', '12345'], env={'FORMATTED_MAX_LINES':'3', 'TOKEN':'123'})
        with self.assertRaises(subprocess.CalledProcessError):
            subprocess.check_call([localslackirc, '--downloads-directory', '/a', '--port', '12345'], env={'FORMATTED_MAX_LINES':'3', 'TOKEN':'123'})
