/*
 * Copyright University of Reims Champagne-Ardenne
 * Authors and Contributors: Akilan RAJAMANI, Corentin LEFEBVRE, Johanna KLEIN,
 *                           Emmanuel PLUOT, Gaetan RUBEZ, Hassan KHARTABIL,
 *                           Jean-Charles BOISSON and Eric HENON
 * (24/07/2017)
 * jean-charles.boisson@univ-reims.fr, eric.henon@univ-reims.fr
 *
 * This software is a computer program whose purpose is to
 * detect and quantify interactions from electron density
 * obtained either internally from promolecular density or
 * calculated from an input wave function input file. It also
 * prepares for the visualization of isosurfaces representing
 * several descriptors (dg) coming from the IGM methodology.
 *
 * This software is governed by the CeCILL-C license under French law and
 * abiding by the rules of distribution of free software.  You can  use,
 * modify and/ or redistribute the software under the terms of the CeCILL-C
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info".
 *
 * As a counterpart to the access to the source code and  rights to copy,
 * modify and redistribute granted by the license, users are provided only
 * with a limited warranty  and the software's author,  the holder of the
 * economic rights,  and the successive licensors  have only  limited
 * liability.
 *
 * In this respect, the user's attention is drawn to the risks associated
 * with loading,  using,  modifying and/or developing or reproducing the
 * software by the user in light of its specific status of free software,
 * that may mean  that it is complicated to manipulate,  and  that  also
 * therefore means  that it is reserved for developers  and  experienced
 * professionals having in-depth computer knowledge. Users are therefore
 * encouraged to load and test the software's suitability as regards their
 * requirements in conditions enabling the security of their systems and/or
 * data to be ensured and,  more generally, to use and operate it in the
 * same conditions as regards security.
 *
 * The fact that you are presently reading this means that you have had
 * knowledge of the CeCILL-C license and that you accept its terms.
 *
 * */

/**
 * @file igmplot.h
 *
 * @brief Tool for IGMplot main */

// STL
#include <sys/time.h>
#include <cstring>

// LOCAL
#include <NCISolver.h>


/**
 *@fn void checkOutputFileSize(const double predictedOutputSize, const bool outputSizeLimitActivated, const unsigned int outputSizeLimitInMB=2048)
 *@brief Procedure which checks that the predicted size of output files are correct according to outputSizeLimitInMB
 *@param predictedOutputSize The predicted size according to a NCISolver object
 *@param outputSizeLimitActivated If true check that predictedOutputSize < outputSizeLimitInGP  
 *@param outputSizeLimitInMB The allowed max size of output files */
void checkOutputFileSize(const double predictedOutputSize, const bool outputSizeLimitActivated, const unsigned int outputSizeLimitInMB=2048);

/**
 * @fn int main(int argc, char **argv)
 * @brief the main */
int main(int argc, char **argv);
