
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_parcsr_mv.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CSRMatrixToParCSRMatrix_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_CSRMatrix A_CSR, HYPRE_BigInt *row_partitioning, HYPRE_BigInt *col_partitioning, HYPRE_ParCSRMatrix *matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_CSRMatrixToParCSRMatrix_flt( comm, A_CSR, row_partitioning, col_partitioning, matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_CSRMatrixToParCSRMatrix_dbl( comm, A_CSR, row_partitioning, col_partitioning, matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_CSRMatrixToParCSRMatrix_long_dbl( comm, A_CSR, row_partitioning, col_partitioning, matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_CSRMatrixToParCSRMatrix_WithNewPartitioning_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_CSRMatrix A_CSR, HYPRE_ParCSRMatrix *matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_CSRMatrixToParCSRMatrix_WithNewPartitioning_flt( comm, A_CSR, matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_CSRMatrixToParCSRMatrix_WithNewPartitioning_dbl( comm, A_CSR, matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_CSRMatrixToParCSRMatrix_WithNewPartitioning_long_dbl( comm, A_CSR, matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixComputeScalingTagged_pre( HYPRE_Precision precision, HYPRE_ParCSRMatrix A, HYPRE_Int type, HYPRE_MemoryLocation memloc_tags, HYPRE_Int num_tags, HYPRE_Int *tags, HYPRE_ParVector *scaling_ptr )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRMatrixComputeScalingTagged_flt( A, type, memloc_tags, num_tags, tags, scaling_ptr );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRMatrixComputeScalingTagged_dbl( A, type, memloc_tags, num_tags, tags, scaling_ptr );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRMatrixComputeScalingTagged_long_dbl( A, type, memloc_tags, num_tags, tags, scaling_ptr );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_BigInt global_num_rows, HYPRE_BigInt global_num_cols, HYPRE_BigInt *row_starts, HYPRE_BigInt *col_starts, HYPRE_Int num_cols_offd, HYPRE_Int num_nonzeros_diag, HYPRE_Int num_nonzeros_offd, HYPRE_ParCSRMatrix *matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRMatrixCreate_flt( comm, global_num_rows, global_num_cols, row_starts, col_starts, num_cols_offd, num_nonzeros_diag, num_nonzeros_offd, matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRMatrixCreate_dbl( comm, global_num_rows, global_num_cols, row_starts, col_starts, num_cols_offd, num_nonzeros_diag, num_nonzeros_offd, matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRMatrixCreate_long_dbl( comm, global_num_rows, global_num_cols, row_starts, col_starts, num_cols_offd, num_nonzeros_diag, num_nonzeros_offd, matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixDestroy_pre( HYPRE_Precision precision, HYPRE_ParCSRMatrix matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRMatrixDestroy_flt( matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRMatrixDestroy_dbl( matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRMatrixDestroy_long_dbl( matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixDiagScale_pre( HYPRE_Precision precision, HYPRE_ParCSRMatrix A, HYPRE_ParVector left, HYPRE_ParVector right )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRMatrixDiagScale_flt( A, left, right );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRMatrixDiagScale_dbl( A, left, right );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRMatrixDiagScale_long_dbl( A, left, right );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixGetColPartitioning_pre( HYPRE_Precision precision, HYPRE_ParCSRMatrix matrix, HYPRE_BigInt **col_partitioning_ptr )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRMatrixGetColPartitioning_flt( matrix, col_partitioning_ptr );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRMatrixGetColPartitioning_dbl( matrix, col_partitioning_ptr );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRMatrixGetColPartitioning_long_dbl( matrix, col_partitioning_ptr );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixGetComm_pre( HYPRE_Precision precision, HYPRE_ParCSRMatrix matrix, MPI_Comm *comm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRMatrixGetComm_flt( matrix, comm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRMatrixGetComm_dbl( matrix, comm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRMatrixGetComm_long_dbl( matrix, comm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixGetDims_pre( HYPRE_Precision precision, HYPRE_ParCSRMatrix matrix, HYPRE_BigInt *M, HYPRE_BigInt *N )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRMatrixGetDims_flt( matrix, M, N );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRMatrixGetDims_dbl( matrix, M, N );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRMatrixGetDims_long_dbl( matrix, M, N );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixGetGlobalRowPartitioning_pre( HYPRE_Precision precision, HYPRE_ParCSRMatrix matrix, HYPRE_Int all_procs, HYPRE_BigInt **row_partitioning_ptr )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRMatrixGetGlobalRowPartitioning_flt( matrix, all_procs, row_partitioning_ptr );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRMatrixGetGlobalRowPartitioning_dbl( matrix, all_procs, row_partitioning_ptr );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRMatrixGetGlobalRowPartitioning_long_dbl( matrix, all_procs, row_partitioning_ptr );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixGetLocalRange_pre( HYPRE_Precision precision, HYPRE_ParCSRMatrix matrix, HYPRE_BigInt *row_start, HYPRE_BigInt *row_end, HYPRE_BigInt *col_start, HYPRE_BigInt *col_end )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRMatrixGetLocalRange_flt( matrix, row_start, row_end, col_start, col_end );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRMatrixGetLocalRange_dbl( matrix, row_start, row_end, col_start, col_end );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRMatrixGetLocalRange_long_dbl( matrix, row_start, row_end, col_start, col_end );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixGetRow_pre( HYPRE_Precision precision, HYPRE_ParCSRMatrix matrix, HYPRE_BigInt row, HYPRE_Int *size, HYPRE_BigInt **col_ind, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRMatrixGetRow_flt( matrix, row, size, col_ind, (hypre_float **)values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRMatrixGetRow_dbl( matrix, row, size, col_ind, (hypre_double **)values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRMatrixGetRow_long_dbl( matrix, row, size, col_ind, (hypre_long_double **)values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixGetRowPartitioning_pre( HYPRE_Precision precision, HYPRE_ParCSRMatrix matrix, HYPRE_BigInt **row_partitioning_ptr )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRMatrixGetRowPartitioning_flt( matrix, row_partitioning_ptr );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRMatrixGetRowPartitioning_dbl( matrix, row_partitioning_ptr );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRMatrixGetRowPartitioning_long_dbl( matrix, row_partitioning_ptr );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixInitialize_pre( HYPRE_Precision precision, HYPRE_ParCSRMatrix matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRMatrixInitialize_flt( matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRMatrixInitialize_dbl( matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRMatrixInitialize_long_dbl( matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixMatmat_pre( HYPRE_Precision precision, HYPRE_ParCSRMatrix A, HYPRE_ParCSRMatrix B, HYPRE_ParCSRMatrix *C )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRMatrixMatmat_flt( A, B, C );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRMatrixMatmat_dbl( A, B, C );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRMatrixMatmat_long_dbl( A, B, C );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixMatvec_pre( HYPRE_Precision precision, hypre_long_double alpha, HYPRE_ParCSRMatrix A, HYPRE_ParVector x, hypre_long_double beta, HYPRE_ParVector y )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRMatrixMatvec_flt( (hypre_float)alpha, A, x, (hypre_float)beta, y );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRMatrixMatvec_dbl( (hypre_double)alpha, A, x, (hypre_double)beta, y );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRMatrixMatvec_long_dbl( (hypre_long_double)alpha, A, x, (hypre_long_double)beta, y );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixMatvecT_pre( HYPRE_Precision precision, hypre_long_double alpha, HYPRE_ParCSRMatrix A, HYPRE_ParVector x, hypre_long_double beta, HYPRE_ParVector y )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRMatrixMatvecT_flt( (hypre_float)alpha, A, x, (hypre_float)beta, y );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRMatrixMatvecT_dbl( (hypre_double)alpha, A, x, (hypre_double)beta, y );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRMatrixMatvecT_long_dbl( (hypre_long_double)alpha, A, x, (hypre_long_double)beta, y );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixPrint_pre( HYPRE_Precision precision, HYPRE_ParCSRMatrix matrix, const char *file_name )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRMatrixPrint_flt( matrix, file_name );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRMatrixPrint_dbl( matrix, file_name );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRMatrixPrint_long_dbl( matrix, file_name );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixRead_pre( HYPRE_Precision precision, MPI_Comm comm, const char *file_name, HYPRE_ParCSRMatrix *matrix )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRMatrixRead_flt( comm, file_name, matrix );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRMatrixRead_dbl( comm, file_name, matrix );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRMatrixRead_long_dbl( comm, file_name, matrix );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParCSRMatrixRestoreRow_pre( HYPRE_Precision precision, HYPRE_ParCSRMatrix matrix, HYPRE_BigInt row, HYPRE_Int *size, HYPRE_BigInt **col_ind, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParCSRMatrixRestoreRow_flt( matrix, row, size, col_ind, (hypre_float **)values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParCSRMatrixRestoreRow_dbl( matrix, row, size, col_ind, (hypre_double **)values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParCSRMatrixRestoreRow_long_dbl( matrix, row, size, col_ind, (hypre_long_double **)values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParMultiVectorCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_BigInt global_size, HYPRE_BigInt *partitioning, HYPRE_Int number_vectors, HYPRE_ParVector *vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParMultiVectorCreate_flt( comm, global_size, partitioning, number_vectors, vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParMultiVectorCreate_dbl( comm, global_size, partitioning, number_vectors, vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParMultiVectorCreate_long_dbl( comm, global_size, partitioning, number_vectors, vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorAxpy_pre( HYPRE_Precision precision, hypre_long_double alpha, HYPRE_ParVector x, HYPRE_ParVector y )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParVectorAxpy_flt( (hypre_float)alpha, x, y );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParVectorAxpy_dbl( (hypre_double)alpha, x, y );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParVectorAxpy_long_dbl( (hypre_long_double)alpha, x, y );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_ParVector
HYPRE_ParVectorCloneShallow_pre( HYPRE_Precision precision, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParVectorCloneShallow_flt( x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParVectorCloneShallow_dbl( x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParVectorCloneShallow_long_dbl( x );
      default:
         { HYPRE_ParVector value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorCopy_pre( HYPRE_Precision precision, HYPRE_ParVector x, HYPRE_ParVector y )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParVectorCopy_flt( x, y );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParVectorCopy_dbl( x, y );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParVectorCopy_long_dbl( x, y );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_BigInt global_size, HYPRE_BigInt *partitioning, HYPRE_ParVector *vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParVectorCreate_flt( comm, global_size, partitioning, vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParVectorCreate_dbl( comm, global_size, partitioning, vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParVectorCreate_long_dbl( comm, global_size, partitioning, vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorDestroy_pre( HYPRE_Precision precision, HYPRE_ParVector vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParVectorDestroy_flt( vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParVectorDestroy_dbl( vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParVectorDestroy_long_dbl( vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorGetValues_pre( HYPRE_Precision precision, HYPRE_ParVector vector, HYPRE_Int num_values, HYPRE_BigInt *indices, void *values )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParVectorGetValues_flt( vector, num_values, indices, (hypre_float *)values );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParVectorGetValues_dbl( vector, num_values, indices, (hypre_double *)values );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParVectorGetValues_long_dbl( vector, num_values, indices, (hypre_long_double *)values );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorInitialize_pre( HYPRE_Precision precision, HYPRE_ParVector vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParVectorInitialize_flt( vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParVectorInitialize_dbl( vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParVectorInitialize_long_dbl( vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorInnerProd_pre( HYPRE_Precision precision, HYPRE_ParVector x, HYPRE_ParVector y, void *result )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParVectorInnerProd_flt( x, y, (hypre_float *)result );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParVectorInnerProd_dbl( x, y, (hypre_double *)result );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParVectorInnerProd_long_dbl( x, y, (hypre_long_double *)result );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorPrint_pre( HYPRE_Precision precision, HYPRE_ParVector vector, const char *file_name )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParVectorPrint_flt( vector, file_name );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParVectorPrint_dbl( vector, file_name );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParVectorPrint_long_dbl( vector, file_name );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorPrintBinaryIJ_pre( HYPRE_Precision precision, HYPRE_ParVector vector, const char *file_name )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParVectorPrintBinaryIJ_flt( vector, file_name );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParVectorPrintBinaryIJ_dbl( vector, file_name );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParVectorPrintBinaryIJ_long_dbl( vector, file_name );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorRead_pre( HYPRE_Precision precision, MPI_Comm comm, const char *file_name, HYPRE_ParVector *vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParVectorRead_flt( comm, file_name, vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParVectorRead_dbl( comm, file_name, vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParVectorRead_long_dbl( comm, file_name, vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorScale_pre( HYPRE_Precision precision, hypre_long_double value, HYPRE_ParVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParVectorScale_flt( (hypre_float)value, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParVectorScale_dbl( (hypre_double)value, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParVectorScale_long_dbl( (hypre_long_double)value, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorSetConstantValues_pre( HYPRE_Precision precision, HYPRE_ParVector vector, hypre_long_double value )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParVectorSetConstantValues_flt( vector, (hypre_float)value );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParVectorSetConstantValues_dbl( vector, (hypre_double)value );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParVectorSetConstantValues_long_dbl( vector, (hypre_long_double)value );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_ParVectorSetRandomValues_pre( HYPRE_Precision precision, HYPRE_ParVector vector, HYPRE_Int seed )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_ParVectorSetRandomValues_flt( vector, seed );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_ParVectorSetRandomValues_dbl( vector, seed );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_ParVectorSetRandomValues_long_dbl( vector, seed );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_VectorToParVector_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_Vector b, HYPRE_BigInt *partitioning, HYPRE_ParVector *vector )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_VectorToParVector_flt( comm, b, partitioning, vector );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_VectorToParVector_dbl( comm, b, partitioning, vector );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_VectorToParVector_long_dbl( comm, b, partitioning, vector );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}


/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_Destroy2DSystem_pre( HYPRE_Precision precision, HYPRE_ParCSR_System_Problem *sys_prob )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_Destroy2DSystem_flt( sys_prob );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_Destroy2DSystem_dbl( sys_prob );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_Destroy2DSystem_long_dbl( sys_prob );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_ParCSR_System_Problem *
HYPRE_Generate2DSystem_pre( HYPRE_Precision precision, HYPRE_ParCSRMatrix H_L1, HYPRE_ParCSRMatrix H_L2, HYPRE_ParVector H_b1, HYPRE_ParVector H_b2, HYPRE_ParVector H_x1, HYPRE_ParVector H_x2, void *M_vals )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_Generate2DSystem_flt( H_L1, H_L2, H_b1, H_b2, H_x1, H_x2, (hypre_float *)M_vals );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_Generate2DSystem_dbl( H_L1, H_L2, H_b1, H_b2, H_x1, H_x2, (hypre_double *)M_vals );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_Generate2DSystem_long_dbl( H_L1, H_L2, H_b1, H_b2, H_x1, H_x2, (hypre_long_double *)M_vals );
      default:
         { HYPRE_ParCSR_System_Problem * value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}


#endif

