
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_struct_ls.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_StructSolver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructBiCGSTABCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructBiCGSTABCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructBiCGSTABCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABDestroy_pre( HYPRE_Precision precision, HYPRE_StructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructBiCGSTABDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructBiCGSTABDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructBiCGSTABDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructBiCGSTABGetFinalRelativeResidualNorm_flt( solver, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructBiCGSTABGetFinalRelativeResidualNorm_dbl( solver, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructBiCGSTABGetFinalRelativeResidualNorm_long_dbl( solver, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABGetNumIterations_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructBiCGSTABGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructBiCGSTABGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructBiCGSTABGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABGetResidual_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, void **residual )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructBiCGSTABGetResidual_flt( solver, residual );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructBiCGSTABGetResidual_dbl( solver, residual );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructBiCGSTABGetResidual_long_dbl( solver, residual );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructBiCGSTABSetAbsoluteTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructBiCGSTABSetAbsoluteTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructBiCGSTABSetAbsoluteTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABSetLogging_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructBiCGSTABSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructBiCGSTABSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructBiCGSTABSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABSetMaxIter_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructBiCGSTABSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructBiCGSTABSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructBiCGSTABSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABSetPrecond_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_PtrToStructSolverFcn precond, HYPRE_PtrToStructSolverFcn precond_setup, HYPRE_StructSolver precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructBiCGSTABSetPrecond_flt( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructBiCGSTABSetPrecond_dbl( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructBiCGSTABSetPrecond_long_dbl( solver, precond, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructBiCGSTABSetPrintLevel_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructBiCGSTABSetPrintLevel_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructBiCGSTABSetPrintLevel_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABSetTol_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructBiCGSTABSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructBiCGSTABSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructBiCGSTABSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABSetup_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructBiCGSTABSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructBiCGSTABSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructBiCGSTABSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructBiCGSTABSolve_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructBiCGSTABSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructBiCGSTABSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructBiCGSTABSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructCycRedCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_StructSolver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructCycRedCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructCycRedCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructCycRedCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructCycRedDestroy_pre( HYPRE_Precision precision, HYPRE_StructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructCycRedDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructCycRedDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructCycRedDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructCycRedSetBase_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int ndim, HYPRE_Int *base_index, HYPRE_Int *base_stride )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructCycRedSetBase_flt( solver, ndim, base_index, base_stride );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructCycRedSetBase_dbl( solver, ndim, base_index, base_stride );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructCycRedSetBase_long_dbl( solver, ndim, base_index, base_stride );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructCycRedSetTDim_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int tdim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructCycRedSetTDim_flt( solver, tdim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructCycRedSetTDim_dbl( solver, tdim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructCycRedSetTDim_long_dbl( solver, tdim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructCycRedSetup_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructCycRedSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructCycRedSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructCycRedSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructCycRedSolve_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructCycRedSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructCycRedSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructCycRedSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructDiagScale_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_StructMatrix HA, HYPRE_StructVector Hy, HYPRE_StructVector Hx )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructDiagScale_flt( solver, HA, Hy, Hx );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructDiagScale_dbl( solver, HA, Hy, Hx );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructDiagScale_long_dbl( solver, HA, Hy, Hx );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructDiagScaleSetup_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector y, HYPRE_StructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructDiagScaleSetup_flt( solver, A, y, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructDiagScaleSetup_dbl( solver, A, y, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructDiagScaleSetup_long_dbl( solver, A, y, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_StructSolver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructFlexGMRESCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructFlexGMRESCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructFlexGMRESCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESDestroy_pre( HYPRE_Precision precision, HYPRE_StructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructFlexGMRESDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructFlexGMRESDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructFlexGMRESDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructFlexGMRESGetFinalRelativeResidualNorm_flt( solver, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructFlexGMRESGetFinalRelativeResidualNorm_dbl( solver, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructFlexGMRESGetFinalRelativeResidualNorm_long_dbl( solver, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESGetNumIterations_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructFlexGMRESGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructFlexGMRESGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructFlexGMRESGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructFlexGMRESSetAbsoluteTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructFlexGMRESSetAbsoluteTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructFlexGMRESSetAbsoluteTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESSetKDim_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int k_dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructFlexGMRESSetKDim_flt( solver, k_dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructFlexGMRESSetKDim_dbl( solver, k_dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructFlexGMRESSetKDim_long_dbl( solver, k_dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESSetLogging_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructFlexGMRESSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructFlexGMRESSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructFlexGMRESSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESSetMaxIter_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructFlexGMRESSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructFlexGMRESSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructFlexGMRESSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESSetModifyPC_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_PtrToModifyPCFcn modify_pc )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructFlexGMRESSetModifyPC_flt( solver, modify_pc );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructFlexGMRESSetModifyPC_dbl( solver, modify_pc );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructFlexGMRESSetModifyPC_long_dbl( solver, modify_pc );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESSetPrecond_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_PtrToStructSolverFcn precond, HYPRE_PtrToStructSolverFcn precond_setup, HYPRE_StructSolver precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructFlexGMRESSetPrecond_flt( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructFlexGMRESSetPrecond_dbl( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructFlexGMRESSetPrecond_long_dbl( solver, precond, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructFlexGMRESSetPrintLevel_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructFlexGMRESSetPrintLevel_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructFlexGMRESSetPrintLevel_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESSetTol_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructFlexGMRESSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructFlexGMRESSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructFlexGMRESSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESSetup_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructFlexGMRESSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructFlexGMRESSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructFlexGMRESSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructFlexGMRESSolve_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructFlexGMRESSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructFlexGMRESSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructFlexGMRESSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_StructSolver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructGMRESCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructGMRESCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructGMRESCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESDestroy_pre( HYPRE_Precision precision, HYPRE_StructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructGMRESDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructGMRESDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructGMRESDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructGMRESGetFinalRelativeResidualNorm_flt( solver, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructGMRESGetFinalRelativeResidualNorm_dbl( solver, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructGMRESGetFinalRelativeResidualNorm_long_dbl( solver, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESGetNumIterations_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructGMRESGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructGMRESGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructGMRESGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructGMRESSetAbsoluteTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructGMRESSetAbsoluteTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructGMRESSetAbsoluteTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESSetKDim_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int k_dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructGMRESSetKDim_flt( solver, k_dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructGMRESSetKDim_dbl( solver, k_dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructGMRESSetKDim_long_dbl( solver, k_dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESSetLogging_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructGMRESSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructGMRESSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructGMRESSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESSetMaxIter_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructGMRESSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructGMRESSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructGMRESSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESSetPrecond_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_PtrToStructSolverFcn precond, HYPRE_PtrToStructSolverFcn precond_setup, HYPRE_StructSolver precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructGMRESSetPrecond_flt( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructGMRESSetPrecond_dbl( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructGMRESSetPrecond_long_dbl( solver, precond, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructGMRESSetPrintLevel_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructGMRESSetPrintLevel_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructGMRESSetPrintLevel_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESSetTol_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructGMRESSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructGMRESSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructGMRESSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESSetup_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructGMRESSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructGMRESSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructGMRESSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructGMRESSolve_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructGMRESSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructGMRESSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructGMRESSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_StructSolver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructHybridCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructHybridCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructHybridCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridDestroy_pre( HYPRE_Precision precision, HYPRE_StructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructHybridDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructHybridDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructHybridDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridGetDSCGNumIterations_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *ds_num_its )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructHybridGetDSCGNumIterations_flt( solver, ds_num_its );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructHybridGetDSCGNumIterations_dbl( solver, ds_num_its );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructHybridGetDSCGNumIterations_long_dbl( solver, ds_num_its );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructHybridGetFinalRelativeResidualNorm_flt( solver, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructHybridGetFinalRelativeResidualNorm_dbl( solver, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructHybridGetFinalRelativeResidualNorm_long_dbl( solver, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridGetNumIterations_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *num_its )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructHybridGetNumIterations_flt( solver, num_its );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructHybridGetNumIterations_dbl( solver, num_its );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructHybridGetNumIterations_long_dbl( solver, num_its );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridGetPCGNumIterations_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *pre_num_its )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructHybridGetPCGNumIterations_flt( solver, pre_num_its );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructHybridGetPCGNumIterations_dbl( solver, pre_num_its );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructHybridGetPCGNumIterations_long_dbl( solver, pre_num_its );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridGetRecomputeResidual_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *recompute_residual )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructHybridGetRecomputeResidual_flt( solver, recompute_residual );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructHybridGetRecomputeResidual_dbl( solver, recompute_residual );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructHybridGetRecomputeResidual_long_dbl( solver, recompute_residual );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridGetRecomputeResidualP_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *recompute_residual_p )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructHybridGetRecomputeResidualP_flt( solver, recompute_residual_p );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructHybridGetRecomputeResidualP_dbl( solver, recompute_residual_p );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructHybridGetRecomputeResidualP_long_dbl( solver, recompute_residual_p );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetConvergenceTol_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, hypre_long_double cf_tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructHybridSetConvergenceTol_flt( solver, cf_tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructHybridSetConvergenceTol_dbl( solver, cf_tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructHybridSetConvergenceTol_long_dbl( solver, cf_tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetDSCGMaxIter_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int ds_max_its )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructHybridSetDSCGMaxIter_flt( solver, ds_max_its );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructHybridSetDSCGMaxIter_dbl( solver, ds_max_its );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructHybridSetDSCGMaxIter_long_dbl( solver, ds_max_its );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetKDim_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int k_dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructHybridSetKDim_flt( solver, k_dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructHybridSetKDim_dbl( solver, k_dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructHybridSetKDim_long_dbl( solver, k_dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetLogging_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructHybridSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructHybridSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructHybridSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetPCGAbsoluteTolFactor_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, hypre_long_double pcg_atolf )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructHybridSetPCGAbsoluteTolFactor_flt( solver, pcg_atolf );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructHybridSetPCGAbsoluteTolFactor_dbl( solver, pcg_atolf );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructHybridSetPCGAbsoluteTolFactor_long_dbl( solver, pcg_atolf );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetPCGMaxIter_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int pre_max_its )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructHybridSetPCGMaxIter_flt( solver, pre_max_its );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructHybridSetPCGMaxIter_dbl( solver, pre_max_its );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructHybridSetPCGMaxIter_long_dbl( solver, pre_max_its );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetPrecond_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_PtrToStructSolverFcn precond, HYPRE_PtrToStructSolverFcn precond_setup, HYPRE_StructSolver precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructHybridSetPrecond_flt( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructHybridSetPrecond_dbl( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructHybridSetPrecond_long_dbl( solver, precond, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructHybridSetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructHybridSetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructHybridSetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetRecomputeResidual_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int recompute_residual )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructHybridSetRecomputeResidual_flt( solver, recompute_residual );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructHybridSetRecomputeResidual_dbl( solver, recompute_residual );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructHybridSetRecomputeResidual_long_dbl( solver, recompute_residual );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetRecomputeResidualP_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int recompute_residual_p )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructHybridSetRecomputeResidualP_flt( solver, recompute_residual_p );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructHybridSetRecomputeResidualP_dbl( solver, recompute_residual_p );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructHybridSetRecomputeResidualP_long_dbl( solver, recompute_residual_p );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetRelChange_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int rel_change )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructHybridSetRelChange_flt( solver, rel_change );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructHybridSetRelChange_dbl( solver, rel_change );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructHybridSetRelChange_long_dbl( solver, rel_change );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetSolverType_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int solver_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructHybridSetSolverType_flt( solver, solver_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructHybridSetSolverType_dbl( solver, solver_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructHybridSetSolverType_long_dbl( solver, solver_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetStopCrit_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int stop_crit )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructHybridSetStopCrit_flt( solver, stop_crit );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructHybridSetStopCrit_dbl( solver, stop_crit );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructHybridSetStopCrit_long_dbl( solver, stop_crit );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetTol_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructHybridSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructHybridSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructHybridSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetTwoNorm_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int two_norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructHybridSetTwoNorm_flt( solver, two_norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructHybridSetTwoNorm_dbl( solver, two_norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructHybridSetTwoNorm_long_dbl( solver, two_norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSetup_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructHybridSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructHybridSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructHybridSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructHybridSolve_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructHybridSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructHybridSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructHybridSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_StructSolver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructJacobiCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructJacobiCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructJacobiCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiDestroy_pre( HYPRE_Precision precision, HYPRE_StructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructJacobiDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructJacobiDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructJacobiDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructJacobiGetFinalRelativeResidualNorm_flt( solver, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructJacobiGetFinalRelativeResidualNorm_dbl( solver, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructJacobiGetFinalRelativeResidualNorm_long_dbl( solver, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiGetMaxIter_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructJacobiGetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructJacobiGetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructJacobiGetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiGetNumIterations_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructJacobiGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructJacobiGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructJacobiGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiGetTol_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, void *tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructJacobiGetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructJacobiGetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructJacobiGetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiGetZeroGuess_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *zeroguess )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructJacobiGetZeroGuess_flt( solver, zeroguess );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructJacobiGetZeroGuess_dbl( solver, zeroguess );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructJacobiGetZeroGuess_long_dbl( solver, zeroguess );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiSetMaxIter_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructJacobiSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructJacobiSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructJacobiSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiSetNonZeroGuess_pre( HYPRE_Precision precision, HYPRE_StructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructJacobiSetNonZeroGuess_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructJacobiSetNonZeroGuess_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructJacobiSetNonZeroGuess_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiSetTol_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructJacobiSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructJacobiSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructJacobiSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiSetZeroGuess_pre( HYPRE_Precision precision, HYPRE_StructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructJacobiSetZeroGuess_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructJacobiSetZeroGuess_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructJacobiSetZeroGuess_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiSetup_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructJacobiSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructJacobiSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructJacobiSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructJacobiSolve_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructJacobiSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructJacobiSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructJacobiSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_StructSolver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructLGMRESCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructLGMRESCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructLGMRESCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESDestroy_pre( HYPRE_Precision precision, HYPRE_StructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructLGMRESDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructLGMRESDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructLGMRESDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructLGMRESGetFinalRelativeResidualNorm_flt( solver, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructLGMRESGetFinalRelativeResidualNorm_dbl( solver, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructLGMRESGetFinalRelativeResidualNorm_long_dbl( solver, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESGetNumIterations_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructLGMRESGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructLGMRESGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructLGMRESGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructLGMRESSetAbsoluteTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructLGMRESSetAbsoluteTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructLGMRESSetAbsoluteTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESSetAugDim_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int aug_dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructLGMRESSetAugDim_flt( solver, aug_dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructLGMRESSetAugDim_dbl( solver, aug_dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructLGMRESSetAugDim_long_dbl( solver, aug_dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESSetKDim_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int k_dim )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructLGMRESSetKDim_flt( solver, k_dim );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructLGMRESSetKDim_dbl( solver, k_dim );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructLGMRESSetKDim_long_dbl( solver, k_dim );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESSetLogging_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructLGMRESSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructLGMRESSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructLGMRESSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESSetMaxIter_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructLGMRESSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructLGMRESSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructLGMRESSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESSetPrecond_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_PtrToStructSolverFcn precond, HYPRE_PtrToStructSolverFcn precond_setup, HYPRE_StructSolver precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructLGMRESSetPrecond_flt( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructLGMRESSetPrecond_dbl( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructLGMRESSetPrecond_long_dbl( solver, precond, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructLGMRESSetPrintLevel_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructLGMRESSetPrintLevel_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructLGMRESSetPrintLevel_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESSetTol_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructLGMRESSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructLGMRESSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructLGMRESSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESSetup_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructLGMRESSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructLGMRESSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructLGMRESSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructLGMRESSolve_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructLGMRESSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructLGMRESSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructLGMRESSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_StructSolver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPCGCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPCGCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPCGCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGDestroy_pre( HYPRE_Precision precision, HYPRE_StructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPCGDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPCGDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPCGDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPCGGetFinalRelativeResidualNorm_flt( solver, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPCGGetFinalRelativeResidualNorm_dbl( solver, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPCGGetFinalRelativeResidualNorm_long_dbl( solver, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGGetNumIterations_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPCGGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPCGGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPCGGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGSetAbsoluteTol_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPCGSetAbsoluteTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPCGSetAbsoluteTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPCGSetAbsoluteTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGSetLogging_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPCGSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPCGSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPCGSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGSetMaxIter_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPCGSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPCGSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPCGSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGSetPrecond_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_PtrToStructSolverFcn precond, HYPRE_PtrToStructSolverFcn precond_setup, HYPRE_StructSolver precond_solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPCGSetPrecond_flt( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPCGSetPrecond_dbl( solver, precond, precond_setup, precond_solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPCGSetPrecond_long_dbl( solver, precond, precond_setup, precond_solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPCGSetPrintLevel_flt( solver, level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPCGSetPrintLevel_dbl( solver, level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPCGSetPrintLevel_long_dbl( solver, level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGSetRelChange_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int rel_change )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPCGSetRelChange_flt( solver, rel_change );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPCGSetRelChange_dbl( solver, rel_change );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPCGSetRelChange_long_dbl( solver, rel_change );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGSetTol_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPCGSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPCGSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPCGSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGSetTwoNorm_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int two_norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPCGSetTwoNorm_flt( solver, two_norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPCGSetTwoNorm_dbl( solver, two_norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPCGSetTwoNorm_long_dbl( solver, two_norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGSetup_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPCGSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPCGSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPCGSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPCGSolve_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPCGSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPCGSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPCGSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_StructSolver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGDestroy_pre( HYPRE_Precision precision, HYPRE_StructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGGetFinalRelativeResidualNorm_flt( solver, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGGetFinalRelativeResidualNorm_dbl( solver, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGGetFinalRelativeResidualNorm_long_dbl( solver, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetJacobiWeight_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, void *weight )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGGetJacobiWeight_flt( solver, weight );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGGetJacobiWeight_dbl( solver, weight );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGGetJacobiWeight_long_dbl( solver, weight );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetLogging_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGGetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGGetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGGetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetMatmultType_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *matmult_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGGetMatmultType_flt( solver, matmult_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGGetMatmultType_dbl( solver, matmult_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGGetMatmultType_long_dbl( solver, matmult_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetMaxIter_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGGetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGGetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGGetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetMaxLevels_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *max_levels )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGGetMaxLevels_flt( solver, max_levels );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGGetMaxLevels_dbl( solver, max_levels );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGGetMaxLevels_long_dbl( solver, max_levels );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetNumIterations_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetNumPostRelax_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *num_post_relax )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGGetNumPostRelax_flt( solver, num_post_relax );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGGetNumPostRelax_dbl( solver, num_post_relax );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGGetNumPostRelax_long_dbl( solver, num_post_relax );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetNumPreRelax_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *num_pre_relax )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGGetNumPreRelax_flt( solver, num_pre_relax );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGGetNumPreRelax_dbl( solver, num_pre_relax );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGGetNumPreRelax_long_dbl( solver, num_pre_relax );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetPrintLevel_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGGetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGGetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGGetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetRAPType_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *rap_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGGetRAPType_flt( solver, rap_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGGetRAPType_dbl( solver, rap_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGGetRAPType_long_dbl( solver, rap_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetRelChange_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *rel_change )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGGetRelChange_flt( solver, rel_change );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGGetRelChange_dbl( solver, rel_change );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGGetRelChange_long_dbl( solver, rel_change );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetRelaxType_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *relax_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGGetRelaxType_flt( solver, relax_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGGetRelaxType_dbl( solver, relax_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGGetRelaxType_long_dbl( solver, relax_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetSkipRelax_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *skip_relax )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGGetSkipRelax_flt( solver, skip_relax );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGGetSkipRelax_dbl( solver, skip_relax );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGGetSkipRelax_long_dbl( solver, skip_relax );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetTol_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, void *tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGGetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGGetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGGetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGGetZeroGuess_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *zeroguess )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGGetZeroGuess_flt( solver, zeroguess );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGGetZeroGuess_dbl( solver, zeroguess );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGGetZeroGuess_long_dbl( solver, zeroguess );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetDxyz_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, void *dxyz )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGSetDxyz_flt( solver, dxyz );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGSetDxyz_dbl( solver, dxyz );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGSetDxyz_long_dbl( solver, dxyz );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetJacobiWeight_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, hypre_long_double weight )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGSetJacobiWeight_flt( solver, weight );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGSetJacobiWeight_dbl( solver, weight );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGSetJacobiWeight_long_dbl( solver, weight );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetLogging_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetMatmultType_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int matmult_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGSetMatmultType_flt( solver, matmult_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGSetMatmultType_dbl( solver, matmult_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGSetMatmultType_long_dbl( solver, matmult_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetMaxIter_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetMaxLevels_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int max_levels )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGSetMaxLevels_flt( solver, max_levels );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGSetMaxLevels_dbl( solver, max_levels );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGSetMaxLevels_long_dbl( solver, max_levels );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetNonZeroGuess_pre( HYPRE_Precision precision, HYPRE_StructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGSetNonZeroGuess_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGSetNonZeroGuess_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGSetNonZeroGuess_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetNumPostRelax_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int num_post_relax )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGSetNumPostRelax_flt( solver, num_post_relax );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGSetNumPostRelax_dbl( solver, num_post_relax );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGSetNumPostRelax_long_dbl( solver, num_post_relax );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetNumPreRelax_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int num_pre_relax )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGSetNumPreRelax_flt( solver, num_pre_relax );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGSetNumPreRelax_dbl( solver, num_pre_relax );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGSetNumPreRelax_long_dbl( solver, num_pre_relax );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGSetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGSetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGSetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetRAPType_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int rap_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGSetRAPType_flt( solver, rap_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGSetRAPType_dbl( solver, rap_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGSetRAPType_long_dbl( solver, rap_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetRelChange_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int rel_change )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGSetRelChange_flt( solver, rel_change );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGSetRelChange_dbl( solver, rel_change );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGSetRelChange_long_dbl( solver, rel_change );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetRelaxType_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int relax_type )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGSetRelaxType_flt( solver, relax_type );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGSetRelaxType_dbl( solver, relax_type );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGSetRelaxType_long_dbl( solver, relax_type );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetSkipRelax_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int skip_relax )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGSetSkipRelax_flt( solver, skip_relax );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGSetSkipRelax_dbl( solver, skip_relax );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGSetSkipRelax_long_dbl( solver, skip_relax );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetTol_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetZeroGuess_pre( HYPRE_Precision precision, HYPRE_StructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGSetZeroGuess_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGSetZeroGuess_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGSetZeroGuess_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSetup_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructPFMGSolve_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructPFMGSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructPFMGSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructPFMGSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGCreate_pre( HYPRE_Precision precision, MPI_Comm comm, HYPRE_StructSolver *solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSMGCreate_flt( comm, solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSMGCreate_dbl( comm, solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSMGCreate_long_dbl( comm, solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGDestroy_pre( HYPRE_Precision precision, HYPRE_StructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSMGDestroy_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSMGDestroy_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSMGDestroy_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGGetFinalRelativeResidualNorm_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, void *norm )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSMGGetFinalRelativeResidualNorm_flt( solver, norm );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSMGGetFinalRelativeResidualNorm_dbl( solver, norm );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSMGGetFinalRelativeResidualNorm_long_dbl( solver, norm );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGGetLogging_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSMGGetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSMGGetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSMGGetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGGetMaxIter_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSMGGetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSMGGetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSMGGetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGGetMemoryUse_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *memory_use )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSMGGetMemoryUse_flt( solver, memory_use );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSMGGetMemoryUse_dbl( solver, memory_use );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSMGGetMemoryUse_long_dbl( solver, memory_use );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGGetNumIterations_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *num_iterations )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSMGGetNumIterations_flt( solver, num_iterations );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSMGGetNumIterations_dbl( solver, num_iterations );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSMGGetNumIterations_long_dbl( solver, num_iterations );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGGetNumPostRelax_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *num_post_relax )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSMGGetNumPostRelax_flt( solver, num_post_relax );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSMGGetNumPostRelax_dbl( solver, num_post_relax );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSMGGetNumPostRelax_long_dbl( solver, num_post_relax );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGGetNumPreRelax_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *num_pre_relax )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSMGGetNumPreRelax_flt( solver, num_pre_relax );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSMGGetNumPreRelax_dbl( solver, num_pre_relax );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSMGGetNumPreRelax_long_dbl( solver, num_pre_relax );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGGetPrintLevel_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSMGGetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSMGGetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSMGGetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGGetRelChange_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *rel_change )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSMGGetRelChange_flt( solver, rel_change );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSMGGetRelChange_dbl( solver, rel_change );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSMGGetRelChange_long_dbl( solver, rel_change );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGGetTol_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, void *tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSMGGetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSMGGetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSMGGetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGGetZeroGuess_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int *zeroguess )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSMGGetZeroGuess_flt( solver, zeroguess );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSMGGetZeroGuess_dbl( solver, zeroguess );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSMGGetZeroGuess_long_dbl( solver, zeroguess );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGSetLogging_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int logging )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSMGSetLogging_flt( solver, logging );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSMGSetLogging_dbl( solver, logging );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSMGSetLogging_long_dbl( solver, logging );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGSetMaxIter_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int max_iter )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSMGSetMaxIter_flt( solver, max_iter );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSMGSetMaxIter_dbl( solver, max_iter );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSMGSetMaxIter_long_dbl( solver, max_iter );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGSetMemoryUse_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int memory_use )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSMGSetMemoryUse_flt( solver, memory_use );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSMGSetMemoryUse_dbl( solver, memory_use );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSMGSetMemoryUse_long_dbl( solver, memory_use );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGSetNonZeroGuess_pre( HYPRE_Precision precision, HYPRE_StructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSMGSetNonZeroGuess_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSMGSetNonZeroGuess_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSMGSetNonZeroGuess_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGSetNumPostRelax_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int num_post_relax )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSMGSetNumPostRelax_flt( solver, num_post_relax );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSMGSetNumPostRelax_dbl( solver, num_post_relax );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSMGSetNumPostRelax_long_dbl( solver, num_post_relax );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGSetNumPreRelax_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int num_pre_relax )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSMGSetNumPreRelax_flt( solver, num_pre_relax );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSMGSetNumPreRelax_dbl( solver, num_pre_relax );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSMGSetNumPreRelax_long_dbl( solver, num_pre_relax );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGSetPrintLevel_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int print_level )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSMGSetPrintLevel_flt( solver, print_level );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSMGSetPrintLevel_dbl( solver, print_level );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSMGSetPrintLevel_long_dbl( solver, print_level );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGSetRelChange_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_Int rel_change )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSMGSetRelChange_flt( solver, rel_change );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSMGSetRelChange_dbl( solver, rel_change );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSMGSetRelChange_long_dbl( solver, rel_change );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGSetTol_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, hypre_long_double tol )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSMGSetTol_flt( solver, tol );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSMGSetTol_dbl( solver, tol );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSMGSetTol_long_dbl( solver, tol );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGSetZeroGuess_pre( HYPRE_Precision precision, HYPRE_StructSolver solver )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSMGSetZeroGuess_flt( solver );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSMGSetZeroGuess_dbl( solver );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSMGSetZeroGuess_long_dbl( solver );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGSetup_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSMGSetup_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSMGSetup_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSMGSetup_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSMGSolve_pre( HYPRE_Precision precision, HYPRE_StructSolver solver, HYPRE_StructMatrix A, HYPRE_StructVector b, HYPRE_StructVector x )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSMGSolve_flt( solver, A, b, x );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSMGSolve_dbl( solver, A, b, x );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSMGSolve_long_dbl( solver, A, b, x );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSetupInterpreter_pre( HYPRE_Precision precision, mv_InterfaceInterpreter *i )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSetupInterpreter_flt( i );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSetupInterpreter_dbl( i );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSetupInterpreter_long_dbl( i );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
HYPRE_StructSetupMatvec_pre( HYPRE_Precision precision, HYPRE_MatvecFunctions *mv )
{
   switch (precision)
   {
      case HYPRE_REAL_SINGLE:
         return HYPRE_StructSetupMatvec_flt( mv );
      case HYPRE_REAL_DOUBLE:
         return HYPRE_StructSetupMatvec_dbl( mv );
      case HYPRE_REAL_LONGDOUBLE:
         return HYPRE_StructSetupMatvec_long_dbl( mv );
      default:
         { HYPRE_Int value = 0; hypre_error_w_msg(HYPRE_ERROR_GENERIC, "Unknown solver precision"); return value; }
   }
}



#endif

