import os
import sys
import signal
import locale
import gettext
from gi.repository import GLib

def testgetTimeAgoSec():
    """
    Testing getTimeAgoSec()
    """
    time_ago = utils.getTimeAgoSec(30)
    assert time_ago == "Under 1 Minute"

    time_ago = utils.getTimeAgoSec(-60)
    assert time_ago == "Under 1 Minute"

    time_ago = utils.getTimeAgoSec(65)
    assert time_ago == "1 Minute"

    time_ago = utils.getTimeAgoSec(125)
    assert time_ago == "2 Minutes"

    time_ago = utils.getTimeAgoSec(60*60)
    assert time_ago == "1 Hour 0 Minutes"

    time_ago = utils.getTimeAgoSec(60*60+60)
    assert time_ago == "1 Hour 1 Minute"

    time_ago = utils.getTimeAgoSec(3*60*60+5*60+45)
    assert time_ago == "3 Hours 5 Minutes"

    time_ago = utils.getTimeAgoSec(1*24*60*60+1*60*60+57*60+12)
    assert time_ago == "1 Day 1 Hour 57 Minutes"

    time_ago = utils.getTimeAgoSec(1*24*60*60+3*60*60+57*60+12)
    assert time_ago == "1 Day 3 Hours 57 Minutes"

    time_ago = utils.getTimeAgoSec(1*24*60*60+0*60*60+57*60+12)
    assert time_ago == "1 Day 57 Minutes"

def testlinkifyMessage():
    message = utils.linkifyMessage("Test Message")
    assert message == "Test Message"

    message = utils.linkifyMessage("abc")
    assert message == "abc"

    message = utils.linkifyMessage(".abc")
    assert message == ".abc"

    message = utils.linkifyMessage("www.a.com")
    assert message == "<a href=\"http://www.a.com\">www.a.com</a>"

    message = utils.linkifyMessage("http://w")
    assert message == "http://w"

    message = utils.linkifyMessage("അത് http://www.example.com/മലയാളം ആണ്")
    assert message == "അത് <a href=\"http://www.example.com/മലയാളം\">http://www.example.com/മലയാളം</a> ആണ്"

    message = utils.linkifyMessage("www.puri.sm www.gnu.org www.fsf.org ")
    assert message == "<a href=\"http://www.puri.sm\">www.puri.sm</a> <a href=\"http://www.gnu.org\">www.gnu.org</a> <a href=\"http://www.fsf.org\">www.fsf.org</a> "

    message = utils.linkifyMessage("www.puri.sm\nwww.gnu.org")
    assert message == "<a href=\"http://www.puri.sm\">www.puri.sm</a>\n<a href=\"http://www.gnu.org\">www.gnu.org</a>"

    message = utils.linkifyMessage("Open some example website (eg: https://www.example.com)")
    assert message == "Open some example website (eg: <a href=\"https://www.example.com\">https://www.example.com</a>)"

    message = utils.linkifyMessage("https://en.wikipedia.org/wiki/Sphere_(venue) You should check this out")
    assert message == "<a href=\"https://en.wikipedia.org/wiki/Sphere_(venue)\">https://en.wikipedia.org/wiki/Sphere_(venue)</a> You should check this out"

    message = utils.linkifyMessage("https://www.google.com/maps/place/Carnegie+Mellon+University/@40.4432027,-79.9454248,17z/data=!3m1!4b1!4m6!3m5!1s0x8834f21f58679a9f:0x88716b461fc4daf4!8m2!3d40.4432027!4d-79.9428499!16zL20vMGN3eF8?entry=ttu")
    assert message == "<a href=\"https://www.google.com/maps/place/Carnegie+Mellon+University/@40.4432027,-79.9454248,17z/data=!3m1!4b1!4m6!3m5!1s0x8834f21f58679a9f:0x88716b461fc4daf4!8m2!3d40.4432027!4d-79.9428499!16zL20vMGN3eF8?entry=ttu\">https://www.google.com/maps/place/Carnegie+Mellon+University/@40.4432027,-79.9454248,17z/data=!3m1!4b1!4m6!3m5!1s0x8834f21f58679a9f:0x88716b461fc4daf4!8m2!3d40.4432027!4d-79.9428499!16zL20vMGN3eF8?entry=ttu</a>"

    message = utils.linkifyMessage("https://www.google.com/maps/place/Carnegie+Mellon+University/@40.4432027,-79.9454248,17z/data=!3m1!4b1!4m6!3m5!1s0x8834f21f58679a9f:0x88716b461fc4daf4!8m2!3d40.4432027!4d-79.9428499!16zL20vMGN3eF8?entry=ttu This is the spot")
    assert message == "<a href=\"https://www.google.com/maps/place/Carnegie+Mellon+University/@40.4432027,-79.9454248,17z/data=!3m1!4b1!4m6!3m5!1s0x8834f21f58679a9f:0x88716b461fc4daf4!8m2!3d40.4432027!4d-79.9428499!16zL20vMGN3eF8?entry=ttu\">https://www.google.com/maps/place/Carnegie+Mellon+University/@40.4432027,-79.9454248,17z/data=!3m1!4b1!4m6!3m5!1s0x8834f21f58679a9f:0x88716b461fc4daf4!8m2!3d40.4432027!4d-79.9428499!16zL20vMGN3eF8?entry=ttu</a> This is the spot"

    message = utils.linkifyMessage("https://example.com(venue hi hi hi)")
    assert message == "<a href=\"https://example.com\">https://example.com</a>(venue hi hi hi)"

if __name__ == "__main__":
    with open('../_build/test/test_support.py', 'r') as file:
        code = file.read()
        exec(code)

    testgetTimeAgoSec()

    testlinkifyMessage()
