// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/discoveryengine/v1alpha/engine.proto

package discoveryenginepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The training state of the engine.
type Engine_MediaRecommendationEngineConfig_TrainingState int32

const (
	// Unspecified training state.
	Engine_MediaRecommendationEngineConfig_TRAINING_STATE_UNSPECIFIED Engine_MediaRecommendationEngineConfig_TrainingState = 0
	// The engine training is paused.
	Engine_MediaRecommendationEngineConfig_PAUSED Engine_MediaRecommendationEngineConfig_TrainingState = 1
	// The engine is training.
	Engine_MediaRecommendationEngineConfig_TRAINING Engine_MediaRecommendationEngineConfig_TrainingState = 2
)

// Enum value maps for Engine_MediaRecommendationEngineConfig_TrainingState.
var (
	Engine_MediaRecommendationEngineConfig_TrainingState_name = map[int32]string{
		0: "TRAINING_STATE_UNSPECIFIED",
		1: "PAUSED",
		2: "TRAINING",
	}
	Engine_MediaRecommendationEngineConfig_TrainingState_value = map[string]int32{
		"TRAINING_STATE_UNSPECIFIED": 0,
		"PAUSED":                     1,
		"TRAINING":                   2,
	}
)

func (x Engine_MediaRecommendationEngineConfig_TrainingState) Enum() *Engine_MediaRecommendationEngineConfig_TrainingState {
	p := new(Engine_MediaRecommendationEngineConfig_TrainingState)
	*p = x
	return p
}

func (x Engine_MediaRecommendationEngineConfig_TrainingState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Engine_MediaRecommendationEngineConfig_TrainingState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_engine_proto_enumTypes[0].Descriptor()
}

func (Engine_MediaRecommendationEngineConfig_TrainingState) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_engine_proto_enumTypes[0]
}

func (x Engine_MediaRecommendationEngineConfig_TrainingState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Engine_MediaRecommendationEngineConfig_TrainingState.Descriptor instead.
func (Engine_MediaRecommendationEngineConfig_TrainingState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_engine_proto_rawDescGZIP(), []int{0, 2, 0}
}

// The serving state of the recommendation engine.
type Engine_RecommendationMetadata_ServingState int32

const (
	// Unspecified serving state.
	Engine_RecommendationMetadata_SERVING_STATE_UNSPECIFIED Engine_RecommendationMetadata_ServingState = 0
	// The engine is not serving.
	Engine_RecommendationMetadata_INACTIVE Engine_RecommendationMetadata_ServingState = 1
	// The engine is serving and can be queried.
	Engine_RecommendationMetadata_ACTIVE Engine_RecommendationMetadata_ServingState = 2
	// The engine is trained on tuned hyperparameters and can be
	// queried.
	Engine_RecommendationMetadata_TUNED Engine_RecommendationMetadata_ServingState = 3
)

// Enum value maps for Engine_RecommendationMetadata_ServingState.
var (
	Engine_RecommendationMetadata_ServingState_name = map[int32]string{
		0: "SERVING_STATE_UNSPECIFIED",
		1: "INACTIVE",
		2: "ACTIVE",
		3: "TUNED",
	}
	Engine_RecommendationMetadata_ServingState_value = map[string]int32{
		"SERVING_STATE_UNSPECIFIED": 0,
		"INACTIVE":                  1,
		"ACTIVE":                    2,
		"TUNED":                     3,
	}
)

func (x Engine_RecommendationMetadata_ServingState) Enum() *Engine_RecommendationMetadata_ServingState {
	p := new(Engine_RecommendationMetadata_ServingState)
	*p = x
	return p
}

func (x Engine_RecommendationMetadata_ServingState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Engine_RecommendationMetadata_ServingState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_engine_proto_enumTypes[1].Descriptor()
}

func (Engine_RecommendationMetadata_ServingState) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_engine_proto_enumTypes[1]
}

func (x Engine_RecommendationMetadata_ServingState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Engine_RecommendationMetadata_ServingState.Descriptor instead.
func (Engine_RecommendationMetadata_ServingState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_engine_proto_rawDescGZIP(), []int{0, 5, 0}
}

// Describes whether this engine have sufficient training data
// to be continuously trained.
type Engine_RecommendationMetadata_DataState int32

const (
	// Unspecified default value, should never be explicitly set.
	Engine_RecommendationMetadata_DATA_STATE_UNSPECIFIED Engine_RecommendationMetadata_DataState = 0
	// The engine has sufficient training data.
	Engine_RecommendationMetadata_DATA_OK Engine_RecommendationMetadata_DataState = 1
	// The engine does not have sufficient training data. Error
	// messages can be queried via Stackdriver.
	Engine_RecommendationMetadata_DATA_ERROR Engine_RecommendationMetadata_DataState = 2
)

// Enum value maps for Engine_RecommendationMetadata_DataState.
var (
	Engine_RecommendationMetadata_DataState_name = map[int32]string{
		0: "DATA_STATE_UNSPECIFIED",
		1: "DATA_OK",
		2: "DATA_ERROR",
	}
	Engine_RecommendationMetadata_DataState_value = map[string]int32{
		"DATA_STATE_UNSPECIFIED": 0,
		"DATA_OK":                1,
		"DATA_ERROR":             2,
	}
)

func (x Engine_RecommendationMetadata_DataState) Enum() *Engine_RecommendationMetadata_DataState {
	p := new(Engine_RecommendationMetadata_DataState)
	*p = x
	return p
}

func (x Engine_RecommendationMetadata_DataState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Engine_RecommendationMetadata_DataState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1alpha_engine_proto_enumTypes[2].Descriptor()
}

func (Engine_RecommendationMetadata_DataState) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1alpha_engine_proto_enumTypes[2]
}

func (x Engine_RecommendationMetadata_DataState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Engine_RecommendationMetadata_DataState.Descriptor instead.
func (Engine_RecommendationMetadata_DataState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_engine_proto_rawDescGZIP(), []int{0, 5, 1}
}

// Metadata that describes the training and serving parameters of an
// [Engine][google.cloud.discoveryengine.v1alpha.Engine].
type Engine struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Additional config specs that defines the behavior of the engine.
	//
	// Types that are assignable to EngineConfig:
	//
	//	*Engine_SimilarDocumentsConfig
	//	*Engine_ChatEngineConfig_
	//	*Engine_SearchEngineConfig_
	//	*Engine_MediaRecommendationEngineConfig_
	EngineConfig isEngine_EngineConfig `protobuf_oneof:"engine_config"`
	// Engine metadata to monitor the status of the engine.
	//
	// Types that are assignable to EngineMetadata:
	//
	//	*Engine_RecommendationMetadata_
	//	*Engine_ChatEngineMetadata_
	EngineMetadata isEngine_EngineMetadata `protobuf_oneof:"engine_metadata"`
	// Immutable. The fully qualified resource name of the engine.
	//
	// This field must be a UTF-8 encoded string with a length limit of 1024
	// characters.
	//
	// Format:
	// `projects/{project_number}/locations/{location}/collections/{collection}/engines/{engine}`
	// engine should be 1-63 characters, and valid characters are
	// /[a-z0-9][a-z0-9-_]*/. Otherwise, an INVALID_ARGUMENT error is returned.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the engine. Should be human readable. UTF-8
	// encoded string with limit of 1024 characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. Timestamp the Recommendation Engine was created at.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp the Recommendation Engine was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The data stores associated with this engine.
	//
	// For
	// [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1alpha.SolutionType.SOLUTION_TYPE_SEARCH]
	// and
	// [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1alpha.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
	// type of engines, they can only associate with at most one data store.
	//
	// If
	// [solution_type][google.cloud.discoveryengine.v1alpha.Engine.solution_type]
	// is
	// [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1alpha.SolutionType.SOLUTION_TYPE_CHAT],
	// multiple [DataStore][google.cloud.discoveryengine.v1alpha.DataStore]s in
	// the same [Collection][google.cloud.discoveryengine.v1alpha.Collection] can
	// be associated here.
	//
	// Note that when used in
	// [CreateEngineRequest][google.cloud.discoveryengine.v1alpha.CreateEngineRequest],
	// one DataStore id must be provided as the system will use it for necessary
	// initializations.
	DataStoreIds []string `protobuf:"bytes,5,rep,name=data_store_ids,json=dataStoreIds,proto3" json:"data_store_ids,omitempty"`
	// Required. The solutions of the engine.
	SolutionType SolutionType `protobuf:"varint,6,opt,name=solution_type,json=solutionType,proto3,enum=google.cloud.discoveryengine.v1alpha.SolutionType" json:"solution_type,omitempty"`
	// The industry vertical that the engine registers.
	// The restriction of the Engine industry vertical is based on
	// [DataStore][google.cloud.discoveryengine.v1alpha.DataStore]: If
	// unspecified, default to `GENERIC`. Vertical on Engine has to match vertical
	// of the DataStore linked to the engine.
	IndustryVertical IndustryVertical `protobuf:"varint,16,opt,name=industry_vertical,json=industryVertical,proto3,enum=google.cloud.discoveryengine.v1alpha.IndustryVertical" json:"industry_vertical,omitempty"`
	// Common config spec that specifies the metadata of the engine.
	CommonConfig *Engine_CommonConfig `protobuf:"bytes,15,opt,name=common_config,json=commonConfig,proto3" json:"common_config,omitempty"`
}

func (x *Engine) Reset() {
	*x = Engine{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Engine) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Engine) ProtoMessage() {}

func (x *Engine) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Engine.ProtoReflect.Descriptor instead.
func (*Engine) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_engine_proto_rawDescGZIP(), []int{0}
}

func (m *Engine) GetEngineConfig() isEngine_EngineConfig {
	if m != nil {
		return m.EngineConfig
	}
	return nil
}

func (x *Engine) GetSimilarDocumentsConfig() *Engine_SimilarDocumentsEngineConfig {
	if x, ok := x.GetEngineConfig().(*Engine_SimilarDocumentsConfig); ok {
		return x.SimilarDocumentsConfig
	}
	return nil
}

func (x *Engine) GetChatEngineConfig() *Engine_ChatEngineConfig {
	if x, ok := x.GetEngineConfig().(*Engine_ChatEngineConfig_); ok {
		return x.ChatEngineConfig
	}
	return nil
}

func (x *Engine) GetSearchEngineConfig() *Engine_SearchEngineConfig {
	if x, ok := x.GetEngineConfig().(*Engine_SearchEngineConfig_); ok {
		return x.SearchEngineConfig
	}
	return nil
}

func (x *Engine) GetMediaRecommendationEngineConfig() *Engine_MediaRecommendationEngineConfig {
	if x, ok := x.GetEngineConfig().(*Engine_MediaRecommendationEngineConfig_); ok {
		return x.MediaRecommendationEngineConfig
	}
	return nil
}

func (m *Engine) GetEngineMetadata() isEngine_EngineMetadata {
	if m != nil {
		return m.EngineMetadata
	}
	return nil
}

func (x *Engine) GetRecommendationMetadata() *Engine_RecommendationMetadata {
	if x, ok := x.GetEngineMetadata().(*Engine_RecommendationMetadata_); ok {
		return x.RecommendationMetadata
	}
	return nil
}

func (x *Engine) GetChatEngineMetadata() *Engine_ChatEngineMetadata {
	if x, ok := x.GetEngineMetadata().(*Engine_ChatEngineMetadata_); ok {
		return x.ChatEngineMetadata
	}
	return nil
}

func (x *Engine) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Engine) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Engine) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Engine) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Engine) GetDataStoreIds() []string {
	if x != nil {
		return x.DataStoreIds
	}
	return nil
}

func (x *Engine) GetSolutionType() SolutionType {
	if x != nil {
		return x.SolutionType
	}
	return SolutionType_SOLUTION_TYPE_UNSPECIFIED
}

func (x *Engine) GetIndustryVertical() IndustryVertical {
	if x != nil {
		return x.IndustryVertical
	}
	return IndustryVertical_INDUSTRY_VERTICAL_UNSPECIFIED
}

func (x *Engine) GetCommonConfig() *Engine_CommonConfig {
	if x != nil {
		return x.CommonConfig
	}
	return nil
}

type isEngine_EngineConfig interface {
	isEngine_EngineConfig()
}

type Engine_SimilarDocumentsConfig struct {
	// Additional config specs for a `similar-items` engine.
	SimilarDocumentsConfig *Engine_SimilarDocumentsEngineConfig `protobuf:"bytes,9,opt,name=similar_documents_config,json=similarDocumentsConfig,proto3,oneof"`
}

type Engine_ChatEngineConfig_ struct {
	// Configurations for the Chat Engine. Only applicable if
	// [solution_type][google.cloud.discoveryengine.v1alpha.Engine.solution_type]
	// is
	// [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1alpha.SolutionType.SOLUTION_TYPE_CHAT].
	ChatEngineConfig *Engine_ChatEngineConfig `protobuf:"bytes,11,opt,name=chat_engine_config,json=chatEngineConfig,proto3,oneof"`
}

type Engine_SearchEngineConfig_ struct {
	// Configurations for the Search Engine. Only applicable if
	// [solution_type][google.cloud.discoveryengine.v1alpha.Engine.solution_type]
	// is
	// [SOLUTION_TYPE_SEARCH][google.cloud.discoveryengine.v1alpha.SolutionType.SOLUTION_TYPE_SEARCH].
	SearchEngineConfig *Engine_SearchEngineConfig `protobuf:"bytes,13,opt,name=search_engine_config,json=searchEngineConfig,proto3,oneof"`
}

type Engine_MediaRecommendationEngineConfig_ struct {
	// Configurations for the Media Engine. Only applicable on the data
	// stores with
	// [solution_type][google.cloud.discoveryengine.v1alpha.Engine.solution_type]
	// [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1alpha.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
	// and
	// [IndustryVertical.MEDIA][google.cloud.discoveryengine.v1alpha.IndustryVertical.MEDIA]
	// vertical.
	MediaRecommendationEngineConfig *Engine_MediaRecommendationEngineConfig `protobuf:"bytes,14,opt,name=media_recommendation_engine_config,json=mediaRecommendationEngineConfig,proto3,oneof"`
}

func (*Engine_SimilarDocumentsConfig) isEngine_EngineConfig() {}

func (*Engine_ChatEngineConfig_) isEngine_EngineConfig() {}

func (*Engine_SearchEngineConfig_) isEngine_EngineConfig() {}

func (*Engine_MediaRecommendationEngineConfig_) isEngine_EngineConfig() {}

type isEngine_EngineMetadata interface {
	isEngine_EngineMetadata()
}

type Engine_RecommendationMetadata_ struct {
	// Output only. Additional information of a recommendation engine. Only
	// applicable if
	// [solution_type][google.cloud.discoveryengine.v1alpha.Engine.solution_type]
	// is
	// [SOLUTION_TYPE_RECOMMENDATION][google.cloud.discoveryengine.v1alpha.SolutionType.SOLUTION_TYPE_RECOMMENDATION].
	RecommendationMetadata *Engine_RecommendationMetadata `protobuf:"bytes,10,opt,name=recommendation_metadata,json=recommendationMetadata,proto3,oneof"`
}

type Engine_ChatEngineMetadata_ struct {
	// Output only. Additional information of the Chat Engine. Only applicable
	// if
	// [solution_type][google.cloud.discoveryengine.v1alpha.Engine.solution_type]
	// is
	// [SOLUTION_TYPE_CHAT][google.cloud.discoveryengine.v1alpha.SolutionType.SOLUTION_TYPE_CHAT].
	ChatEngineMetadata *Engine_ChatEngineMetadata `protobuf:"bytes,12,opt,name=chat_engine_metadata,json=chatEngineMetadata,proto3,oneof"`
}

func (*Engine_RecommendationMetadata_) isEngine_EngineMetadata() {}

func (*Engine_ChatEngineMetadata_) isEngine_EngineMetadata() {}

// Configurations for a Search Engine.
type Engine_SearchEngineConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The search feature tier of this engine.
	//
	// Different tiers might have different
	// pricing. To learn more, check the pricing documentation.
	//
	// Defaults to
	// [SearchTier.SEARCH_TIER_STANDARD][google.cloud.discoveryengine.v1alpha.SearchTier.SEARCH_TIER_STANDARD]
	// if not specified.
	SearchTier SearchTier `protobuf:"varint,1,opt,name=search_tier,json=searchTier,proto3,enum=google.cloud.discoveryengine.v1alpha.SearchTier" json:"search_tier,omitempty"`
	// The add-on that this search engine enables.
	SearchAddOns []SearchAddOn `protobuf:"varint,2,rep,packed,name=search_add_ons,json=searchAddOns,proto3,enum=google.cloud.discoveryengine.v1alpha.SearchAddOn" json:"search_add_ons,omitempty"`
}

func (x *Engine_SearchEngineConfig) Reset() {
	*x = Engine_SearchEngineConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Engine_SearchEngineConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Engine_SearchEngineConfig) ProtoMessage() {}

func (x *Engine_SearchEngineConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Engine_SearchEngineConfig.ProtoReflect.Descriptor instead.
func (*Engine_SearchEngineConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_engine_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Engine_SearchEngineConfig) GetSearchTier() SearchTier {
	if x != nil {
		return x.SearchTier
	}
	return SearchTier_SEARCH_TIER_UNSPECIFIED
}

func (x *Engine_SearchEngineConfig) GetSearchAddOns() []SearchAddOn {
	if x != nil {
		return x.SearchAddOns
	}
	return nil
}

// Additional config specs for a `similar-items` engine.
type Engine_SimilarDocumentsEngineConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Engine_SimilarDocumentsEngineConfig) Reset() {
	*x = Engine_SimilarDocumentsEngineConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Engine_SimilarDocumentsEngineConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Engine_SimilarDocumentsEngineConfig) ProtoMessage() {}

func (x *Engine_SimilarDocumentsEngineConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Engine_SimilarDocumentsEngineConfig.ProtoReflect.Descriptor instead.
func (*Engine_SimilarDocumentsEngineConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_engine_proto_rawDescGZIP(), []int{0, 1}
}

// Additional config specs for a Media Recommendation engine.
type Engine_MediaRecommendationEngineConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The type of engine. e.g., `recommended-for-you`.
	//
	// This field together with
	// [optimization_objective][Engine.optimization_objective] describe engine
	// metadata to use to control engine training and serving.
	//
	// Currently supported values: `recommended-for-you`, `others-you-may-like`,
	// `more-like-this`, `most-popular-items`.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// The optimization objective. e.g., `cvr`.
	//
	// This field together with
	// [optimization_objective][google.cloud.discoveryengine.v1alpha.Engine.MediaRecommendationEngineConfig.type]
	// describe engine metadata to use to control engine training and serving.
	//
	// Currently supported
	// values: `ctr`, `cvr`.
	//
	//	If not specified, we choose default based on engine type.
	//
	// Default depends on type of recommendation:
	//
	// `recommended-for-you` => `ctr`
	//
	// `others-you-may-like` => `ctr`
	OptimizationObjective string `protobuf:"bytes,2,opt,name=optimization_objective,json=optimizationObjective,proto3" json:"optimization_objective,omitempty"`
	// Name and value of the custom threshold for cvr optimization_objective.
	// For target_field `watch-time`, target_field_value must be an integer
	// value indicating the media progress time in seconds between (0, 86400]
	// (excludes 0, includes 86400) (e.g., 90).
	// For target_field `watch-percentage`, the target_field_value must be a
	// valid float value between (0, 1.0] (excludes 0, includes 1.0) (e.g.,
	// 0.5).
	OptimizationObjectiveConfig *Engine_MediaRecommendationEngineConfig_OptimizationObjectiveConfig `protobuf:"bytes,3,opt,name=optimization_objective_config,json=optimizationObjectiveConfig,proto3" json:"optimization_objective_config,omitempty"`
	// The training state that the engine is in (e.g.
	// `TRAINING` or `PAUSED`).
	//
	// Since part of the cost of running the service
	// is frequency of training - this can be used to determine when to train
	// engine in order to control cost. If not specified: the default value for
	// `CreateEngine` method is `TRAINING`. The default value for
	// `UpdateEngine` method is to keep the state the same as before.
	TrainingState Engine_MediaRecommendationEngineConfig_TrainingState `protobuf:"varint,4,opt,name=training_state,json=trainingState,proto3,enum=google.cloud.discoveryengine.v1alpha.Engine_MediaRecommendationEngineConfig_TrainingState" json:"training_state,omitempty"`
}

func (x *Engine_MediaRecommendationEngineConfig) Reset() {
	*x = Engine_MediaRecommendationEngineConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Engine_MediaRecommendationEngineConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Engine_MediaRecommendationEngineConfig) ProtoMessage() {}

func (x *Engine_MediaRecommendationEngineConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Engine_MediaRecommendationEngineConfig.ProtoReflect.Descriptor instead.
func (*Engine_MediaRecommendationEngineConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_engine_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Engine_MediaRecommendationEngineConfig) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Engine_MediaRecommendationEngineConfig) GetOptimizationObjective() string {
	if x != nil {
		return x.OptimizationObjective
	}
	return ""
}

func (x *Engine_MediaRecommendationEngineConfig) GetOptimizationObjectiveConfig() *Engine_MediaRecommendationEngineConfig_OptimizationObjectiveConfig {
	if x != nil {
		return x.OptimizationObjectiveConfig
	}
	return nil
}

func (x *Engine_MediaRecommendationEngineConfig) GetTrainingState() Engine_MediaRecommendationEngineConfig_TrainingState {
	if x != nil {
		return x.TrainingState
	}
	return Engine_MediaRecommendationEngineConfig_TRAINING_STATE_UNSPECIFIED
}

// Configurations for a Chat Engine.
type Engine_ChatEngineConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The configurationt generate the Dialogflow agent that is associated to
	// this Engine.
	//
	// Note that these configurations are one-time consumed by
	// and passed to Dialogflow service. It means they cannot be retrieved using
	// [EngineService.GetEngine][google.cloud.discoveryengine.v1alpha.EngineService.GetEngine]
	// or
	// [EngineService.ListEngines][google.cloud.discoveryengine.v1alpha.EngineService.ListEngines]
	// API after engine creation.
	AgentCreationConfig *Engine_ChatEngineConfig_AgentCreationConfig `protobuf:"bytes,1,opt,name=agent_creation_config,json=agentCreationConfig,proto3" json:"agent_creation_config,omitempty"`
	// The resource name of an exist Dialogflow agent to link to this Chat
	// Engine. Customers can either provide `agent_creation_config` to create
	// agent or provide an agent name that links the agent with the Chat engine.
	//
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>`.
	//
	// Note that the `dialogflow_agent_to_link` are one-time consumed by and
	// passed to Dialogflow service. It means they cannot be retrieved using
	// [EngineService.GetEngine][google.cloud.discoveryengine.v1alpha.EngineService.GetEngine]
	// or
	// [EngineService.ListEngines][google.cloud.discoveryengine.v1alpha.EngineService.ListEngines]
	// API after engine creation. Use
	// [ChatEngineMetadata.dialogflow_agent][google.cloud.discoveryengine.v1alpha.Engine.ChatEngineMetadata.dialogflow_agent]
	// for actual agent association after Engine is created.
	DialogflowAgentToLink string `protobuf:"bytes,2,opt,name=dialogflow_agent_to_link,json=dialogflowAgentToLink,proto3" json:"dialogflow_agent_to_link,omitempty"`
}

func (x *Engine_ChatEngineConfig) Reset() {
	*x = Engine_ChatEngineConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Engine_ChatEngineConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Engine_ChatEngineConfig) ProtoMessage() {}

func (x *Engine_ChatEngineConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Engine_ChatEngineConfig.ProtoReflect.Descriptor instead.
func (*Engine_ChatEngineConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_engine_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Engine_ChatEngineConfig) GetAgentCreationConfig() *Engine_ChatEngineConfig_AgentCreationConfig {
	if x != nil {
		return x.AgentCreationConfig
	}
	return nil
}

func (x *Engine_ChatEngineConfig) GetDialogflowAgentToLink() string {
	if x != nil {
		return x.DialogflowAgentToLink
	}
	return ""
}

// Common configurations for an Engine.
type Engine_CommonConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the company, business or entity that is associated with the
	// engine. Setting this may help improve LLM related features.
	CompanyName string `protobuf:"bytes,1,opt,name=company_name,json=companyName,proto3" json:"company_name,omitempty"`
}

func (x *Engine_CommonConfig) Reset() {
	*x = Engine_CommonConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Engine_CommonConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Engine_CommonConfig) ProtoMessage() {}

func (x *Engine_CommonConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Engine_CommonConfig.ProtoReflect.Descriptor instead.
func (*Engine_CommonConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_engine_proto_rawDescGZIP(), []int{0, 4}
}

func (x *Engine_CommonConfig) GetCompanyName() string {
	if x != nil {
		return x.CompanyName
	}
	return ""
}

// Additional information of a recommendation engine.
type Engine_RecommendationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The serving state of the engine: `ACTIVE`, `NOT_ACTIVE`.
	ServingState Engine_RecommendationMetadata_ServingState `protobuf:"varint,1,opt,name=serving_state,json=servingState,proto3,enum=google.cloud.discoveryengine.v1alpha.Engine_RecommendationMetadata_ServingState" json:"serving_state,omitempty"`
	// Output only. The state of data requirements for this engine: `DATA_OK`
	// and `DATA_ERROR`.
	//
	// Engine cannot be trained if the data is in
	// `DATA_ERROR` state. Engine can have `DATA_ERROR` state even
	// if serving state is `ACTIVE`: engines were trained successfully before,
	// but cannot be refreshed because the underlying engine no longer has
	// sufficient data for training.
	DataState Engine_RecommendationMetadata_DataState `protobuf:"varint,2,opt,name=data_state,json=dataState,proto3,enum=google.cloud.discoveryengine.v1alpha.Engine_RecommendationMetadata_DataState" json:"data_state,omitempty"`
	// Output only. The timestamp when the latest successful tune finished. Only
	// applicable on Media Recommendation engines.
	LastTuneTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=last_tune_time,json=lastTuneTime,proto3" json:"last_tune_time,omitempty"`
	// Output only. The latest tune operation id associated with the engine.
	// Only applicable on Media Recommendation engines.
	//
	// If present, this operation id can be used to determine if there is an
	// ongoing tune for this engine. To check the operation status, send the
	// GetOperation request with this operation id in the engine resource
	// format. If no tuning has happened for this engine, the string is empty.
	TuningOperation string `protobuf:"bytes,4,opt,name=tuning_operation,json=tuningOperation,proto3" json:"tuning_operation,omitempty"`
}

func (x *Engine_RecommendationMetadata) Reset() {
	*x = Engine_RecommendationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Engine_RecommendationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Engine_RecommendationMetadata) ProtoMessage() {}

func (x *Engine_RecommendationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Engine_RecommendationMetadata.ProtoReflect.Descriptor instead.
func (*Engine_RecommendationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_engine_proto_rawDescGZIP(), []int{0, 5}
}

func (x *Engine_RecommendationMetadata) GetServingState() Engine_RecommendationMetadata_ServingState {
	if x != nil {
		return x.ServingState
	}
	return Engine_RecommendationMetadata_SERVING_STATE_UNSPECIFIED
}

func (x *Engine_RecommendationMetadata) GetDataState() Engine_RecommendationMetadata_DataState {
	if x != nil {
		return x.DataState
	}
	return Engine_RecommendationMetadata_DATA_STATE_UNSPECIFIED
}

func (x *Engine_RecommendationMetadata) GetLastTuneTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastTuneTime
	}
	return nil
}

func (x *Engine_RecommendationMetadata) GetTuningOperation() string {
	if x != nil {
		return x.TuningOperation
	}
	return ""
}

// Additional information of a Chat Engine.
// Fields in this message are output only.
type Engine_ChatEngineMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of a Dialogflow agent, that this Chat Engine refers
	// to.
	//
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>`.
	DialogflowAgent string `protobuf:"bytes,1,opt,name=dialogflow_agent,json=dialogflowAgent,proto3" json:"dialogflow_agent,omitempty"`
}

func (x *Engine_ChatEngineMetadata) Reset() {
	*x = Engine_ChatEngineMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Engine_ChatEngineMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Engine_ChatEngineMetadata) ProtoMessage() {}

func (x *Engine_ChatEngineMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Engine_ChatEngineMetadata.ProtoReflect.Descriptor instead.
func (*Engine_ChatEngineMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_engine_proto_rawDescGZIP(), []int{0, 6}
}

func (x *Engine_ChatEngineMetadata) GetDialogflowAgent() string {
	if x != nil {
		return x.DialogflowAgent
	}
	return ""
}

// Custom threshold for `cvr` optimization_objective.
type Engine_MediaRecommendationEngineConfig_OptimizationObjectiveConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the field to target. Currently supported
	// values: `watch-percentage`, `watch-time`.
	TargetField string `protobuf:"bytes,1,opt,name=target_field,json=targetField,proto3" json:"target_field,omitempty"`
	// Required. The threshold to be applied to the target (e.g., 0.5).
	TargetFieldValueFloat float32 `protobuf:"fixed32,2,opt,name=target_field_value_float,json=targetFieldValueFloat,proto3" json:"target_field_value_float,omitempty"`
}

func (x *Engine_MediaRecommendationEngineConfig_OptimizationObjectiveConfig) Reset() {
	*x = Engine_MediaRecommendationEngineConfig_OptimizationObjectiveConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Engine_MediaRecommendationEngineConfig_OptimizationObjectiveConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Engine_MediaRecommendationEngineConfig_OptimizationObjectiveConfig) ProtoMessage() {}

func (x *Engine_MediaRecommendationEngineConfig_OptimizationObjectiveConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Engine_MediaRecommendationEngineConfig_OptimizationObjectiveConfig.ProtoReflect.Descriptor instead.
func (*Engine_MediaRecommendationEngineConfig_OptimizationObjectiveConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_engine_proto_rawDescGZIP(), []int{0, 2, 0}
}

func (x *Engine_MediaRecommendationEngineConfig_OptimizationObjectiveConfig) GetTargetField() string {
	if x != nil {
		return x.TargetField
	}
	return ""
}

func (x *Engine_MediaRecommendationEngineConfig_OptimizationObjectiveConfig) GetTargetFieldValueFloat() float32 {
	if x != nil {
		return x.TargetFieldValueFloat
	}
	return 0
}

// Configurations for generating a Dialogflow agent.
//
// Note that these configurations are one-time consumed by
// and passed to Dialogflow service. It means they cannot be retrieved using
// [EngineService.GetEngine][google.cloud.discoveryengine.v1alpha.EngineService.GetEngine]
// or
// [EngineService.ListEngines][google.cloud.discoveryengine.v1alpha.EngineService.ListEngines]
// API after engine creation.
type Engine_ChatEngineConfig_AgentCreationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the company, organization or other entity that the agent
	// represents. Used for knowledge connector LLM prompt and for knowledge
	// search.
	Business string `protobuf:"bytes,1,opt,name=business,proto3" json:"business,omitempty"`
	// Required. The default language of the agent as a language tag.
	// See [Language
	// Support](https://cloud.google.com/dialogflow/docs/reference/language)
	// for a list of the currently supported language codes.
	DefaultLanguageCode string `protobuf:"bytes,2,opt,name=default_language_code,json=defaultLanguageCode,proto3" json:"default_language_code,omitempty"`
	// Required. The time zone of the agent from the [time zone
	// database](https://www.iana.org/time-zones), e.g., America/New_York,
	// Europe/Paris.
	TimeZone string `protobuf:"bytes,3,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// Agent location for Agent creation, supported values: global/us/eu.
	// If not provided, us Engine will create Agent using us-central-1 by
	// default; eu Engine will create Agent using eu-west-1 by default.
	Location string `protobuf:"bytes,4,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *Engine_ChatEngineConfig_AgentCreationConfig) Reset() {
	*x = Engine_ChatEngineConfig_AgentCreationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Engine_ChatEngineConfig_AgentCreationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Engine_ChatEngineConfig_AgentCreationConfig) ProtoMessage() {}

func (x *Engine_ChatEngineConfig_AgentCreationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Engine_ChatEngineConfig_AgentCreationConfig.ProtoReflect.Descriptor instead.
func (*Engine_ChatEngineConfig_AgentCreationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1alpha_engine_proto_rawDescGZIP(), []int{0, 3, 0}
}

func (x *Engine_ChatEngineConfig_AgentCreationConfig) GetBusiness() string {
	if x != nil {
		return x.Business
	}
	return ""
}

func (x *Engine_ChatEngineConfig_AgentCreationConfig) GetDefaultLanguageCode() string {
	if x != nil {
		return x.DefaultLanguageCode
	}
	return ""
}

func (x *Engine_ChatEngineConfig_AgentCreationConfig) GetTimeZone() string {
	if x != nil {
		return x.TimeZone
	}
	return ""
}

func (x *Engine_ChatEngineConfig_AgentCreationConfig) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

var File_google_cloud_discoveryengine_v1alpha_engine_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1alpha_engine_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa9, 0x1a, 0x0a, 0x06, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x12, 0x85, 0x01, 0x0a, 0x18, 0x73, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72,
	0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x53, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x48, 0x00, 0x52, 0x16, 0x73, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6d, 0x0a, 0x12,
	0x63, 0x68, 0x61, 0x74, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x43, 0x68, 0x61, 0x74, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x10, 0x63, 0x68, 0x61, 0x74, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x73, 0x0a, 0x14, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x12, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x9b, 0x01, 0x0a, 0x22, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x4d, 0x65, 0x64, 0x69,
	0x61, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x1f, 0x6d,
	0x65, 0x64, 0x69, 0x61, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x83,
	0x01, 0x0a, 0x17, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x52,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x16, 0x72, 0x65,
	0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x78, 0x0a, 0x14, 0x63, 0x68, 0x61, 0x74, 0x5f, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x43, 0x68, 0x61, 0x74, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x12, 0x63, 0x68, 0x61, 0x74,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x61, 0x74,
	0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x64, 0x73, 0x12, 0x5c, 0x0a, 0x0d, 0x73, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x73, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x63, 0x0a, 0x11, 0x69, 0x6e, 0x64, 0x75, 0x73,
	0x74, 0x72, 0x79, 0x5f, 0x76, 0x65, 0x72, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x49, 0x6e, 0x64, 0x75, 0x73, 0x74,
	0x72, 0x79, 0x56, 0x65, 0x72, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x52, 0x10, 0x69, 0x6e, 0x64, 0x75,
	0x73, 0x74, 0x72, 0x79, 0x56, 0x65, 0x72, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x12, 0x5e, 0x0a, 0x0d,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0f, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0xc0, 0x01, 0x0a,
	0x12, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x51, 0x0a, 0x0b, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x74, 0x69,
	0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x69, 0x65, 0x72, 0x52, 0x0a, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x54, 0x69, 0x65, 0x72, 0x12, 0x57, 0x0a, 0x0e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x5f, 0x61, 0x64, 0x64, 0x5f, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x64, 0x4f,
	0x6e, 0x52, 0x0c, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x64, 0x64, 0x4f, 0x6e, 0x73, 0x1a,
	0x1e, 0x0a, 0x1c, 0x53, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a,
	0xf5, 0x04, 0x0a, 0x1f, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65,
	0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x35, 0x0a, 0x16,
	0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x6f, 0x70,
	0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x12, 0xac, 0x01, 0x0a, 0x1d, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x68, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x52,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x1b, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x81, 0x01, 0x0a, 0x0e, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x52,
	0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69,
	0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0d, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e,
	0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x1a, 0x83, 0x01, 0x0a, 0x1b, 0x4f, 0x70, 0x74, 0x69, 0x6d,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x26, 0x0a, 0x0c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x3c,
	0x0a, 0x18, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x5f, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x22, 0x49, 0x0a, 0x0d,
	0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1e, 0x0a,
	0x1a, 0x54, 0x52, 0x41, 0x49, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a,
	0x06, 0x50, 0x41, 0x55, 0x53, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x54, 0x52, 0x41,
	0x49, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x1a, 0xf9, 0x02, 0x0a, 0x10, 0x43, 0x68, 0x61, 0x74,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x85, 0x01, 0x0a,
	0x15, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x43, 0x68, 0x61, 0x74, 0x45,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x13, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x37, 0x0a, 0x18, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x6f, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x54, 0x6f, 0x4c, 0x69, 0x6e, 0x6b, 0x1a, 0xa3, 0x01,
	0x0a, 0x13, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1a, 0x0a, 0x08, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73,
	0x73, 0x12, 0x32, 0x0a, 0x15, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x13, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x7a, 0x6f,
	0x6e, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x74,
	0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x1a, 0x31, 0x0a, 0x0c, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x6f, 0x6d, 0x70, 0x61,
	0x6e, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x98, 0x04, 0x0a, 0x16, 0x52, 0x65, 0x63, 0x6f, 0x6d,
	0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x7a, 0x0a, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x71, 0x0a,
	0x0a, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x52, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x45, 0x0a, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x74, 0x75, 0x6e, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x6c, 0x61, 0x73, 0x74, 0x54,
	0x75, 0x6e, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x10, 0x74, 0x75, 0x6e, 0x69, 0x6e,
	0x67, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x52, 0x0a, 0x0c, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x45, 0x52, 0x56, 0x49,
	0x4e, 0x47, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x4e, 0x41, 0x43, 0x54, 0x49,
	0x56, 0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02,
	0x12, 0x09, 0x0a, 0x05, 0x54, 0x55, 0x4e, 0x45, 0x44, 0x10, 0x03, 0x22, 0x44, 0x0a, 0x09, 0x44,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x44, 0x41, 0x54, 0x41,
	0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x4f, 0x4b, 0x10,
	0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10,
	0x02, 0x1a, 0x3f, 0x0a, 0x12, 0x43, 0x68, 0x61, 0x74, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x3a, 0x7d, 0xea, 0x41, 0x7a, 0x0a, 0x25, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x51,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x7d, 0x42, 0x0f, 0x0a, 0x0d, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x11, 0x0a, 0x0f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x97, 0x02, 0x0a, 0x28, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x42, 0x0b, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x52, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x70, 0x62, 0xa2, 0x02, 0x0f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52,
	0x59, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0xaa, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x56, 0x31, 0x41, 0x6c, 0x70, 0x68, 0x61, 0xca, 0x02,
	0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5c, 0x56, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0xea, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_discoveryengine_v1alpha_engine_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1alpha_engine_proto_rawDescData = file_google_cloud_discoveryengine_v1alpha_engine_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1alpha_engine_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1alpha_engine_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1alpha_engine_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1alpha_engine_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1alpha_engine_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1alpha_engine_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_discoveryengine_v1alpha_engine_proto_goTypes = []interface{}{
	(Engine_MediaRecommendationEngineConfig_TrainingState)(0), // 0: google.cloud.discoveryengine.v1alpha.Engine.MediaRecommendationEngineConfig.TrainingState
	(Engine_RecommendationMetadata_ServingState)(0),           // 1: google.cloud.discoveryengine.v1alpha.Engine.RecommendationMetadata.ServingState
	(Engine_RecommendationMetadata_DataState)(0),              // 2: google.cloud.discoveryengine.v1alpha.Engine.RecommendationMetadata.DataState
	(*Engine)(nil),                                                             // 3: google.cloud.discoveryengine.v1alpha.Engine
	(*Engine_SearchEngineConfig)(nil),                                          // 4: google.cloud.discoveryengine.v1alpha.Engine.SearchEngineConfig
	(*Engine_SimilarDocumentsEngineConfig)(nil),                                // 5: google.cloud.discoveryengine.v1alpha.Engine.SimilarDocumentsEngineConfig
	(*Engine_MediaRecommendationEngineConfig)(nil),                             // 6: google.cloud.discoveryengine.v1alpha.Engine.MediaRecommendationEngineConfig
	(*Engine_ChatEngineConfig)(nil),                                            // 7: google.cloud.discoveryengine.v1alpha.Engine.ChatEngineConfig
	(*Engine_CommonConfig)(nil),                                                // 8: google.cloud.discoveryengine.v1alpha.Engine.CommonConfig
	(*Engine_RecommendationMetadata)(nil),                                      // 9: google.cloud.discoveryengine.v1alpha.Engine.RecommendationMetadata
	(*Engine_ChatEngineMetadata)(nil),                                          // 10: google.cloud.discoveryengine.v1alpha.Engine.ChatEngineMetadata
	(*Engine_MediaRecommendationEngineConfig_OptimizationObjectiveConfig)(nil), // 11: google.cloud.discoveryengine.v1alpha.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig
	(*Engine_ChatEngineConfig_AgentCreationConfig)(nil),                        // 12: google.cloud.discoveryengine.v1alpha.Engine.ChatEngineConfig.AgentCreationConfig
	(*timestamppb.Timestamp)(nil),                                              // 13: google.protobuf.Timestamp
	(SolutionType)(0),                                                          // 14: google.cloud.discoveryengine.v1alpha.SolutionType
	(IndustryVertical)(0),                                                      // 15: google.cloud.discoveryengine.v1alpha.IndustryVertical
	(SearchTier)(0),                                                            // 16: google.cloud.discoveryengine.v1alpha.SearchTier
	(SearchAddOn)(0),                                                           // 17: google.cloud.discoveryengine.v1alpha.SearchAddOn
}
var file_google_cloud_discoveryengine_v1alpha_engine_proto_depIdxs = []int32{
	5,  // 0: google.cloud.discoveryengine.v1alpha.Engine.similar_documents_config:type_name -> google.cloud.discoveryengine.v1alpha.Engine.SimilarDocumentsEngineConfig
	7,  // 1: google.cloud.discoveryengine.v1alpha.Engine.chat_engine_config:type_name -> google.cloud.discoveryengine.v1alpha.Engine.ChatEngineConfig
	4,  // 2: google.cloud.discoveryengine.v1alpha.Engine.search_engine_config:type_name -> google.cloud.discoveryengine.v1alpha.Engine.SearchEngineConfig
	6,  // 3: google.cloud.discoveryengine.v1alpha.Engine.media_recommendation_engine_config:type_name -> google.cloud.discoveryengine.v1alpha.Engine.MediaRecommendationEngineConfig
	9,  // 4: google.cloud.discoveryengine.v1alpha.Engine.recommendation_metadata:type_name -> google.cloud.discoveryengine.v1alpha.Engine.RecommendationMetadata
	10, // 5: google.cloud.discoveryengine.v1alpha.Engine.chat_engine_metadata:type_name -> google.cloud.discoveryengine.v1alpha.Engine.ChatEngineMetadata
	13, // 6: google.cloud.discoveryengine.v1alpha.Engine.create_time:type_name -> google.protobuf.Timestamp
	13, // 7: google.cloud.discoveryengine.v1alpha.Engine.update_time:type_name -> google.protobuf.Timestamp
	14, // 8: google.cloud.discoveryengine.v1alpha.Engine.solution_type:type_name -> google.cloud.discoveryengine.v1alpha.SolutionType
	15, // 9: google.cloud.discoveryengine.v1alpha.Engine.industry_vertical:type_name -> google.cloud.discoveryengine.v1alpha.IndustryVertical
	8,  // 10: google.cloud.discoveryengine.v1alpha.Engine.common_config:type_name -> google.cloud.discoveryengine.v1alpha.Engine.CommonConfig
	16, // 11: google.cloud.discoveryengine.v1alpha.Engine.SearchEngineConfig.search_tier:type_name -> google.cloud.discoveryengine.v1alpha.SearchTier
	17, // 12: google.cloud.discoveryengine.v1alpha.Engine.SearchEngineConfig.search_add_ons:type_name -> google.cloud.discoveryengine.v1alpha.SearchAddOn
	11, // 13: google.cloud.discoveryengine.v1alpha.Engine.MediaRecommendationEngineConfig.optimization_objective_config:type_name -> google.cloud.discoveryengine.v1alpha.Engine.MediaRecommendationEngineConfig.OptimizationObjectiveConfig
	0,  // 14: google.cloud.discoveryengine.v1alpha.Engine.MediaRecommendationEngineConfig.training_state:type_name -> google.cloud.discoveryengine.v1alpha.Engine.MediaRecommendationEngineConfig.TrainingState
	12, // 15: google.cloud.discoveryengine.v1alpha.Engine.ChatEngineConfig.agent_creation_config:type_name -> google.cloud.discoveryengine.v1alpha.Engine.ChatEngineConfig.AgentCreationConfig
	1,  // 16: google.cloud.discoveryengine.v1alpha.Engine.RecommendationMetadata.serving_state:type_name -> google.cloud.discoveryengine.v1alpha.Engine.RecommendationMetadata.ServingState
	2,  // 17: google.cloud.discoveryengine.v1alpha.Engine.RecommendationMetadata.data_state:type_name -> google.cloud.discoveryengine.v1alpha.Engine.RecommendationMetadata.DataState
	13, // 18: google.cloud.discoveryengine.v1alpha.Engine.RecommendationMetadata.last_tune_time:type_name -> google.protobuf.Timestamp
	19, // [19:19] is the sub-list for method output_type
	19, // [19:19] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1alpha_engine_proto_init() }
func file_google_cloud_discoveryengine_v1alpha_engine_proto_init() {
	if File_google_cloud_discoveryengine_v1alpha_engine_proto != nil {
		return
	}
	file_google_cloud_discoveryengine_v1alpha_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Engine); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Engine_SearchEngineConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Engine_SimilarDocumentsEngineConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Engine_MediaRecommendationEngineConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Engine_ChatEngineConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Engine_CommonConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Engine_RecommendationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Engine_ChatEngineMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Engine_MediaRecommendationEngineConfig_OptimizationObjectiveConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Engine_ChatEngineConfig_AgentCreationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Engine_SimilarDocumentsConfig)(nil),
		(*Engine_ChatEngineConfig_)(nil),
		(*Engine_SearchEngineConfig_)(nil),
		(*Engine_MediaRecommendationEngineConfig_)(nil),
		(*Engine_RecommendationMetadata_)(nil),
		(*Engine_ChatEngineMetadata_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1alpha_engine_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1alpha_engine_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1alpha_engine_proto_depIdxs,
		EnumInfos:         file_google_cloud_discoveryengine_v1alpha_engine_proto_enumTypes,
		MessageInfos:      file_google_cloud_discoveryengine_v1alpha_engine_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1alpha_engine_proto = out.File
	file_google_cloud_discoveryengine_v1alpha_engine_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1alpha_engine_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1alpha_engine_proto_depIdxs = nil
}
