---
date: 2026-02-19
section: 1
title: GO-FIX
header: Go programming tools and commands
footer: Go 1.26
---

# NAME

go-fix - update packages to use new APIs

# SYNOPSIS

**go fix** \[*build flags*\] \[**-fixtool** *prog*\] \[*fix flags*\]
\[*packages*\]

# DESCRIPTION

Fix runs the Go fix tool (cmd/fix) on the named packages and applies
suggested fixes.

# OPTIONS

It supports these flags:

**-diff**

: instead of applying each fix, print the patch as a unified diff

The **-fixtool**=*prog* flag selects a different analysis tool with
alternative or additional fixers; see the documentation for go vet's
**-vettool** flag for details.

The default fix tool is 'go tool fix' or cmd/fix. For help on its
fixers and their flags, run 'go tool fix help'. For details of a
specific fixer such as 'hostport', see 'go tool fix help hostport'.

For more about specifying packages, see 'go help packages'.

The build flags supported by go fix are those that control package
resolution and execution, such as **-C**, **-n**, **-x**, **-v**,
**-tags**, and **-toolexec**. For more about these flags, see 'go help
build'.

# SEE ALSO

**go fmt**(1), **go vet**(1).

# AUTHOR

This manual page was created using help2man and afterwards updating the
output. It is maintained by the Debian Go Compiler Team
\<team+go-compiler@tracker.debian.org\> for the Debian project (and may
be used by others).
