import { Arbitrator, BuildStatus, Dependency, PreBuildResult, PreBuildStatus, Progress } from "./interface";
type BoundRecipe<T> = () => Promise<T>;
export default class ProgressImpl<T> implements Progress<T> {
    readonly id: string;
    isUser: boolean;
    lastResult: undefined | T;
    result: undefined | T;
    status: BuildStatus;
    preBuildStatus: PreBuildStatus;
    preBuildResult: PreBuildResult;
    dependencies: Dependency[][];
    volatile: boolean;
    revision: number;
    private _lastError;
    private listeners;
    private errorListeners;
    private modifiedListeners;
    constructor(id: string);
    resetBuildStatus(): void;
    start(arb: Arbitrator, fn: BoundRecipe<T>): Promise<any>;
    halt(arb: Arbitrator): Promise<void>;
    unhalt(arb: Arbitrator): Promise<void>;
    private finish;
    private error;
    finishPromise(): Promise<any>;
    startModifiedCheck(fn: () => Promise<PreBuildResult>): Promise<PreBuildResult>;
    finishModifiedCheck(_yes: PreBuildResult): Promise<void>;
    modifiedCheckFinishPromise(): Promise<PreBuildResult>;
    toJson(): any;
    fromJson(j: any): void;
}
export {};
