export interface IRootSink {
    degenerated(): void;
    addRoot(x: number): boolean;
}
export declare function solveQuadratic(a: number, b: number, c: number, sink: IRootSink): void;
export declare function solveCubic(a: number, b: number, c: number, d: number, sink: IRootSink): void;
export declare function bezierSolveCubic(v0: number, v1: number, v2: number, v3: number, val: number, sink: IRootSink): void;
export declare class ClampedRootSink implements IRootSink {
    private readonly min;
    private readonly max;
    private readonly fInclusive;
    constructor(min: number, max: number, fInclusive: boolean);
    readonly roots: number[];
    rootCount: number;
    addRoot(x: number): boolean;
    degenerated(): void;
}
