const expect = require('unexpected');
const cldr = require('../lib/cldr');

describe('extractVariantDisplayNames', () => {
  it('should extract the American English variants correctly, even when the locale id is specified unnormalized', () => {
    expect(cldr.extractVariantDisplayNames('en-us'), 'to satisfy', {
      1901: 'Traditional German orthography',
      1994: 'Standardized Resian orthography',
      1996: 'German orthography of 1996',
      '1606NICT': 'Late Middle French to 1606',
      '1694ACAD': 'Early Modern French',
      '1959ACAD': 'Academic',
      ABL1943: 'Orthographic formulation of 1943',
      ALALC97: 'ALA-LC Romanization, 1997 edition',
      ALUKU: 'Aluku dialect',
      AO1990: 'Portuguese Language Orthographic Agreement of 1990',
      AREVELA: 'Eastern Armenian',
      AREVMDA: 'Western Armenian',
      BAKU1926: 'Unified Turkic Latin Alphabet',
      BALANKA: 'Balanka dialect of Anii',
      BARLA: 'Barlavento dialect group of Kabuverdianu',
      BISKE: 'San Giorgio/Bila dialect',
      BOHORIC: 'Bohorič alphabet',
      BOONT: 'Boontling',
      COLB1945: 'Portuguese-Brazilian Orthographic Convention of 1945',
      DAJNKO: 'Dajnko alphabet',
      EKAVSK: 'Serbian with Ekavian pronunciation',
      EMODENG: 'Early Modern English',
      FONIPA: 'IPA Phonetics',
      FONUPA: 'UPA Phonetics',
      HEPBURN: 'Hepburn romanization',
      IJEKAVSK: 'Serbian with Ijekavian pronunciation',
      KKCOR: 'Common Orthography',
      KSCOR: 'Standard Orthography',
      LIPAW: 'The Lipovaz dialect of Resian',
      METELKO: 'Metelko alphabet',
      MONOTON: 'Monotonic',
      NDYUKA: 'Ndyuka dialect',
      NEDIS: 'Natisone dialect',
      NJIVA: 'Gniva/Njiva dialect',
      NULIK: 'Modern Volapük',
      OSOJS: 'Oseacco/Osojane dialect',
      OXENDICT: 'Oxford English Dictionary spelling',
      PAMAKA: 'Pamaka dialect',
      PINYIN: 'Pinyin Romanization',
      POLYTON: 'Polytonic',
      POSIX: 'Computer',
      REVISED: 'Revised Orthography',
      RIGIK: 'Classic Volapük',
      ROZAJ: 'Resian',
      SAAHO: 'Saho',
      SCOTLAND: 'Scottish Standard English',
      SCOUSE: 'Scouse',
      SOLBA: 'Stolvizza/Solbica dialect',
      SOTAV: 'Sotavento dialect group of Kabuverdianu',
      TARASK: 'Taraskievica orthography',
      UCCOR: 'Unified Orthography',
      UCRCOR: 'Unified Revised Orthography',
      UNIFON: 'Unifon phonetic alphabet',
      VALENCIA: 'Valencian',
      WADEGILE: 'Wade-Giles Romanization',
    });
  });
});
