"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetaTableIo = void 0;
const errors_1 = require("@ot-builder/errors");
const ot_name_1 = require("@ot-builder/ot-name");
const primitive_1 = require("@ot-builder/primitive");
const iconv = require("iconv-lite");
exports.MetaTableIo = {
    read(view) {
        const version = view.uint32();
        errors_1.Assert.VersionSupported(`MetaTable`, version, 1);
        const flags = view.uint32();
        const reserved = view.uint32();
        const dataMapsCount = view.uint32();
        return new ot_name_1.Meta.Table(view.array(dataMapsCount, DataMap));
    },
    write(frag, table) {
        errors_1.Assert.NoGap(`MetaTable::Data`, table.data);
        frag.uint32(1).uint32(0).uint32(0).uint32(table.data.length).array(DataMap, table.data);
    }
};
const DataMap = {
    read(view) {
        const tag = view.next(primitive_1.Tag);
        const vwData = view.ptr32();
        const dataLength = view.uint32();
        if (KnownTextTags.has(tag)) {
            return [tag, iconv.decode(vwData.bytes(dataLength), KnownTextTags.get(tag))];
        }
        else {
            return [tag, vwData.bytes(dataLength)];
        }
    },
    write(frag, [tag, data]) {
        frag.push(primitive_1.Tag, tag);
        const fData = frag.ptr32New();
        if (typeof data === "string") {
            const bufData = iconv.encode(data, KnownTextTags.get(tag) || "utf8");
            fData.bytes(bufData);
            frag.uint32(bufData.byteLength);
        }
        else {
            fData.bytes(data);
            frag.uint32(data.byteLength);
        }
    }
};
const KnownTextTags = new Map([
    [`dlng`, `utf8`], // Design languages
    [`slng`, `utf8`] // Supported languages
]);
//# sourceMappingURL=index.js.map