"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReadCmap = void 0;
const bin_util_1 = require("@ot-builder/bin-util");
const errors_1 = require("@ot-builder/errors");
const ot_encoding_1 = require("@ot-builder/ot-encoding");
const handlers_1 = require("./handlers");
exports.ReadCmap = (0, bin_util_1.Read)((view, gOrd) => {
    const version = view.uint16();
    errors_1.Assert.VersionSupported("cmap", version, 0);
    const cmap = new ot_encoding_1.Cmap.Table();
    const numTables = view.uint16();
    const raw = [];
    for (const [v] of view.repeat(numTables)) {
        const platform = v.uint16();
        const encoding = v.uint16();
        const vSubTable = v.ptr32();
        const format = vSubTable.uint16();
        raw.push({ platform, encoding, format, view: vSubTable.lift(0) });
    }
    for (const handlerF of handlers_1.SubtableHandlers) {
        const handler = handlerF();
        for (const r of raw) {
            if (handler.acceptEncoding(r.platform, r.encoding, r.format)) {
                r.view.lift(0).next(handler, gOrd);
                handler.apply(cmap);
            }
        }
    }
    return cmap;
});
//# sourceMappingURL=read.js.map