#!/usr/bin/env python3

from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return "Show current speech settings"

    def run(self):
        # Get current speech settings
        driver = self.env["runtime"]["SettingsManager"].get_setting(
            "speech", "driver"
        )
        module = self.env["runtime"]["SettingsManager"].get_setting(
            "speech", "module"
        )
        voice = self.env["runtime"]["SettingsManager"].get_setting(
            "speech", "voice"
        )
        rate = self.env["runtime"]["SettingsManager"].get_setting(
            "speech", "rate"
        )
        pitch = self.env["runtime"]["SettingsManager"].get_setting(
            "speech", "pitch"
        )
        volume = self.env["runtime"]["SettingsManager"].get_setting(
            "speech", "volume"
        )
        enabled = self.env["runtime"]["SettingsManager"].get_setting(
            "speech", "enabled"
        )

        self.env["runtime"]["OutputManager"].present_text(
            "Current speech settings:", interrupt=True
        )

        # Present all settings
        self.env["runtime"]["OutputManager"].present_text(
            f"Speech enabled: {enabled}", interrupt=True
        )
        self.env["runtime"]["OutputManager"].present_text(
            f"Driver: {driver}", interrupt=True
        )

        if module:
            self.env["runtime"]["OutputManager"].present_text(
                f"Module: {module}", interrupt=True
            )

        if voice:
            self.env["runtime"]["OutputManager"].present_text(
                f"Voice: {voice}", interrupt=True
            )

        try:
            rate_percent = int(float(rate) * 100)
            self.env["runtime"]["OutputManager"].present_text(
                f"Rate: {rate_percent} percent", interrupt=True
            )
        except Exception as e:
            self.env["runtime"]["OutputManager"].present_text(
                f"Rate: {rate}", interrupt=True
            )

        try:
            pitch_percent = int(float(pitch) * 100)
            self.env["runtime"]["OutputManager"].present_text(
                f"Pitch: {pitch_percent} percent", interrupt=True
            )
        except Exception as e:
            self.env["runtime"]["OutputManager"].present_text(
                f"Pitch: {pitch}", interrupt=True
            )

        try:
            volume_percent = int(float(volume) * 100)
            self.env["runtime"]["OutputManager"].present_text(
                f"Volume: {volume_percent} percent", interrupt=True
            )
        except Exception as e:
            self.env["runtime"]["OutputManager"].present_text(
                f"Volume: {volume}", interrupt=True
            )

        self.env["runtime"]["OutputManager"].play_sound("Accept")

    def set_callback(self, callback):
        pass
