#!/usr/bin/env python3

import importlib.util
import os

from fenrirscreenreader.core.i18n import _

# Load base configuration class
_base_path = os.path.join(os.path.dirname(__file__), "..", "config_base.py")
_spec = importlib.util.spec_from_file_location("config_base", _base_path)
_module = importlib.util.module_from_spec(_spec)
_spec.loader.exec_module(_module)
config_command = _module.config_command


class command(config_command):
    def __init__(self):
        super().__init__()

    def get_description(self):
        return "Create backup of current configuration"

    def run(self):
        self.present_text("Creating configuration backup...")

        success, message = self.backup_config(announce=False)

        if success:
            # Force the message to be queued and spoken
            self.env["runtime"]["OutputManager"].present_text(
                "Configuration backup created successfully",
                interrupt=False,
                flush=False,
            )
        else:
            self.env["runtime"]["OutputManager"].present_text(
                "Failed to create configuration backup",
                interrupt=False,
                flush=False,
            )
