// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*! 
 * @file Test.cpp
 * This source file contains the definition of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#ifdef _WIN32
// Remove linker warning LNK4221 on Visual Studio
namespace { char dummy; }
#endif

#include "Test.h"
#include "TestTypeObject.h"
#include <fastcdr/Cdr.h>

#include <fastcdr/exceptions/BadParamException.h>
using namespace eprosima::fastcdr::exception;

#include <utility>





BasicStruct::BasicStruct()
{
    m_my_bool = false;

    m_my_octet = 0;

    m_my_int16 = 0;

    m_my_int32 = 0;

    m_my_int64 = 0;

    m_my_uint16 = 0;

    m_my_uint32 = 0;

    m_my_uint64 = 0;

    m_my_float32 = 0.0;

    m_my_float64 = 0.0;

    m_my_float128 = 0.0;

    m_my_char = 0;

    m_my_wchar = 0;




    // Just to register all known types
    registerTestTypes();
}

BasicStruct::~BasicStruct()
{
}

BasicStruct::BasicStruct(const BasicStruct &x)
{
    m_my_bool = x.m_my_bool;
    m_my_octet = x.m_my_octet;
    m_my_int16 = x.m_my_int16;
    m_my_int32 = x.m_my_int32;
    m_my_int64 = x.m_my_int64;
    m_my_uint16 = x.m_my_uint16;
    m_my_uint32 = x.m_my_uint32;
    m_my_uint64 = x.m_my_uint64;
    m_my_float32 = x.m_my_float32;
    m_my_float64 = x.m_my_float64;
    m_my_float128 = x.m_my_float128;
    m_my_char = x.m_my_char;
    m_my_wchar = x.m_my_wchar;
    m_my_string = x.m_my_string;
    m_my_wstring = x.m_my_wstring;
}

BasicStruct::BasicStruct(BasicStruct &&x)
{
    m_my_bool = x.m_my_bool;
    m_my_octet = x.m_my_octet;
    m_my_int16 = x.m_my_int16;
    m_my_int32 = x.m_my_int32;
    m_my_int64 = x.m_my_int64;
    m_my_uint16 = x.m_my_uint16;
    m_my_uint32 = x.m_my_uint32;
    m_my_uint64 = x.m_my_uint64;
    m_my_float32 = x.m_my_float32;
    m_my_float64 = x.m_my_float64;
    m_my_float128 = x.m_my_float128;
    m_my_char = x.m_my_char;
    m_my_wchar = x.m_my_wchar;
    m_my_string = std::move(x.m_my_string);
    m_my_wstring = std::move(x.m_my_wstring);
}

BasicStruct& BasicStruct::operator=(const BasicStruct &x)
{
    m_my_bool = x.m_my_bool;
    m_my_octet = x.m_my_octet;
    m_my_int16 = x.m_my_int16;
    m_my_int32 = x.m_my_int32;
    m_my_int64 = x.m_my_int64;
    m_my_uint16 = x.m_my_uint16;
    m_my_uint32 = x.m_my_uint32;
    m_my_uint64 = x.m_my_uint64;
    m_my_float32 = x.m_my_float32;
    m_my_float64 = x.m_my_float64;
    m_my_float128 = x.m_my_float128;
    m_my_char = x.m_my_char;
    m_my_wchar = x.m_my_wchar;
    m_my_string = x.m_my_string;
    m_my_wstring = x.m_my_wstring;

    return *this;
}

BasicStruct& BasicStruct::operator=(BasicStruct &&x)
{
    m_my_bool = x.m_my_bool;
    m_my_octet = x.m_my_octet;
    m_my_int16 = x.m_my_int16;
    m_my_int32 = x.m_my_int32;
    m_my_int64 = x.m_my_int64;
    m_my_uint16 = x.m_my_uint16;
    m_my_uint32 = x.m_my_uint32;
    m_my_uint64 = x.m_my_uint64;
    m_my_float32 = x.m_my_float32;
    m_my_float64 = x.m_my_float64;
    m_my_float128 = x.m_my_float128;
    m_my_char = x.m_my_char;
    m_my_wchar = x.m_my_wchar;
    m_my_string = std::move(x.m_my_string);
    m_my_wstring = std::move(x.m_my_wstring);

    return *this;
}

size_t BasicStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    current_alignment += 8 + eprosima::fastcdr::Cdr::alignment(current_alignment, 8);


    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    current_alignment += 8 + eprosima::fastcdr::Cdr::alignment(current_alignment, 8);


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    current_alignment += 8 + eprosima::fastcdr::Cdr::alignment(current_alignment, 8);


    current_alignment += 16 + eprosima::fastcdr::Cdr::alignment(current_alignment, 8); // 128 bits, but aligned as 64

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 255 + 1;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + (255) * 4; // 32 bits


    return current_alignment - initial_alignment;
}

size_t BasicStruct::getCdrSerializedSize(const BasicStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    current_alignment += 8 + eprosima::fastcdr::Cdr::alignment(current_alignment, 8);


    current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    current_alignment += 8 + eprosima::fastcdr::Cdr::alignment(current_alignment, 8);


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    current_alignment += 8 + eprosima::fastcdr::Cdr::alignment(current_alignment, 8);


    current_alignment += 16 + eprosima::fastcdr::Cdr::alignment(current_alignment, 8); // 128 bits, but aligned as 64

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + data.my_string().size() + 1;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + (data.my_wstring().size()) * 4; // 32 bits


    return current_alignment - initial_alignment;
}

void BasicStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_bool;
    scdr << m_my_octet;
    scdr << m_my_int16;
    scdr << m_my_int32;
    scdr << m_my_int64;
    scdr << m_my_uint16;
    scdr << m_my_uint32;
    scdr << m_my_uint64;
    scdr << m_my_float32;
    scdr << m_my_float64;
    scdr << m_my_float128;
    scdr << m_my_char;
    scdr << m_my_wchar;
    scdr << m_my_string;
    scdr << m_my_wstring;
}

void BasicStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_bool;
    dcdr >> m_my_octet;
    dcdr >> m_my_int16;
    dcdr >> m_my_int32;
    dcdr >> m_my_int64;
    dcdr >> m_my_uint16;
    dcdr >> m_my_uint32;
    dcdr >> m_my_uint64;
    dcdr >> m_my_float32;
    dcdr >> m_my_float64;
    dcdr >> m_my_float128;
    dcdr >> m_my_char;
    dcdr >> m_my_wchar;
    dcdr >> m_my_string;
    dcdr >> m_my_wstring;
}

size_t BasicStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            
















    return current_align;
}

bool BasicStruct::isKeyDefined()
{
    return false;
}

void BasicStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
}





ComplexStruct::ComplexStruct()
{
    m_my_octet = 0;


    m_my_alias_enum = ::A;

    m_my_enum = ::A;



    memset(&m_my_array_octet, 0, (500 * 5 * 4) * 1);
    memset(&m_my_octet_array_500, 0, (500) * 1);











    memset(&m_multi_alias_array_42, 0, (42) * 4);



    // Just to register all known types
    registerTestTypes();
}

ComplexStruct::~ComplexStruct()
{
}

ComplexStruct::ComplexStruct(const ComplexStruct &x)
{
    m_my_octet = x.m_my_octet;
    m_my_basic_struct = x.m_my_basic_struct;
    m_my_alias_enum = x.m_my_alias_enum;
    m_my_enum = x.m_my_enum;
    m_my_sequence_octet = x.m_my_sequence_octet;
    m_my_sequence_struct = x.m_my_sequence_struct;
    m_my_array_octet = x.m_my_array_octet;
    m_my_octet_array_500 = x.m_my_octet_array_500;
    m_my_array_struct = x.m_my_array_struct;
    m_my_map_octet_short = x.m_my_map_octet_short;
    m_my_map_long_struct = x.m_my_map_long_struct;
    m_my_map_long_seq_octet = x.m_my_map_long_seq_octet;
    m_my_map_long_octet_array_500 = x.m_my_map_long_octet_array_500;
    m_my_map_long_lol_type = x.m_my_map_long_lol_type;
    m_my_small_string_8 = x.m_my_small_string_8;
    m_my_small_string_16 = x.m_my_small_string_16;
    m_my_large_string_8 = x.m_my_large_string_8;
    m_my_large_string_16 = x.m_my_large_string_16;
    m_my_array_string = x.m_my_array_string;
    m_multi_alias_array_42 = x.m_multi_alias_array_42;
    m_my_array_arrays = x.m_my_array_arrays;
    m_my_sequences_array = x.m_my_sequences_array;
}

ComplexStruct::ComplexStruct(ComplexStruct &&x)
{
    m_my_octet = x.m_my_octet;
    m_my_basic_struct = std::move(x.m_my_basic_struct);
    m_my_alias_enum = x.m_my_alias_enum;
    m_my_enum = x.m_my_enum;
    m_my_sequence_octet = std::move(x.m_my_sequence_octet);
    m_my_sequence_struct = std::move(x.m_my_sequence_struct);
    m_my_array_octet = std::move(x.m_my_array_octet);
    m_my_octet_array_500 = std::move(x.m_my_octet_array_500);
    m_my_array_struct = std::move(x.m_my_array_struct);
    m_my_map_octet_short = std::move(x.m_my_map_octet_short);
    m_my_map_long_struct = std::move(x.m_my_map_long_struct);
    m_my_map_long_seq_octet = std::move(x.m_my_map_long_seq_octet);
    m_my_map_long_octet_array_500 = std::move(x.m_my_map_long_octet_array_500);
    m_my_map_long_lol_type = std::move(x.m_my_map_long_lol_type);
    m_my_small_string_8 = std::move(x.m_my_small_string_8);
    m_my_small_string_16 = std::move(x.m_my_small_string_16);
    m_my_large_string_8 = std::move(x.m_my_large_string_8);
    m_my_large_string_16 = std::move(x.m_my_large_string_16);
    m_my_array_string = std::move(x.m_my_array_string);
    m_multi_alias_array_42 = std::move(x.m_multi_alias_array_42);
    m_my_array_arrays = std::move(x.m_my_array_arrays);
    m_my_sequences_array = std::move(x.m_my_sequences_array);
}

ComplexStruct& ComplexStruct::operator=(const ComplexStruct &x)
{
    m_my_octet = x.m_my_octet;
    m_my_basic_struct = x.m_my_basic_struct;
    m_my_alias_enum = x.m_my_alias_enum;
    m_my_enum = x.m_my_enum;
    m_my_sequence_octet = x.m_my_sequence_octet;
    m_my_sequence_struct = x.m_my_sequence_struct;
    m_my_array_octet = x.m_my_array_octet;
    m_my_octet_array_500 = x.m_my_octet_array_500;
    m_my_array_struct = x.m_my_array_struct;
    m_my_map_octet_short = x.m_my_map_octet_short;
    m_my_map_long_struct = x.m_my_map_long_struct;
    m_my_map_long_seq_octet = x.m_my_map_long_seq_octet;
    m_my_map_long_octet_array_500 = x.m_my_map_long_octet_array_500;
    m_my_map_long_lol_type = x.m_my_map_long_lol_type;
    m_my_small_string_8 = x.m_my_small_string_8;
    m_my_small_string_16 = x.m_my_small_string_16;
    m_my_large_string_8 = x.m_my_large_string_8;
    m_my_large_string_16 = x.m_my_large_string_16;
    m_my_array_string = x.m_my_array_string;
    m_multi_alias_array_42 = x.m_multi_alias_array_42;
    m_my_array_arrays = x.m_my_array_arrays;
    m_my_sequences_array = x.m_my_sequences_array;

    return *this;
}

ComplexStruct& ComplexStruct::operator=(ComplexStruct &&x)
{
    m_my_octet = x.m_my_octet;
    m_my_basic_struct = std::move(x.m_my_basic_struct);
    m_my_alias_enum = x.m_my_alias_enum;
    m_my_enum = x.m_my_enum;
    m_my_sequence_octet = std::move(x.m_my_sequence_octet);
    m_my_sequence_struct = std::move(x.m_my_sequence_struct);
    m_my_array_octet = std::move(x.m_my_array_octet);
    m_my_octet_array_500 = std::move(x.m_my_octet_array_500);
    m_my_array_struct = std::move(x.m_my_array_struct);
    m_my_map_octet_short = std::move(x.m_my_map_octet_short);
    m_my_map_long_struct = std::move(x.m_my_map_long_struct);
    m_my_map_long_seq_octet = std::move(x.m_my_map_long_seq_octet);
    m_my_map_long_octet_array_500 = std::move(x.m_my_map_long_octet_array_500);
    m_my_map_long_lol_type = std::move(x.m_my_map_long_lol_type);
    m_my_small_string_8 = std::move(x.m_my_small_string_8);
    m_my_small_string_16 = std::move(x.m_my_small_string_16);
    m_my_large_string_8 = std::move(x.m_my_large_string_8);
    m_my_large_string_16 = std::move(x.m_my_large_string_16);
    m_my_array_string = std::move(x.m_my_array_string);
    m_multi_alias_array_42 = std::move(x.m_multi_alias_array_42);
    m_my_array_arrays = std::move(x.m_my_array_arrays);
    m_my_sequences_array = std::move(x.m_my_sequences_array);

    return *this;
}

size_t ComplexStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    current_alignment += BasicStruct::getMaxCdrSerializedSize(current_alignment);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    current_alignment += (55 * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);



    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    for(size_t a = 0; a < 100; ++a)
    {
        current_alignment += BasicStruct::getMaxCdrSerializedSize(current_alignment);}

    current_alignment += ((500 * 5 * 4) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    current_alignment += ((500) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);



    for(size_t a = 0; a < (5); ++a)
    {
        current_alignment += BasicStruct::getMaxCdrSerializedSize(current_alignment);}
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    for(size_t a = 0; a < 100; ++a)
    {
        current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

        current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);


    }

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    for(size_t a = 0; a < 100; ++a)
    {
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

        current_alignment += BasicStruct::getMaxCdrSerializedSize(current_alignment);
    }

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    for(size_t a = 0; a < 100; ++a)
    {
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


        for(size_t b = 0; b < 100; ++b)
        {
            current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

            current_alignment += (100 * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


        }
    }

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    for(size_t a = 0; a < 100; ++a)
    {
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

        current_alignment += ((500) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    }

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    for(size_t a = 0; a < 100; ++a)
    {
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

        for(size_t b = 0; b < 100; ++b)
        {
            current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


            for(size_t c = 0; c < (5); ++c)
            {
                current_alignment += BasicStruct::getMaxCdrSerializedSize(current_alignment);}}
    }

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 128 + 1;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + (64) * 4; // 32 bits

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 500 + 1;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + (1024) * 4; // 32 bits


    for(size_t a = 0; a < (5 * 5); ++a)
    {
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + 75 + 1;
    }
    current_alignment += ((42) * 4) + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);



    for(size_t a = 0; a < (5); ++a)
    {
    current_alignment += ((2) * 4) + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    }

    for(size_t a = 0; a < (23); ++a)
    {
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

        current_alignment += (100 * 4) + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    }

    return current_alignment - initial_alignment;
}

size_t ComplexStruct::getCdrSerializedSize(const ComplexStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    current_alignment += BasicStruct::getCdrSerializedSize(data.my_basic_struct(), current_alignment);
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    current_alignment += (data.my_sequence_octet().size() * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);



    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    for(size_t a = 0; a < data.my_sequence_struct().size(); ++a)
    {
        current_alignment += BasicStruct::getCdrSerializedSize(data.my_sequence_struct().at(a), current_alignment);}

    current_alignment += ((500 * 5 * 4) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    current_alignment += ((500) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    for(size_t a = 0; a < data.my_array_struct().size(); ++a)
    {
            current_alignment += BasicStruct::getCdrSerializedSize(data.my_array_struct().at(a), current_alignment);
    }
    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    for(auto a : data.my_map_octet_short())
    {
        (void)a;
        current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);
        current_alignment += 2 + eprosima::fastcdr::Cdr::alignment(current_alignment, 2);



    }


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    for(auto a : data.my_map_long_struct())
    {
        (void)a;
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
        current_alignment += BasicStruct::getCdrSerializedSize((a.second), current_alignment);

    }


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    for(auto a : data.my_map_long_seq_octet())
    {
        (void)a;
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


        for(size_t b = 0; b < a.second.size(); ++b)
        {
            current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

            current_alignment += (a.second.at(b).size() * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


        }

    }


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    for(auto a : data.my_map_long_octet_array_500())
    {
        (void)a;
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
        current_alignment += ((500) * 1) + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    }


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    for(auto a : data.my_map_long_lol_type())
    {
        (void)a;
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

        for(auto b : a.second)
        {
            (void)b;
            current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

            for(size_t c = 0; c < b.second.size(); ++c)
            {
                    current_alignment += BasicStruct::getCdrSerializedSize(b.second.at(c), current_alignment);
            }
        }


    }


    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + data.my_small_string_8().size() + 1;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + (data.my_small_string_16().size()) * 4; // 32 bits

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + data.my_large_string_8().size() + 1;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + (data.my_large_string_16().size()) * 4; // 32 bits


    for(size_t a = 0; a < data.my_array_string().size(); ++a)
    {

        for(size_t b = 0; b < data.my_array_string().at(a).size(); ++b)
        {
                current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + data.my_array_string().at(a).at(b).size() + 1;

        }
    }
    current_alignment += ((42) * 4) + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    for(size_t a = 0; a < data.my_array_arrays().size(); ++a)
    {
            current_alignment += ((2) * 4) + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);
    }

    for(size_t a = 0; a < data.my_sequences_array().size(); ++a)
    {
            current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

            current_alignment += (data.my_sequences_array().at(a).size() * 4) + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


    }

    return current_alignment - initial_alignment;
}

void ComplexStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_octet;
    scdr << m_my_basic_struct;
    scdr << (uint32_t)m_my_alias_enum;
    scdr << (uint32_t)m_my_enum;
    scdr << m_my_sequence_octet;
    scdr << m_my_sequence_struct;
    scdr << m_my_array_octet;
    scdr << m_my_octet_array_500;
    scdr << m_my_array_struct;
    scdr << m_my_map_octet_short;
    scdr << m_my_map_long_struct;
    scdr << m_my_map_long_seq_octet;
    scdr << m_my_map_long_octet_array_500;
    scdr << m_my_map_long_lol_type;
    scdr << m_my_small_string_8;
    scdr << m_my_small_string_16;
    scdr << m_my_large_string_8;
    scdr << m_my_large_string_16;
    scdr << m_my_array_string;
    scdr.serializeArray(reinterpret_cast<const uint32_t*>(m_multi_alias_array_42.data()), m_multi_alias_array_42.size());
    scdr << m_my_array_arrays;
    scdr << m_my_sequences_array;
}

void ComplexStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_octet;
    dcdr >> m_my_basic_struct;
    {
        uint32_t enum_value = 0;
        dcdr >> enum_value;
        m_my_alias_enum = (MyAliasEnum)enum_value;
    }
    {
        uint32_t enum_value = 0;
        dcdr >> enum_value;
        m_my_enum = (MyEnum)enum_value;
    }
    dcdr >> m_my_sequence_octet;
    dcdr >> m_my_sequence_struct;
    dcdr >> m_my_array_octet;
    dcdr >> m_my_octet_array_500;
    dcdr >> m_my_array_struct;
    dcdr >> m_my_map_octet_short;
    dcdr >> m_my_map_long_struct;
    dcdr >> m_my_map_long_seq_octet;
    dcdr >> m_my_map_long_octet_array_500;
    dcdr >> m_my_map_long_lol_type;
    dcdr >> m_my_small_string_8;
    dcdr >> m_my_small_string_16;
    dcdr >> m_my_large_string_8;
    dcdr >> m_my_large_string_16;
    dcdr >> m_my_array_string;
    dcdr.deserializeArray(reinterpret_cast<uint32_t*>(m_multi_alias_array_42.data()), m_multi_alias_array_42.size());
    dcdr >> m_my_array_arrays;
    dcdr >> m_my_sequences_array;
}

size_t ComplexStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            























    return current_align;
}

bool ComplexStruct::isKeyDefined()
{
    return false;
}

void ComplexStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
	 
}
MyUnion::MyUnion()
{
    m__d = ::A;


}

MyUnion::~MyUnion()
{
}

MyUnion::MyUnion(const MyUnion &x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case ::A:
        m_basic = x.m_basic;
        break;
        case ::B:
        case ::C:
        m_complex = x.m_complex;
        break;
        default:
        break;
    }
}

MyUnion::MyUnion(MyUnion &&x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case ::A:
        m_basic = std::move(x.m_basic);
        break;
        case ::B:
        case ::C:
        m_complex = std::move(x.m_complex);
        break;
        default:
        break;
    }
}

MyUnion& MyUnion::operator=(const MyUnion &x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case ::A:
        m_basic = x.m_basic;
        break;
        case ::B:
        case ::C:
        m_complex = x.m_complex;
        break;
        default:
        break;
    }

    return *this;
}

MyUnion& MyUnion::operator=(MyUnion &&x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case ::A:
        m_basic = std::move(x.m_basic);
        break;
        case ::B:
        case ::C:
        m_complex = std::move(x.m_complex);
        break;
        default:
        break;
    }

    return *this;
}

void MyUnion::_d(MyEnum __d)
{
    bool b = false;

    switch(m__d)
    {
        case ::A:
        switch(__d)
        {
            case ::A:
            b = true;
            break;
            default:
            break;
        }
        break;
        case ::B:
        case ::C:
        switch(__d)
        {
            case ::B:
            case ::C:
            b = true;
            break;
            default:
            break;
        }
        break;
    }

    if(!b)
    {
        throw BadParamException("Discriminator doesn't correspond with the selected union member");
    }

    m__d = __d;
}

MyEnum MyUnion::_d() const
{
    return m__d;
}

MyEnum& MyUnion::_d()
{
    return m__d;
}

void MyUnion::basic(const BasicStruct &_basic)
{
    m_basic = _basic;
    m__d = ::A;
}

void MyUnion::basic(BasicStruct &&_basic)
{
    m_basic = std::move(_basic);
    m__d = ::A;
}

const BasicStruct& MyUnion::basic() const
{
    bool b = false;

    switch(m__d)
    {
        case ::A:
        b = true;
        break;
        default:
        break;
    }
    if(!b)
    {
        throw BadParamException("This member is not been selected");
    }

    return m_basic;
}

BasicStruct& MyUnion::basic()
{
    bool b = false;

    switch(m__d)
    {
        case ::A:
        b = true;
        break;
        default:
        break;
    }
    if(!b)
    {
        throw BadParamException("This member is not been selected");
    }

    return m_basic;
}
void MyUnion::complex(const ComplexStruct &_complex)
{
    m_complex = _complex;
    m__d = ::B;
}

void MyUnion::complex(ComplexStruct &&_complex)
{
    m_complex = std::move(_complex);
    m__d = ::B;
}

const ComplexStruct& MyUnion::complex() const
{
    bool b = false;

    switch(m__d)
    {
        case ::B:
        case ::C:
        b = true;
        break;
        default:
        break;
    }
    if(!b)
    {
        throw BadParamException("This member is not been selected");
    }

    return m_complex;
}

ComplexStruct& MyUnion::complex()
{
    bool b = false;

    switch(m__d)
    {
        case ::B:
        case ::C:
        b = true;
        break;
        default:
        break;
    }
    if(!b)
    {
        throw BadParamException("This member is not been selected");
    }

    return m_complex;
}

size_t MyUnion::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    size_t reset_alignment = 0;
    size_t union_max_size_serialized = 0;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);


        reset_alignment = current_alignment;

        reset_alignment += BasicStruct::getMaxCdrSerializedSize(reset_alignment);

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        
        reset_alignment = current_alignment;

        reset_alignment += ComplexStruct::getMaxCdrSerializedSize(reset_alignment);

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        

    return union_max_size_serialized - initial_alignment;
}

// TODO(Ricardo) Review
size_t MyUnion::getCdrSerializedSize(const MyUnion& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

    switch(data.m__d)
    {
        case ::A:
        current_alignment += BasicStruct::getCdrSerializedSize(data.basic(), current_alignment);
        break;
        case ::B:
        case ::C:
        current_alignment += ComplexStruct::getCdrSerializedSize(data.complex(), current_alignment);
        break;
        default:
        break;
    }

    return current_alignment - initial_alignment;
}

void MyUnion::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << (uint32_t)m__d;

    switch(m__d)
    {
        case ::A:
        scdr << m_basic;
        break;
        case ::B:
        case ::C:
        scdr << m_complex;
        break;
        default:
        break;
    }
}

void MyUnion::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    {
        uint32_t enum_value = 0;
        dcdr >> enum_value;
        m__d = (MyEnum)enum_value;
    }

    switch(m__d)
    {
        case ::A:
        dcdr >> m_basic;
        break;
        case ::B:
        case ::C:
        dcdr >> m_complex;
        break;
        default:
        break;
    }
}


MyUnion2::MyUnion2()
{
    m__d = A;
    m_uno = 0;


    m_tres = 0;

}

MyUnion2::~MyUnion2()
{
}

MyUnion2::MyUnion2(const MyUnion2 &x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case A:
        m_uno = x.m_uno;
        break;
        case B:
        m_imString = x.m_imString;
        break;
        case C:
        m_tres = x.m_tres;
        break;
        default:
        break;
    }
}

MyUnion2::MyUnion2(MyUnion2 &&x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case A:
        m_uno = x.m_uno;
        break;
        case B:
        m_imString = std::move(x.m_imString);
        break;
        case C:
        m_tres = x.m_tres;
        break;
        default:
        break;
    }
}

MyUnion2& MyUnion2::operator=(const MyUnion2 &x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case A:
        m_uno = x.m_uno;
        break;
        case B:
        m_imString = x.m_imString;
        break;
        case C:
        m_tres = x.m_tres;
        break;
        default:
        break;
    }

    return *this;
}

MyUnion2& MyUnion2::operator=(MyUnion2 &&x)
{
    m__d = x.m__d;

    switch(m__d)
    {
        case A:
        m_uno = x.m_uno;
        break;
        case B:
        m_imString = std::move(x.m_imString);
        break;
        case C:
        m_tres = x.m_tres;
        break;
        default:
        break;
    }

    return *this;
}

void MyUnion2::_d(uint8_t __d)
{
    bool b = false;

    switch(m__d)
    {
        case A:
        switch(__d)
        {
            case A:
            b = true;
            break;
            default:
            break;
        }
        break;
        case B:
        switch(__d)
        {
            case B:
            b = true;
            break;
            default:
            break;
        }
        break;
        case C:
        switch(__d)
        {
            case C:
            b = true;
            break;
            default:
            break;
        }
        break;
    }

    if(!b)
    {
        throw BadParamException("Discriminator doesn't correspond with the selected union member");
    }

    m__d = __d;
}

uint8_t MyUnion2::_d() const
{
    return m__d;
}

uint8_t& MyUnion2::_d()
{
    return m__d;
}

void MyUnion2::uno(int32_t _uno)
{
    m_uno = _uno;
    m__d = A;
}

int32_t MyUnion2::uno() const
{
    bool b = false;

    switch(m__d)
    {
        case A:
        b = true;
        break;
        default:
        break;
    }
    if(!b)
    {
        throw BadParamException("This member is not been selected");
    }

    return m_uno;
}

int32_t& MyUnion2::uno()
{
    bool b = false;

    switch(m__d)
    {
        case A:
        b = true;
        break;
        default:
        break;
    }
    if(!b)
    {
        throw BadParamException("This member is not been selected");
    }

    return m_uno;
}
void MyUnion2::imString(const std::string &_imString)
{
    m_imString = _imString;
    m__d = B;
}

void MyUnion2::imString(std::string &&_imString)
{
    m_imString = std::move(_imString);
    m__d = B;
}

const std::string& MyUnion2::imString() const
{
    bool b = false;

    switch(m__d)
    {
        case B:
        b = true;
        break;
        default:
        break;
    }
    if(!b)
    {
        throw BadParamException("This member is not been selected");
    }

    return m_imString;
}

std::string& MyUnion2::imString()
{
    bool b = false;

    switch(m__d)
    {
        case B:
        b = true;
        break;
        default:
        break;
    }
    if(!b)
    {
        throw BadParamException("This member is not been selected");
    }

    return m_imString;
}
void MyUnion2::tres(int32_t _tres)
{
    m_tres = _tres;
    m__d = C;
}

int32_t MyUnion2::tres() const
{
    bool b = false;

    switch(m__d)
    {
        case C:
        b = true;
        break;
        default:
        break;
    }
    if(!b)
    {
        throw BadParamException("This member is not been selected");
    }

    return m_tres;
}

int32_t& MyUnion2::tres()
{
    bool b = false;

    switch(m__d)
    {
        case C:
        b = true;
        break;
        default:
        break;
    }
    if(!b)
    {
        throw BadParamException("This member is not been selected");
    }

    return m_tres;
}

size_t MyUnion2::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;
    size_t reset_alignment = 0;
    size_t union_max_size_serialized = 0;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


        reset_alignment = current_alignment;

        reset_alignment += 4 + eprosima::fastcdr::Cdr::alignment(reset_alignment, 4);


        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        
        reset_alignment = current_alignment;

        reset_alignment += 4 + eprosima::fastcdr::Cdr::alignment(reset_alignment, 4) + 255 + 1;

        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        
        reset_alignment = current_alignment;

        reset_alignment += 4 + eprosima::fastcdr::Cdr::alignment(reset_alignment, 4);


        if(union_max_size_serialized < reset_alignment)
            union_max_size_serialized = reset_alignment;

        

    return union_max_size_serialized - initial_alignment;
}

// TODO(Ricardo) Review
size_t MyUnion2::getCdrSerializedSize(const MyUnion2& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);

    switch(data.m__d)
    {
        case A:
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

        break;
        case B:
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4) + data.imString().size() + 1;
        break;
        case C:
        current_alignment += 4 + eprosima::fastcdr::Cdr::alignment(current_alignment, 4);

        break;
        default:
        break;
    }

    return current_alignment - initial_alignment;
}

void MyUnion2::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m__d;

    switch(m__d)
    {
        case A:
        scdr << m_uno;
        break;
        case B:
        scdr << m_imString;
        break;
        case C:
        scdr << m_tres;
        break;
        default:
        break;
    }
}

void MyUnion2::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m__d;

    switch(m__d)
    {
        case A:
        dcdr >> m_uno;
        break;
        case B:
        dcdr >> m_imString;
        break;
        case C:
        dcdr >> m_tres;
        break;
        default:
        break;
    }
}


CompleteStruct::CompleteStruct()
{



    // Just to register all known types
    registerTestTypes();
}

CompleteStruct::~CompleteStruct()
{
}

CompleteStruct::CompleteStruct(const CompleteStruct &x)
{
    m_my_union = x.m_my_union;
    m_my_union_2 = x.m_my_union_2;
}

CompleteStruct::CompleteStruct(CompleteStruct &&x)
{
    m_my_union = std::move(x.m_my_union);
    m_my_union_2 = std::move(x.m_my_union_2);
}

CompleteStruct& CompleteStruct::operator=(const CompleteStruct &x)
{
    m_my_union = x.m_my_union;
    m_my_union_2 = x.m_my_union_2;

    return *this;
}

CompleteStruct& CompleteStruct::operator=(CompleteStruct &&x)
{
    m_my_union = std::move(x.m_my_union);
    m_my_union_2 = std::move(x.m_my_union_2);

    return *this;
}

size_t CompleteStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += MyUnion::getMaxCdrSerializedSize(current_alignment);
    current_alignment += MyUnion2::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t CompleteStruct::getCdrSerializedSize(const CompleteStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += MyUnion::getCdrSerializedSize(data.my_union(), current_alignment);
    current_alignment += MyUnion2::getCdrSerializedSize(data.my_union_2(), current_alignment);

    return current_alignment - initial_alignment;
}

void CompleteStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_my_union;
    scdr << m_my_union_2;
}

void CompleteStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_my_union;
    dcdr >> m_my_union_2;
}

size_t CompleteStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            



    return current_align;
}

bool CompleteStruct::isKeyDefined()
{
    return false;
}

void CompleteStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 
	 
}
KeyedStruct::KeyedStruct()
{
    m_key = 0;



    // Just to register all known types
    registerTestTypes();
}

KeyedStruct::~KeyedStruct()
{
}

KeyedStruct::KeyedStruct(const KeyedStruct &x)
{
    m_key = x.m_key;
    m_basic = x.m_basic;
}

KeyedStruct::KeyedStruct(KeyedStruct &&x)
{
    m_key = x.m_key;
    m_basic = std::move(x.m_basic);
}

KeyedStruct& KeyedStruct::operator=(const KeyedStruct &x)
{
    m_key = x.m_key;
    m_basic = x.m_basic;

    return *this;
}

KeyedStruct& KeyedStruct::operator=(KeyedStruct &&x)
{
    m_key = x.m_key;
    m_basic = std::move(x.m_basic);

    return *this;
}

size_t KeyedStruct::getMaxCdrSerializedSize(size_t current_alignment)
{
    size_t initial_alignment = current_alignment;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    current_alignment += BasicStruct::getMaxCdrSerializedSize(current_alignment);

    return current_alignment - initial_alignment;
}

size_t KeyedStruct::getCdrSerializedSize(const KeyedStruct& data, size_t current_alignment)
{
    (void)data;
    size_t initial_alignment = current_alignment;

    current_alignment += 1 + eprosima::fastcdr::Cdr::alignment(current_alignment, 1);


    current_alignment += BasicStruct::getCdrSerializedSize(data.basic(), current_alignment);

    return current_alignment - initial_alignment;
}

void KeyedStruct::serialize(eprosima::fastcdr::Cdr &scdr) const
{
    scdr << m_key;
    scdr << m_basic;
}

void KeyedStruct::deserialize(eprosima::fastcdr::Cdr &dcdr)
{
    dcdr >> m_key;
    dcdr >> m_basic;
}

size_t KeyedStruct::getKeyMaxCdrSerializedSize(size_t current_alignment)
{
	size_t current_align = current_alignment;
            
     current_align += 1 + eprosima::fastcdr::Cdr::alignment(current_align, 1);

     


    return current_align;
}

bool KeyedStruct::isKeyDefined()
{
    return true;
}

void KeyedStruct::serializeKey(eprosima::fastcdr::Cdr &scdr) const
{
	(void) scdr;
	 scdr << m_key;  
	 
}