/*
// $Id: //open/dev/farrago/src/org/eigenbase/runtime/SyntheticObject.java#9 $
// Package org.eigenbase is a class library of data management components.
// Copyright (C) 2005-2009 The Eigenbase Project
// Copyright (C) 2002-2009 SQLstream, Inc.
// Copyright (C) 2005-2009 LucidEra, Inc.
// Portions Copyright (C) 2003-2009 John V. Sichi
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License, or (at your option)
// any later version approved by The Eigenbase Project.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package org.eigenbase.runtime;

import java.lang.reflect.*;


/**
 * <code>SyntheticObject</code> is a base class for all objects built 'on the
 * fly' by the saffron system. For example, if you write
 *
 * <blockquote>
 * <pre>for (i in select {emp.firstName, emp.lastName} from emps as emp) {
 *     ...
 * }</pre>
 * </blockquote>
 *
 * then <code>i</code>'s type will be a class, generated by the saffron
 * compiler, something like this:
 *
 * <blockquote>
 * <pre>class saffron.runtime.Dummy_a01bc65 extends {@link SyntheticObject} {
 *     public String firstName;
 *     public String lastName;
 * }</pre>
 * </blockquote>
 *
 * @author jhyde
 * @version $Id: //open/dev/farrago/src/org/eigenbase/runtime/SyntheticObject.java#9 $
 * @since 23 April, 2002
 */
public abstract class SyntheticObject
{
    //~ Methods ----------------------------------------------------------------

    /**
     * Returns the value of a given field.
     */
    public Object getFieldValue(int i)
    {
        try {
            Field field = getFields()[i];
            return field.get(this);
        } catch (IllegalArgumentException e) {
            return null;
        } catch (IllegalAccessException e) {
            return null;
        }
    }

    /**
     * Returns the fields of this object, in the order they were specified in
     * the original query.
     */
    public Field [] getFields()
    {
        return getClass().getDeclaredFields();
    }
}

// End SyntheticObject.java
