/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

using GLib;

[GtkTemplate (ui = "/org/gnome/DejaDup/RestoreToolbarView.ui")]
public class RestoreToolbarView : Adw.Bin
{
  public signal void restore();

  public Gtk.Widget content {get; set;}
  public Browser browser {get; set;}
  public bool thin_mode {get; set;}

  public void activate_search() {
    search_bar.search_mode_enabled = true;
  }

  [GtkChild]
  unowned Adw.ToolbarView view;
  [GtkChild]
  unowned Gtk.Button restore_button;
  [GtkChild]
  unowned Gtk.SearchBar search_bar;
  [GtkChild]
  unowned Gtk.SearchEntry search_entry;
  [GtkChild]
  unowned Gtk.ActionBar action_bar;

  construct {
    var op_watcher = DejaDup.OperationWatcher.get_instance();
    op_watcher.notify["active"].connect(update_restore_button);
    update_restore_button();

    notify["browser"].connect(new_browser);
  }

  void new_browser()
  {
    if (browser == null)
      return;

    browser.notify["has-selection"].connect(update_restore_button);
    update_restore_button();
  }

  void update_restore_button()
  {
    var active_op = DejaDup.OperationWatcher.get_instance().active;
    var has_selection = browser != null && browser.has_selection;
    restore_button.sensitive = !active_op && has_selection;
  }

  [GtkCallback]
  void on_search_changed()
  {
    if (browser != null)
      browser.search_filter = search_entry.text;
  }

  [GtkCallback]
  void emit_restore()
  {
    restore();
  }

  [GtkCallback]
  void on_thin_mode_changed()
  {
    // OK we have to move the search bar up or down
    view.remove(search_bar);
    if (thin_mode) {
      view.add_bottom_bar(search_bar);
      view.remove(action_bar);
      view.add_bottom_bar(action_bar);
    }
    else
      view.add_top_bar(search_bar);
  }
}
