# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""Common test-helper code involving server tasks."""

from typing import Any, Protocol, override

from debusine.db.models.tasks import DBTask
from debusine.server.tasks.base import BaseServerTask
from debusine.server.tasks.wait import BaseWaitTask
from debusine.tasks.models import BaseDynamicTaskData, BaseTaskData
from debusine.tasks.server import TaskDatabaseInterface


class DBTaskTestProtocol[TaskClass: DBTask[Any, Any]](Protocol):
    """Attributes that tests using :py:class:`TaskHelperMixin` must provide."""

    SAMPLE_TASK_DATA: dict[str, Any]
    task_class: type[TaskClass]
    task: TaskClass


class SampleBaseDBTask[TD: BaseTaskData, DTD: BaseDynamicTaskData](
    DBTask[TD, DTD]
):
    """Common test implementation of abstract task methods."""

    @override
    def build_dynamic_data(
        self,
        task_database: TaskDatabaseInterface,  # noqa: U100
    ) -> DTD:
        """Resolve artifact lookups for this task."""
        return self.dynamic_task_data_type()


class SampleBaseServerTask[TD: BaseTaskData, DTD: BaseDynamicTaskData](
    SampleBaseDBTask[TD, DTD], BaseServerTask[TD, DTD]
):
    """Common test implementation of BaseServerTask methods."""


class SampleBaseWaitTask[TD: BaseTaskData, DTD: BaseDynamicTaskData](
    SampleBaseDBTask[TD, DTD], BaseWaitTask[TD, DTD]
):
    """Common test implementation of BaseWaitTask methods."""
