struct cpuinfo_mock_file filesystem[] = {
	{
		.path = "/proc/cpuinfo",
		.size = 1224,
		.content =
			"processor\t: 0\n"
			"model name\t: ARMv7 Processor rev 0 (v7l)\n"
			"BogoMIPS\t: 38.40\n"
			"Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt vfpd32 evtstrm \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 7\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd03\n"
			"CPU revision\t: 0\n"
			"\n"
			"processor\t: 1\n"
			"model name\t: ARMv7 Processor rev 0 (v7l)\n"
			"BogoMIPS\t: 38.40\n"
			"Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt vfpd32 evtstrm \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 7\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd03\n"
			"CPU revision\t: 0\n"
			"\n"
			"processor\t: 2\n"
			"model name\t: ARMv7 Processor rev 0 (v7l)\n"
			"BogoMIPS\t: 38.40\n"
			"Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt vfpd32 evtstrm \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 7\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd03\n"
			"CPU revision\t: 0\n"
			"\n"
			"processor\t: 3\n"
			"model name\t: ARMv7 Processor rev 0 (v7l)\n"
			"BogoMIPS\t: 38.40\n"
			"Features\t: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt vfpd32 evtstrm \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 7\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd03\n"
			"CPU revision\t: 0\n"
			"\n"
			"Hardware\t: Qualcomm Technologies, Inc MSM8916\n"
			"Revision\t: 82b0\n"
			"Serial\t\t: df3e911500000000\n"
			"Processor\t: ARMv7 Processor rev 0 (v7l)\n"
			"Device\t\t: osprey\n"
			"Radio\t\t: 1\n"
			"MSM Hardware\t: MSM8916\n",
	},
	{
		.path = "/system/build.prop",
		.size = 9105,
		.content =
			"\n"
			"# begin build properties\n"
			"# autogenerated by buildinfo.sh\n"
			"ro.build.id=MPIS24.65-25.1-19\n"
			"ro.build.display.id=MPIS24.65-25.1-19\n"
			"ro.build.version.incremental=14\n"
			"ro.build.version.sdk=23\n"
			"ro.build.version.preview_sdk=0\n"
			"ro.build.version.codename=REL\n"
			"ro.build.version.all_codenames=REL\n"
			"ro.build.version.release=6.0\n"
			"ro.build.version.security_patch=2017-04-01\n"
			"ro.build.version.base_os=motorola/osprey_retus_2gb/osprey_u2:6.0/MPI24.65-25.1/1:user/release-keys\n"
			"ro.mot.base_buildid=MPI24.65-25.1/1\n"
			"ro.build.date=Thu Apr  6 09:22:04 CDT 2017\n"
			"ro.build.date.utc=1491488524\n"
			"ro.build.type=user\n"
			"ro.build.user=hudsoncm\n"
			"ro.build.host=ilclbld87\n"
			"ro.build.tags=release-keys\n"
			"ro.build.flavor=osprey_retus_2gb-user\n"
			"ro.product.model=MotoG3\n"
			"ro.product.brand=motorola\n"
			"ro.product.name=osprey_retus_2gb\n"
			"ro.product.device=osprey_u2\n"
			"ro.product.board=msm8916\n"
			"# ro.product.cpu.abi and ro.product.cpu.abi2 are obsolete,\n"
			"# use ro.product.cpu.abilist instead.\n"
			"ro.product.cpu.abi=armeabi-v7a\n"
			"ro.product.cpu.abi2=armeabi\n"
			"ro.product.cpu.abilist=armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist32=armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist64=\n"
			"ro.product.manufacturer=motorola\n"
			"ro.product.locale=en-US\n"
			"ro.wifi.channels=\n"
			"ro.board.platform=msm8916\n"
			"# ro.build.product is obsolete; use ro.product.device\n"
			"ro.build.product=osprey_u2\n"
			"# Do not try to parse description, fingerprint, or thumbprint\n"
			"ro.build.description=osprey_retus_2gb-user 6.0 MPIS24.65-25.1-19 14 release-keys\n"
			"ro.build.fingerprint=motorola/osprey_retus_2gb/osprey_u2:6.0/MPIS24.65-25.1-19/14:user/release-keys\n"
			"ro.build.characteristics=default\n"
			"# end build properties\n"
			"#\n"
			"# from device/qcom/msm8916_32/system.prop\n"
			"#\n"
			"#\n"
			"# system.prop for msm8916\n"
			"#\n"
			"\n"
			"#rild.libpath=/system/lib/libreference-ril.so\n"
			"rild.libpath=/system/vendor/lib/libril-qc-qmi-1.so\n"
			"rild.libargs=-d /dev/smd0\n"
			"persist.rild.nitz_plmn=\n"
			"persist.rild.nitz_long_ons_0=\n"
			"persist.rild.nitz_long_ons_1=\n"
			"persist.rild.nitz_long_ons_2=\n"
			"persist.rild.nitz_long_ons_3=\n"
			"persist.rild.nitz_short_ons_0=\n"
			"persist.rild.nitz_short_ons_1=\n"
			"persist.rild.nitz_short_ons_2=\n"
			"persist.rild.nitz_short_ons_3=\n"
			"persist.radio.rat_on=combine\n"
			"ril.subscription.types=NV,RUIM\n"
			"DEVICE_PROVISIONED=1\n"
			"# Start in cdma mode\n"
			"# Motorola set later\n"
			"#ro.telephony.default_network=5\n"
			"\n"
			"debug.sf.hw=1\n"
			"debug.egl.hw=1\n"
			"persist.hwc.mdpcomp.enable=true\n"
			"debug.mdpcomp.logs=0\n"
			"dev.pm.dyn_samplingrate=1\n"
			"persist.demo.hdmirotationlock=false\n"
			"debug.enable.sglscale=1\n"
			"\n"
			"#ro.hdmi.enable=true\n"
			"#tunnel.decode=true\n"
			"#tunnel.audiovideo.decode=true\n"
			"#lpa.decode=false\n"
			"#lpa.use-stagefright=true\n"
			"#persist.speaker.prot.enable=false\n"
			"\n"
			"#\n"
			"# system props for the cne module\n"
			"#\n"
			"persist.cne.feature=0\n"
			"\n"
			"\n"
			"#\n"
			"# system props for the iwlan module\n"
			"#\n"
			"persist.data.iwlan.enable=false\n"
			"\n"
			"#system props for the MM modules\n"
			"media.stagefright.enable-player=true\n"
			"media.stagefright.enable-http=true\n"
			"media.stagefright.enable-aac=true\n"
			"media.stagefright.enable-qcp=true\n"
			"media.stagefright.enable-fma2dp=true\n"
			"media.stagefright.enable-scan=true\n"
			"media.msm8939hw=0\n"
			"media.msm8929hw=0\n"
			"mmp.enable.3g2=true\n"
			"media.aac_51_output_enabled=true\n"
			"#codecs: DivX DivXHD AVI AC3 ASF AAC QCP DTS 3G2 MP2TS FLAC\n"
			"mm.enable.qcom_parser=3314291\n"
			"\n"
			"# Default to AwesomePlayer\n"
			"media.stagefright.use-awesome=false\n"
			"\n"
			"#\n"
			"# system props for the data modules\n"
			"#\n"
			"ro.use_data_netmgrd=true\n"
			"persist.data.netmgrd.qos.enable=true\n"
			"\n"
			"#system props for time-services\n"
			"persist.timed.enable=true\n"
			"\n"
			"#\n"
			"# system prop for opengles version\n"
			"#\n"
			"# 196608 is decimal for 0x30000 to report version 3\n"
			"ro.opengles.version=196608\n"
			"\n"
			"# System property for cabl\n"
			"ro.qualcomm.cabl=0\n"
			"\n"
			"#\n"
			"# System props for telephony\n"
			"# System prop to turn on CdmaLTEPhone always\n"
			"# Motorola default to 0\n"
			"telephony.lteOnCdmaDevice=0\n"
			"#\n"
			"# System props for bluetooh\n"
			"# System prop to turn on hfp client\n"
			"bluetooth.hfp.client=1\n"
			"\n"
			"#Simulate sdcard on /data/media\n"
			"#\n"
			"persist.fuse_sdcard=true\n"
			"\n"
			"#\n"
			"#snapdragon value add features\n"
			"#\n"
			"ro.qc.sdk.audio.ssr=false\n"
			"##fluencetype can be \"fluence\" or \"fluencepro\" or \"none\"\n"
			"ro.qc.sdk.audio.fluencetype=fluence\n"
			"persist.audio.fluence.voicecall=true\n"
			"persist.audio.fluence.voicerec=false\n"
			"persist.audio.fluence.audiorec=false\n"
			"persist.audio.fluence.speaker=false\n"
			"persist.audio.fluence.mode=endfire\n"
			"ro.config.vc_call_vol_steps=8\n"
			"# Tone generator maximum volume be between 0 and 100 (0dB)\n"
			"ro.audio.ringbeep_volume=73\n"
			"#Buffer size in kbytes for compress offload playback\n"
			"audio.offload.buffer.size.kb=240\n"
			"#Minimum duration for offload playback in secs\n"
			"audio.offload.min.duration.secs=30\n"
			"# Motorola enable offload audio playback\n"
			"audio.offload.disable=0\n"
			"#Enable offload audio video playback by default\n"
			"av.offload.enable=true\n"
			"#enable voice path for PCM VoIP by default\n"
			"use.voice.path.for.pcm.voip=false\n"
			"#\n"
			"#System property for FM transmitter\n"
			"#\n"
			"ro.fm.transmitter=false\n"
			"#enable dsp gapless mode by default\n"
			"audio.offload.gapless.enabled=true\n"
			"\n"
			"#Audio voice concurrency related flags\n"
			"voice.playback.conc.disabled=true\n"
			"voice.record.conc.disabled=true\n"
			"voice.voip.conc.disabled=true\n"
			"\n"
			"#property to enable user to access Google WFD settings\n"
			"persist.debug.wfd.enable=0\n"
			"#propery to enable VDS WFD solution\n"
			"persist.hwc.enable_vds=0\n"
			"\n"
			"#selects CoreSight configuration to enable\n"
			"persist.debug.coresight.config=stm-events\n"
			"\n"
			"#property to enable narrow search range for video encoding\n"
			"vidc.enc.narrow.searchrange=1\n"
			"\n"
			"#property to enable DS2 dap\n"
			"audio.dolby.ds2.enabled=true\n"
			"\n"
			"#Trim properties\n"
			"ro.sys.fw.use_trim_settings=true\n"
			"ro.sys.fw.empty_app_percent=50\n"
			"ro.sys.fw.trim_empty_percent=100\n"
			"ro.sys.fw.trim_cache_percent=100\n"
			"ro.sys.fw.trim_enable_memory=1073741824\n"
			"\n"
			"#Factory Reset Protection\n"
			"#ro.frp.pst=/dev/block/bootdevice/by-name/config\n"
			"\n"
			"#min/max cpu in core control\n"
			"ro.core_ctl_min_cpu=2\n"
			"ro.core_ctl_max_cpu=4\n"
			"\n"
			"#\n"
			"# ADDITIONAL_BUILD_PROPERTIES\n"
			"#\n"
			"ro.build.version.full=Blur_Version.24.221.19.osprey_retus_2gb.retus.en.US\n"
			"ro.mot.build.customerid=retus\n"
			"ro.mot.build.version.sdk_int=24\n"
			"ro.mot.build.product.increment=221\n"
			"ro.mot.build.version.release=24.221\n"
			"ro.product.display=Moto G\n"
			"ro.persist.qcapb=0\n"
			"ro.build.version.qcom=AU_LINUX_ANDROID_LA.BR.1.1.3_RB1.05.01.00.032.015\n"
			"telephony.lteOnCdmaDevice=0\n"
			"ro.telephony.default_network=9\n"
			"persist.mot.gps.assisted=false\n"
			"net.tethering.noprovisioning=true\n"
			"ro.config.low_ram=false\n"
			"ro.com.android.dataroaming=false\n"
			"ro.media.enc.aud.fileformat=amr\n"
			"ro.media.enc.aud.codec=amrnb\n"
			"ro.config.ringtone=Moto.ogg\n"
			"ro.config.notification_sound=Moto.ogg\n"
			"ro.config.alarm_alert=Oxygen.ogg\n"
			"ro.partial.display=false\n"
			"ro.radio.imei.sv=10\n"
			"persist.camera.video.hdr=record\n"
			"ro.vendor.extension_library=libqti-perfd-client.so\n"
			"persist.radio.apm_sim_not_pwdn=1\n"
			"ro.usb.mtp=2e82\n"
			"ro.usb.mtp_adb=2e76\n"
			"ro.usb.ptp=2e83\n"
			"ro.usb.ptp_adb=2e84\n"
			"ro.usb.bpt=2ec1\n"
			"ro.usb.bpt_adb=2ec5\n"
			"ro.usb.bpteth=2ec3\n"
			"ro.usb.bpteth_adb=2ec6\n"
			"ro.bug2go.magickeys=24,26\n"
			"persist.sys.ssr.restart_level=ALL_ENABLE\n"
			"persist.sys.qc.sub.rdump.on=1\n"
			"persist.data.qmi.adb_logmask=0\n"
			"persist.sys.qc.sub.rdump.max=3\n"
			"persist.radio.no_wait_for_card=1\n"
			"persist.radio.relay_oprt_change=1\n"
			"persist.radio.dfr_mode_set=1\n"
			"persist.qcril_uim_vcc_feature=1\n"
			"persist.radio.msgtunnel.start=true\n"
			"persist.radio.oem_ind_to_both=false\n"
			"ro.data.large_tcp_window_size=true\n"
			"persist.esdfs_sdcard=true\n"
			"persist.mot.gps.conf.from.sim=true\n"
			"qcom.bt.le_dev_pwr_class=1\n"
			"ro.bluetooth.hfp.ver=1.6\n"
			"ro.qualcomm.bt.hci_transport=smd\n"
			"persist.mot.gps.smart_battery=1\n"
			"ro.frp.pst=/dev/block/bootdevice/by-name/frp\n"
			"ro.cpu0.cpu_max_freq=10485760\n"
			"ro.cpu4.cpu_max_freq=10485760\n"
			"ro.MAX_HIDDEN_APPS=12\n"
			"dalvik.vm.heapstartsize=8m\n"
			"dalvik.vm.heapgrowthlimit=96m\n"
			"dalvik.vm.heapsize=256m\n"
			"dalvik.vm.heaptargetutilization=0.75\n"
			"dalvik.vm.heapminfree=2m\n"
			"dalvik.vm.heapmaxfree=8m\n"
			"ro.sf.lcd_density=320\n"
			"persist.audio.calfile0=/etc/acdbdata/Bluetooth_cal.acdb\n"
			"persist.audio.calfile1=/etc/acdbdata/General_cal.acdb\n"
			"persist.audio.calfile2=/etc/acdbdata/Global_cal.acdb\n"
			"persist.audio.calfile3=/etc/acdbdata/Handset_cal.acdb\n"
			"persist.audio.calfile4=/etc/acdbdata/Hdmi_cal.acdb\n"
			"persist.audio.calfile5=/etc/acdbdata/Headset_cal.acdb\n"
			"persist.audio.calfile6=/etc/acdbdata/Speaker_cal.acdb\n"
			"ro.audio.fm_max_volume=5169\n"
			"persist.radio.apn_delay=5000\n"
			"persist.sys.media.use-awesome=false\n"
			"audio.offload.disable=0\n"
			"audio.offload.pcm.16bit.enable=false\n"
			"audio.offload.pcm.24bit.enable=false\n"
			"audio.offload.gapless.enabled=false\n"
			"av.offload.enable=false\n"
			"mm.enable.qcom_parser=4643\n"
			"persist.radio.mot_ecc_enabled=1\n"
			"persist.radio.mot_ecc_custid=common\n"
			"keyguard.no_require_sim=true\n"
			"drm.service.enabled=true\n"
			"mdc_initial_max_retry=10\n"
			"ro.adb.secure=1\n"
			"ro.com.google.clientidbase=android-motorola\n"
			"ro.com.google.clientidbase.ms=android-motorola\n"
			"ro.com.google.clientidbase.am=android-motorola\n"
			"ro.com.google.clientidbase.gmm=android-motorola\n"
			"ro.com.google.clientidbase.yt=android-motorola\n"
			"ro.url.legal=http://www.google.com/intl/%s/mobile/android/basic/phone-legal.html\n"
			"ro.url.legal.android_privacy=http://www.google.com/intl/%s/mobile/android/basic/privacy.html\n"
			"ro.setupwizard.mode=OPTIONAL\n"
			"ro.com.google.gmsversion=6.0_r1\n"
			"ro.carrier=unknown\n"
			"persist.sys.dalvik.vm.lib.2=libart\n"
			"dalvik.vm.isa.arm.variant=cortex-a53\n"
			"dalvik.vm.isa.arm.features=default\n"
			"net.bt.name=Android\n"
			"dalvik.vm.stack-trace-file=/data/anr/traces.txt\n"
			"persist.gps.qc_nlp_in_use=0\n"
			"ro.gps.agps_provider=1\n"
			"ro.pip.gated=0\n"
			"ro.expect.recovery_id=0x75f1b8dce5652228c376ee763ae81364930590e2000000000000000000000000\n"
			"\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "7\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 1,
		.content = "\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/all_time_in_state",
		.size = 31,
		.content = "freq\t\tcpu0\t\tcpu1\t\tcpu2\t\tcpu3\t\t\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/current_in_state",
		.size = 528,
		.content =
			"CPU0:200000=23670 400000=37830 533333=47240 800000=65800 998400=104550 1094400=113830 1152000=128540 1209600=142800 1363200=157750 \n"
			"CPU1:200000=23670 400000=37830 533333=47240 800000=65800 998400=104550 1094400=113830 1152000=128540 1209600=142800 1363200=157750 \n"
			"CPU2:200000=23670 400000=37830 533333=47240 800000=65800 998400=104550 1094400=113830 1152000=128540 1209600=142800 1363200=157750 \n"
			"CPU3:200000=23670 400000=37830 533333=47240 800000=65800 998400=104550 1094400=113830 1152000=128540 1209600=142800 1363200=157750 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_driver",
		.size = 9,
		.content = "msm_idle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_governor_ro",
		.size = 5,
		.content = "menu\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1363200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "200000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies",
		.size = 68,
		.content = "200000 400000 533333 800000 998400 1094400 1152000 1209600 1363200 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1363200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state",
		.size = 88,
		.content =
			"200000 0\n"
			"400000 0\n"
			"533333 0\n"
			"800000 0\n"
			"998400 0\n"
			"1094400 0\n"
			"1152000 0\n"
			"1209600 0\n"
			"1363200 2118\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/total_trans",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings",
		.size = 3,
		.content = "01\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1363200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "200000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_frequencies",
		.size = 68,
		.content = "200000 400000 533333 800000 998400 1094400 1152000 1209600 1363200 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1363200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/time_in_state",
		.size = 88,
		.content =
			"200000 0\n"
			"400000 0\n"
			"533333 0\n"
			"800000 0\n"
			"998400 0\n"
			"1094400 0\n"
			"1152000 0\n"
			"1209600 0\n"
			"1363200 2354\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/total_trans",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings_list",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings",
		.size = 3,
		.content = "02\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1363200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "200000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_frequencies",
		.size = 68,
		.content = "200000 400000 533333 800000 998400 1094400 1152000 1209600 1363200 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1363200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/time_in_state",
		.size = 88,
		.content =
			"200000 0\n"
			"400000 0\n"
			"533333 0\n"
			"800000 0\n"
			"998400 0\n"
			"1094400 0\n"
			"1152000 0\n"
			"1209600 0\n"
			"1363200 2600\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/total_trans",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_id",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings_list",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings",
		.size = 3,
		.content = "04\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_max_freq",
		.size = 8,
		.content = "1363200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "200000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/cpuinfo_transition_latency",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_frequencies",
		.size = 68,
		.content = "200000 400000 533333 800000 998400 1094400 1152000 1209600 1363200 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "interactive ondemand userspace powersave performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_cur_freq",
		.size = 8,
		.content = "1363200\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_driver",
		.size = 4,
		.content = "msm\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/time_in_state",
		.size = 88,
		.content =
			"200000 0\n"
			"400000 0\n"
			"533333 0\n"
			"800000 0\n"
			"998400 2\n"
			"1094400 0\n"
			"1152000 0\n"
			"1209600 4\n"
			"1363200 2853\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/cpufreq/stats/total_trans",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/core_id",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings_list",
		.size = 2,
		.content = "3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu3/topology/thread_siblings",
		.size = 3,
		.content = "08\n",
	},
	{ NULL },
};

#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "DEVICE_PROVISIONED",
		.value = "1",
	},
	{
		.key = "audio.dolby.ds2.enabled",
		.value = "true",
	},
	{
		.key = "audio.offload.buffer.size.kb",
		.value = "240",
	},
	{
		.key = "audio.offload.disable",
		.value = "0",
	},
	{
		.key = "audio.offload.gapless.enabled",
		.value = "false",
	},
	{
		.key = "audio.offload.min.duration.secs",
		.value = "30",
	},
	{
		.key = "audio.offload.pcm.16bit.enable",
		.value = "false",
	},
	{
		.key = "audio.offload.pcm.24bit.enable",
		.value = "false",
	},
	{
		.key = "av.offload.enable",
		.value = "false",
	},
	{
		.key = "bluetooth.hfp.client",
		.value = "1",
	},
	{
		.key = "camera2.portability.force_api",
		.value = "1",
	},
	{
		.key = "dalvik.vm.dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.dex2oat-Xmx",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "96m",
	},
	{
		.key = "dalvik.vm.heapmaxfree",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heapminfree",
		.value = "2m",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "256m",
	},
	{
		.key = "dalvik.vm.heapstartsize",
		.value = "8m",
	},
	{
		.key = "dalvik.vm.heaptargetutilization",
		.value = "0.75",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xmx",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.isa.arm.features",
		.value = "default",
	},
	{
		.key = "dalvik.vm.isa.arm.variant",
		.value = "cortex-a53",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "debug.atrace.tags.enableflags",
		.value = "0",
	},
	{
		.key = "debug.camera.front_present",
		.value = "s5k5e2",
	},
	{
		.key = "debug.camera.rear_present",
		.value = "imx214",
	},
	{
		.key = "debug.egl.hw",
		.value = "1",
	},
	{
		.key = "debug.enable.sglscale",
		.value = "1",
	},
	{
		.key = "debug.force_rtl",
		.value = "0",
	},
	{
		.key = "debug.mdpcomp.logs",
		.value = "0",
	},
	{
		.key = "debug.sf.hw",
		.value = "1",
	},
	{
		.key = "dev.pm.dyn_samplingrate",
		.value = "1",
	},
	{
		.key = "drm.service.enabled",
		.value = "true",
	},
	{
		.key = "dtv.hw.status",
		.value = "unavailable",
	},
	{
		.key = "gsm.current.phone-type",
		.value = "1",
	},
	{
		.key = "gsm.network.type",
		.value = "Unknown",
	},
	{
		.key = "gsm.operator.alpha",
		.value = "",
	},
	{
		.key = "gsm.operator.iso-country",
		.value = "",
	},
	{
		.key = "gsm.operator.isroaming",
		.value = "false",
	},
	{
		.key = "gsm.operator.numeric",
		.value = "",
	},
	{
		.key = "gsm.sim.operator.alpha",
		.value = "",
	},
	{
		.key = "gsm.sim.operator.iso-country",
		.value = "",
	},
	{
		.key = "gsm.sim.operator.numeric",
		.value = "",
	},
	{
		.key = "gsm.sim.state",
		.value = "ABSENT",
	},
	{
		.key = "gsm.version.ril-impl",
		.value = "Qualcomm RIL 1.0",
	},
	{
		.key = "hw.cabl.version",
		.value = "1.1.20130401",
	},
	{
		.key = "hw.cabl.yuv",
		.value = "1",
	},
	{
		.key = "hw.pp.cfg",
		.value = "/data/misc/display/pp_data.cfg",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.akmd09912",
		.value = "running",
	},
	{
		.key = "init.svc.atfwd",
		.value = "running",
	},
	{
		.key = "init.svc.atvc",
		.value = "stopped",
	},
	{
		.key = "init.svc.atvc_core",
		.value = "stopped",
	},
	{
		.key = "init.svc.audiod",
		.value = "running",
	},
	{
		.key = "init.svc.bms-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.bootanim",
		.value = "running",
	},
	{
		.key = "init.svc.config_bluetooth",
		.value = "stopped",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.dropboxd",
		.value = "running",
	},
	{
		.key = "init.svc.esdpll",
		.value = "running",
	},
	{
		.key = "init.svc.flash_recovery",
		.value = "stopped",
	},
	{
		.key = "init.svc.gatekeeperd",
		.value = "running",
	},
	{
		.key = "init.svc.healthd",
		.value = "running",
	},
	{
		.key = "init.svc.hw_revs",
		.value = "stopped",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.irsc_util",
		.value = "stopped",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.lmkd",
		.value = "running",
	},
	{
		.key = "init.svc.loc_launcher",
		.value = "running",
	},
	{
		.key = "init.svc.logd",
		.value = "running",
	},
	{
		.key = "init.svc.logd-reinit",
		.value = "stopped",
	},
	{
		.key = "init.svc.mbm_spy",
		.value = "running",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.mmi-block-perm",
		.value = "stopped",
	},
	{
		.key = "init.svc.mmi-boot-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.mmi-dtv-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.mmi-touch-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.mmi-usb-sh",
		.value = "running",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.netmgrd",
		.value = "running",
	},
	{
		.key = "init.svc.p2p_supplicant",
		.value = "running",
	},
	{
		.key = "init.svc.ppd",
		.value = "running",
	},
	{
		.key = "init.svc.qcamerasvr",
		.value = "running",
	},
	{
		.key = "init.svc.qcom-c_core-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-c_main-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qcom-sh",
		.value = "stopped",
	},
	{
		.key = "init.svc.qmuxd",
		.value = "running",
	},
	{
		.key = "init.svc.qseecomd",
		.value = "running",
	},
	{
		.key = "init.svc.rfs_access",
		.value = "running",
	},
	{
		.key = "init.svc.ril-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.rmt_storage",
		.value = "running",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.ss_rdump",
		.value = "running",
	},
	{
		.key = "init.svc.ssr_setup",
		.value = "stopped",
	},
	{
		.key = "init.svc.stml0xx",
		.value = "stopped",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.tcmd",
		.value = "running",
	},
	{
		.key = "init.svc.thermal-engine",
		.value = "running",
	},
	{
		.key = "init.svc.time_daemon",
		.value = "running",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.usb_uicc_daemon",
		.value = "running",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.wcnss-service",
		.value = "running",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "installd.post_fs_data_ready",
		.value = "1",
	},
	{
		.key = "keyguard.no_require_sim",
		.value = "true",
	},
	{
		.key = "mdc_initial_max_retry",
		.value = "10",
	},
	{
		.key = "media.aac_51_output_enabled",
		.value = "true",
	},
	{
		.key = "media.msm8929hw",
		.value = "0",
	},
	{
		.key = "media.msm8939hw",
		.value = "0",
	},
	{
		.key = "media.stagefright.enable-aac",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-fma2dp",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-http",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-player",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-qcp",
		.value = "true",
	},
	{
		.key = "media.stagefright.enable-scan",
		.value = "true",
	},
	{
		.key = "media.stagefright.use-awesome",
		.value = "false",
	},
	{
		.key = "mm.enable.qcom_parser",
		.value = "4643",
	},
	{
		.key = "mmp.enable.3g2",
		.value = "true",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.dns2",
	},
	{
		.key = "net.dns1",
		.value = "208.67.222.222",
	},
	{
		.key = "net.dns2",
		.value = "208.67.220.220",
	},
	{
		.key = "net.hostname",
		.value = "android-a5d90b56e4f705a9",
	},
	{
		.key = "net.qtaguid_enabled",
		.value = "1",
	},
	{
		.key = "net.tcp.default_init_rwnd",
		.value = "60",
	},
	{
		.key = "net.tethering.noprovisioning",
		.value = "true",
	},
	{
		.key = "net.tethering.on",
		.value = "0",
	},
	{
		.key = "net.wifi.netid",
		.value = "100",
	},
	{
		.key = "persist.atvc.adb",
		.value = "0",
	},
	{
		.key = "persist.atvc.allow_all_core",
		.value = "0",
	},
	{
		.key = "persist.atvc.allow_res_core",
		.value = "0",
	},
	{
		.key = "persist.atvc.allow_res_panic",
		.value = "0",
	},
	{
		.key = "persist.atvc.log",
		.value = "0",
	},
	{
		.key = "persist.atvc.netmon_ih",
		.value = "0",
	},
	{
		.key = "persist.atvc.netmon_usb",
		.value = "0",
	},
	{
		.key = "persist.atvc.simswap",
		.value = "0",
	},
	{
		.key = "persist.atvc.uid",
		.value = "",
	},
	{
		.key = "persist.audio.calfile0",
		.value = "/etc/acdbdata/Bluetooth_cal.acdb",
	},
	{
		.key = "persist.audio.calfile1",
		.value = "/etc/acdbdata/General_cal.acdb",
	},
	{
		.key = "persist.audio.calfile2",
		.value = "/etc/acdbdata/Global_cal.acdb",
	},
	{
		.key = "persist.audio.calfile3",
		.value = "/etc/acdbdata/Handset_cal.acdb",
	},
	{
		.key = "persist.audio.calfile4",
		.value = "/etc/acdbdata/Hdmi_cal.acdb",
	},
	{
		.key = "persist.audio.calfile5",
		.value = "/etc/acdbdata/Headset_cal.acdb",
	},
	{
		.key = "persist.audio.calfile6",
		.value = "/etc/acdbdata/Speaker_cal.acdb",
	},
	{
		.key = "persist.audio.fluence.audiorec",
		.value = "false",
	},
	{
		.key = "persist.audio.fluence.mode",
		.value = "endfire",
	},
	{
		.key = "persist.audio.fluence.speaker",
		.value = "false",
	},
	{
		.key = "persist.audio.fluence.voicecall",
		.value = "true",
	},
	{
		.key = "persist.audio.fluence.voicerec",
		.value = "false",
	},
	{
		.key = "persist.camera.video.hdr",
		.value = "record",
	},
	{
		.key = "persist.cne.feature",
		.value = "0",
	},
	{
		.key = "persist.data.iwlan.enable",
		.value = "false",
	},
	{
		.key = "persist.data.netmgrd.qos.enable",
		.value = "true",
	},
	{
		.key = "persist.data.qmi.adb_logmask",
		.value = "0",
	},
	{
		.key = "persist.debug.coresight.config",
		.value = "stm-events",
	},
	{
		.key = "persist.debug.wfd.enable",
		.value = "0",
	},
	{
		.key = "persist.demo.hdmirotationlock",
		.value = "false",
	},
	{
		.key = "persist.esdfs_sdcard",
		.value = "true",
	},
	{
		.key = "persist.fuse_sdcard",
		.value = "true",
	},
	{
		.key = "persist.gps.qc_nlp_in_use",
		.value = "0",
	},
	{
		.key = "persist.hwc.enable_vds",
		.value = "0",
	},
	{
		.key = "persist.hwc.mdpcomp.enable",
		.value = "true",
	},
	{
		.key = "persist.mot.gps.assisted",
		.value = "false",
	},
	{
		.key = "persist.mot.gps.conf.from.sim",
		.value = "true",
	},
	{
		.key = "persist.mot.gps.smart_battery",
		.value = "1",
	},
	{
		.key = "persist.mot.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "persist.qcril_uim_vcc_feature",
		.value = "1",
	},
	{
		.key = "persist.qe",
		.value = "qe 0/0",
	},
	{
		.key = "persist.radio.adb_log_on",
		.value = "0",
	},
	{
		.key = "persist.radio.apm_sim_not_pwdn",
		.value = "1",
	},
	{
		.key = "persist.radio.apn_delay",
		.value = "5000",
	},
	{
		.key = "persist.radio.dfr_mode_set",
		.value = "1",
	},
	{
		.key = "persist.radio.eons.enabled",
		.value = "false",
	},
	{
		.key = "persist.radio.mot_ecc_custid",
		.value = "common",
	},
	{
		.key = "persist.radio.mot_ecc_enabled",
		.value = "1",
	},
	{
		.key = "persist.radio.msgtunnel.start",
		.value = "true",
	},
	{
		.key = "persist.radio.nitz_lons_0_0",
		.value = "AT&T",
	},
	{
		.key = "persist.radio.nitz_lons_1_0",
		.value = "",
	},
	{
		.key = "persist.radio.nitz_lons_2_0",
		.value = "",
	},
	{
		.key = "persist.radio.nitz_lons_3_0",
		.value = "",
	},
	{
		.key = "persist.radio.nitz_plmn_0",
		.value = "310 410",
	},
	{
		.key = "persist.radio.nitz_sons_0_0",
		.value = "AT&T",
	},
	{
		.key = "persist.radio.nitz_sons_1_0",
		.value = "",
	},
	{
		.key = "persist.radio.nitz_sons_2_0",
		.value = "",
	},
	{
		.key = "persist.radio.nitz_sons_3_0",
		.value = "",
	},
	{
		.key = "persist.radio.no_wait_for_card",
		.value = "1",
	},
	{
		.key = "persist.radio.oem_ind_to_both",
		.value = "false",
	},
	{
		.key = "persist.radio.rat_on",
		.value = "combine",
	},
	{
		.key = "persist.radio.relay_oprt_change",
		.value = "1",
	},
	{
		.key = "persist.radio.ril_payload_on",
		.value = "0",
	},
	{
		.key = "persist.radio.sglte_target",
		.value = "0",
	},
	{
		.key = "persist.rild.nitz_long_ons_0",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_long_ons_1",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_long_ons_2",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_long_ons_3",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_plmn",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_0",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_1",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_2",
		.value = "",
	},
	{
		.key = "persist.rild.nitz_short_ons_3",
		.value = "",
	},
	{
		.key = "persist.sys.dalvik.vm.lib.2",
		.value = "libart.so",
	},
	{
		.key = "persist.sys.locale",
		.value = "en-US",
	},
	{
		.key = "persist.sys.media.use-awesome",
		.value = "false",
	},
	{
		.key = "persist.sys.phonelock.mode",
		.value = "0",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.qc.sub.rdump.max",
		.value = "3",
	},
	{
		.key = "persist.sys.qc.sub.rdump.on",
		.value = "1",
	},
	{
		.key = "persist.sys.ssr.restart_level",
		.value = "ALL_ENABLE",
	},
	{
		.key = "persist.sys.timezone",
		.value = "America/Los_Angeles",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "persist.timed.enable",
		.value = "true",
	},
	{
		.key = "qcom.bt.le_dev_pwr_class",
		.value = "1",
	},
	{
		.key = "ril.baseband.config.ver_num",
		.value = "02.58",
	},
	{
		.key = "ril.baseband.config.version",
		.value = "OSPREY_RETUSA_AWS_CUST",
	},
	{
		.key = "ril.ecclist",
		.value = "112,911,000,08,110,999,118,119,190,066,060,*911,#911",
	},
	{
		.key = "ril.ecclist1",
		.value = "112,911,000,08,110,999,118,119,190,066,060,*911,#911",
	},
	{
		.key = "ril.lte.bc.config",
		.value = "65626",
	},
	{
		.key = "ril.qcril_pre_init_lock_held",
		.value = "0",
	},
	{
		.key = "ril.radio.ctbk_inst",
		.value = "290",
	},
	{
		.key = "ril.radio.ctbk_val",
		.value = "1,0,0,0,0,0,1,0,0,0,0,0",
	},
	{
		.key = "ril.subscription.types",
		.value = "NV,RUIM",
	},
	{
		.key = "rild.libargs",
		.value = "-d /dev/smd0",
	},
	{
		.key = "rild.libpath",
		.value = "/system/vendor/lib/libril-qc-qmi-1.so",
	},
	{
		.key = "rmtfs.msm_fsg",
		.value = "0",
	},
	{
		.key = "ro.MAX_HIDDEN_APPS",
		.value = "12",
	},
	{
		.key = "ro.adb.secure",
		.value = "1",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.audio.fm_max_volume",
		.value = "5169",
	},
	{
		.key = "ro.audio.ringbeep_volume",
		.value = "73",
	},
	{
		.key = "ro.baseband",
		.value = "msm",
	},
	{
		.key = "ro.bluetooth.hfp.ver",
		.value = "1.6",
	},
	{
		.key = "ro.board.platform",
		.value = "msm8916",
	},
	{
		.key = "ro.boot.baseband",
		.value = "msm",
	},
	{
		.key = "ro.boot.bl_state",
		.value = "1",
	},
	{
		.key = "ro.boot.bootdevice",
		.value = "7824900.sdhci",
	},
	{
		.key = "ro.boot.bootloader",
		.value = "0x80CF",
	},
	{
		.key = "ro.boot.bootreason",
		.value = "reboot",
	},
	{
		.key = "ro.boot.btmacaddr",
		.value = "24DA9B682D48",
	},
	{
		.key = "ro.boot.carrier",
		.value = "retus",
	},
	{
		.key = "ro.boot.cid",
		.value = "0x9",
	},
	{
		.key = "ro.boot.device",
		.value = "osprey",
	},
	{
		.key = "ro.boot.emmc",
		.value = "true",
	},
	{
		.key = "ro.boot.fsg-id",
		.value = "",
	},
	{
		.key = "ro.boot.hardware",
		.value = "qcom",
	},
	{
		.key = "ro.boot.hardware.sku",
		.value = "XT1540",
	},
	{
		.key = "ro.boot.hwrev",
		.value = "0x82B0",
	},
	{
		.key = "ro.boot.mode",
		.value = "normal",
	},
	{
		.key = "ro.boot.powerup_reason",
		.value = "0x00004000",
	},
	{
		.key = "ro.boot.radio",
		.value = "0x1",
	},
	{
		.key = "ro.boot.secure_hardware",
		.value = "1",
	},
	{
		.key = "ro.boot.serialno",
		.value = "ZY222XF4QK",
	},
	{
		.key = "ro.boot.wifimacaddr",
		.value = "24:DA:9B:68:2D:49,24:DA:9B:68:2D:4A",
	},
	{
		.key = "ro.boot.write_protect",
		.value = "1",
	},
	{
		.key = "ro.bootimage.build.date",
		.value = "Thu Apr 6 09:25:14 CDT 2017",
	},
	{
		.key = "ro.bootimage.build.date.utc",
		.value = "1491488714",
	},
	{
		.key = "ro.bootimage.build.fingerprint",
		.value = "motorola/osprey_retus_2gb/osprey_u2:6.0/MPIS24.65-25.1-19/14:user/release-keys",
	},
	{
		.key = "ro.bootloader",
		.value = "0x80CF",
	},
	{
		.key = "ro.bootmode",
		.value = "normal",
	},
	{
		.key = "ro.bootreason",
		.value = "reboot",
	},
	{
		.key = "ro.bug2go.magickeys",
		.value = "24,26",
	},
	{
		.key = "ro.build.characteristics",
		.value = "default",
	},
	{
		.key = "ro.build.date",
		.value = "Thu Apr  6 09:22:04 CDT 2017",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1491488524",
	},
	{
		.key = "ro.build.description",
		.value = "osprey_retus_2gb-user 6.0 MPIS24.65-25.1-19 14 release-keys",
	},
	{
		.key = "ro.build.display.id",
		.value = "MPIS24.65-25.1-19",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "motorola/osprey_retus_2gb/osprey_u2:6.0/MPIS24.65-25.1-19/14:user/release-keys",
	},
	{
		.key = "ro.build.flavor",
		.value = "osprey_retus_2gb-user",
	},
	{
		.key = "ro.build.host",
		.value = "ilclbld87",
	},
	{
		.key = "ro.build.id",
		.value = "MPIS24.65-25.1-19",
	},
	{
		.key = "ro.build.product",
		.value = "osprey_u2",
	},
	{
		.key = "ro.build.tags",
		.value = "release-keys",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.user",
		.value = "hudsoncm",
	},
	{
		.key = "ro.build.version.all_codenames",
		.value = "REL",
	},
	{
		.key = "ro.build.version.base_os",
		.value = "motorola/osprey_retus_2gb/osprey_u2:6.0/MPI24.65-25.1/1:user/release-keys",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.full",
		.value = "Blur_Version.24.221.19.osprey_retus_2gb.retus.en.US",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "14",
	},
	{
		.key = "ro.build.version.preview_sdk",
		.value = "0",
	},
	{
		.key = "ro.build.version.qcom",
		.value = "AU_LINUX_ANDROID_LA.BR.1.1.3_RB1.05.01.00.032.015",
	},
	{
		.key = "ro.build.version.release",
		.value = "6.0",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "23",
	},
	{
		.key = "ro.build.version.security_patch",
		.value = "2017-04-01",
	},
	{
		.key = "ro.carrier",
		.value = "retus",
	},
	{
		.key = "ro.com.android.dataroaming",
		.value = "false",
	},
	{
		.key = "ro.com.google.clientidbase",
		.value = "android-motorola",
	},
	{
		.key = "ro.com.google.clientidbase.am",
		.value = "android-motorola",
	},
	{
		.key = "ro.com.google.clientidbase.gmm",
		.value = "android-motorola",
	},
	{
		.key = "ro.com.google.clientidbase.ms",
		.value = "android-motorola",
	},
	{
		.key = "ro.com.google.clientidbase.yt",
		.value = "android-motorola",
	},
	{
		.key = "ro.com.google.gmsversion",
		.value = "6.0_r1",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "Oxygen.ogg",
	},
	{
		.key = "ro.config.low_ram",
		.value = "false",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "Moto.ogg",
	},
	{
		.key = "ro.config.ringtone",
		.value = "Moto.ogg",
	},
	{
		.key = "ro.config.vc_call_vol_steps",
		.value = "8",
	},
	{
		.key = "ro.core_ctl_max_cpu",
		.value = "4",
	},
	{
		.key = "ro.core_ctl_min_cpu",
		.value = "2",
	},
	{
		.key = "ro.cpu0.cpu_max_freq",
		.value = "10485760",
	},
	{
		.key = "ro.cpu4.cpu_max_freq",
		.value = "10485760",
	},
	{
		.key = "ro.crypto.state",
		.value = "unencrypted",
	},
	{
		.key = "ro.dalvik.vm.native.bridge",
		.value = "0",
	},
	{
		.key = "ro.data.large_tcp_window_size",
		.value = "true",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.expect.recovery_id",
		.value = "0x75f1b8dce5652228c376ee763ae81364930590e2000000000000000000000000",
	},
	{
		.key = "ro.fm.transmitter",
		.value = "false",
	},
	{
		.key = "ro.frp.pst",
		.value = "/dev/block/bootdevice/by-name/frp",
	},
	{
		.key = "ro.gps.agps_provider",
		.value = "1",
	},
	{
		.key = "ro.hardware",
		.value = "qcom",
	},
	{
		.key = "ro.hw.device",
		.value = "osprey",
	},
	{
		.key = "ro.hw.hwrev",
		.value = "0x82B0",
	},
	{
		.key = "ro.hw.radio",
		.value = "0x1",
	},
	{
		.key = "ro.hw.revision",
		.value = "p2b",
	},
	{
		.key = "ro.kick.logcopy",
		.value = "reboot",
	},
	{
		.key = "ro.manufacturedate",
		.value = "Unknown",
	},
	{
		.key = "ro.media.enc.aud.codec",
		.value = "amrnb",
	},
	{
		.key = "ro.media.enc.aud.fileformat",
		.value = "amr",
	},
	{
		.key = "ro.mot.base_buildid",
		.value = "MPI24.65-25.1/1",
	},
	{
		.key = "ro.mot.build.customerid",
		.value = "retus",
	},
	{
		.key = "ro.mot.build.product.increment",
		.value = "221",
	},
	{
		.key = "ro.mot.build.version.release",
		.value = "24.221",
	},
	{
		.key = "ro.mot.build.version.sdk_int",
		.value = "24",
	},
	{
		.key = "ro.opengles.version",
		.value = "196608",
	},
	{
		.key = "ro.partial.display",
		.value = "false",
	},
	{
		.key = "ro.persist.qcapb",
		.value = "0",
	},
	{
		.key = "ro.pip.gated",
		.value = "0",
	},
	{
		.key = "ro.product.board",
		.value = "msm8916",
	},
	{
		.key = "ro.product.brand",
		.value = "motorola",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "armeabi-v7a",
	},
	{
		.key = "ro.product.cpu.abi2",
		.value = "armeabi",
	},
	{
		.key = "ro.product.cpu.abilist",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist32",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist64",
		.value = "",
	},
	{
		.key = "ro.product.device",
		.value = "osprey_u2",
	},
	{
		.key = "ro.product.display",
		.value = "Moto G",
	},
	{
		.key = "ro.product.locale",
		.value = "en-US",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "motorola",
	},
	{
		.key = "ro.product.model",
		.value = "MotoG3",
	},
	{
		.key = "ro.product.name",
		.value = "osprey_retus_2gb",
	},
	{
		.key = "ro.qc.sdk.audio.fluencetype",
		.value = "fluence",
	},
	{
		.key = "ro.qc.sdk.audio.ssr",
		.value = "false",
	},
	{
		.key = "ro.qualcomm.bt.hci_transport",
		.value = "smd",
	},
	{
		.key = "ro.qualcomm.cabl",
		.value = "0",
	},
	{
		.key = "ro.radio.imei.sv",
		.value = "10",
	},
	{
		.key = "ro.revision",
		.value = "p2b0",
	},
	{
		.key = "ro.ril.svdo",
		.value = "false",
	},
	{
		.key = "ro.ril.svlte1x",
		.value = "false",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.serialno",
		.value = "ZY222XF4QK",
	},
	{
		.key = "ro.setupwizard.mode",
		.value = "OPTIONAL",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "320",
	},
	{
		.key = "ro.sys.fw.empty_app_percent",
		.value = "50",
	},
	{
		.key = "ro.sys.fw.trim_cache_percent",
		.value = "100",
	},
	{
		.key = "ro.sys.fw.trim_empty_percent",
		.value = "100",
	},
	{
		.key = "ro.sys.fw.trim_enable_memory",
		.value = "1073741824",
	},
	{
		.key = "ro.sys.fw.use_trim_settings",
		.value = "true",
	},
	{
		.key = "ro.telephony.call_ring.multiple",
		.value = "false",
	},
	{
		.key = "ro.telephony.default_network",
		.value = "9",
	},
	{
		.key = "ro.url.legal",
		.value = "http://www.google.com/intl/%s/mobile/android/basic/phone-legal.html",
	},
	{
		.key = "ro.url.legal.android_privacy",
		.value = "http://www.google.com/intl/%s/mobile/android/basic/privacy.html",
	},
	{
		.key = "ro.usb.bpt",
		.value = "2ec1",
	},
	{
		.key = "ro.usb.bpt_adb",
		.value = "2ec5",
	},
	{
		.key = "ro.usb.bpteth",
		.value = "2ec3",
	},
	{
		.key = "ro.usb.bpteth_adb",
		.value = "2ec6",
	},
	{
		.key = "ro.usb.mtp",
		.value = "2e82",
	},
	{
		.key = "ro.usb.mtp_adb",
		.value = "2e76",
	},
	{
		.key = "ro.usb.ptp",
		.value = "2e83",
	},
	{
		.key = "ro.usb.ptp_adb",
		.value = "2e84",
	},
	{
		.key = "ro.use_data_netmgrd",
		.value = "true",
	},
	{
		.key = "ro.vendor.extension_library",
		.value = "libqti-perfd-client.so",
	},
	{
		.key = "ro.wifi.channels",
		.value = "",
	},
	{
		.key = "ro.zygote",
		.value = "zygote32",
	},
	{
		.key = "security.perf_harden",
		.value = "1",
	},
	{
		.key = "selinux.reload_policy",
		.value = "1",
	},
	{
		.key = "service.bootanim.exit",
		.value = "1",
	},
	{
		.key = "sys.keymaster.loaded",
		.value = "true",
	},
	{
		.key = "sys.listeners.registered",
		.value = "true",
	},
	{
		.key = "sys.oem_unlock_allowed",
		.value = "1",
	},
	{
		.key = "sys.sysctl.extra_free_kbytes",
		.value = "10800",
	},
	{
		.key = "sys.sysctl.tcp_def_init_rwnd",
		.value = "60",
	},
	{
		.key = "sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb.ffs.ready",
		.value = "1",
	},
	{
		.key = "sys.usb.rps_mask",
		.value = "0",
	},
	{
		.key = "sys.usb.state",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb_uicc.enabled",
		.value = "0",
	},
	{
		.key = "tcmd.blan.interface",
		.value = "usb0",
	},
	{
		.key = "telephony.lteOnCdmaDevice",
		.value = "0",
	},
	{
		.key = "use.voice.path.for.pcm.voip",
		.value = "false",
	},
	{
		.key = "vidc.enc.narrow.searchrange",
		.value = "1",
	},
	{
		.key = "voice.playback.conc.disabled",
		.value = "true",
	},
	{
		.key = "voice.record.conc.disabled",
		.value = "true",
	},
	{
		.key = "voice.voip.conc.disabled",
		.value = "true",
	},
	{
		.key = "vold.has_adoptable",
		.value = "1",
	},
	{
		.key = "vold.post_fs_data_done",
		.value = "1",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{
		.key = "wlan.driver.ath",
		.value = "0",
	},
	{
		.key = "wlan.driver.status",
		.value = "ok",
	},
	{ NULL },
};
#endif /* __ANDROID__ */
