{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;
    class function ForVRMLVersion(const Version: TX3DVersion): Boolean; override;

    strict private FFdPoint: TMFVec2f;
    { Internal wrapper for property @link(Point). This wrapper API may change, we advise to access simpler @link(Point) instead. }
    public property FdPoint: TMFVec2f read FFdPoint;
    {  }
    procedure SetPoint(const Value: array of TVector2); overload;
    {  }
    procedure SetPoint(const Value: TVector2List); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TTextureCoordinate2Node_1 ----------------------------------------------- }

procedure TTextureCoordinate2Node_1.SetPoint(const Value: array of TVector2);
begin
  FdPoint.Send(Value);
end;

procedure TTextureCoordinate2Node_1.SetPoint(const Value: TVector2List);
begin
  FdPoint.Send(Value);
end;

class function TTextureCoordinate2Node_1.ForVRMLVersion(const Version: TX3DVersion): Boolean;
begin
  Result := Version.Major <= 1; // parse this node only in VRML 1.0 and Inventor files
end;

class function TTextureCoordinate2Node_1.ClassX3DType: String;
begin
  Result := 'TextureCoordinate2';
end;

procedure TTextureCoordinate2Node_1.CreateNode;
begin
  inherited;

  FFdPoint := TMFVec2f.Create(Self, True, 'point', [Vector2(0, 0)]);
   FdPoint.ChangeAlways := chVisibleVRML1State;
  AddField(FFdPoint);
end;

{$endif read_implementation}
