{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetBackTexture: TAbstractTextureNode;
    procedure SetBackTexture(const Value: TAbstractTextureNode);
    function GetBottomTexture: TAbstractTextureNode;
    procedure SetBottomTexture(const Value: TAbstractTextureNode);
    function GetFrontTexture: TAbstractTextureNode;
    procedure SetFrontTexture(const Value: TAbstractTextureNode);
    function GetLeftTexture: TAbstractTextureNode;
    procedure SetLeftTexture(const Value: TAbstractTextureNode);
    function GetRightTexture: TAbstractTextureNode;
    procedure SetRightTexture(const Value: TAbstractTextureNode);
    function GetTopTexture: TAbstractTextureNode;
    procedure SetTopTexture(const Value: TAbstractTextureNode);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdBackTexture: TSFNode;
    { Internal wrapper for property @link(BackTexture). This wrapper API may change, we advise to access simpler @link(BackTexture) instead. }
    public property FdBackTexture: TSFNode read FFdBackTexture;
    {  }
    property BackTexture: TAbstractTextureNode read GetBackTexture write SetBackTexture;

    strict private FFdBottomTexture: TSFNode;
    { Internal wrapper for property @link(BottomTexture). This wrapper API may change, we advise to access simpler @link(BottomTexture) instead. }
    public property FdBottomTexture: TSFNode read FFdBottomTexture;
    {  }
    property BottomTexture: TAbstractTextureNode read GetBottomTexture write SetBottomTexture;

    strict private FFdFrontTexture: TSFNode;
    { Internal wrapper for property @link(FrontTexture). This wrapper API may change, we advise to access simpler @link(FrontTexture) instead. }
    public property FdFrontTexture: TSFNode read FFdFrontTexture;
    {  }
    property FrontTexture: TAbstractTextureNode read GetFrontTexture write SetFrontTexture;

    strict private FFdLeftTexture: TSFNode;
    { Internal wrapper for property @link(LeftTexture). This wrapper API may change, we advise to access simpler @link(LeftTexture) instead. }
    public property FdLeftTexture: TSFNode read FFdLeftTexture;
    {  }
    property LeftTexture: TAbstractTextureNode read GetLeftTexture write SetLeftTexture;

    strict private FFdRightTexture: TSFNode;
    { Internal wrapper for property @link(RightTexture). This wrapper API may change, we advise to access simpler @link(RightTexture) instead. }
    public property FdRightTexture: TSFNode read FFdRightTexture;
    {  }
    property RightTexture: TAbstractTextureNode read GetRightTexture write SetRightTexture;

    strict private FFdTopTexture: TSFNode;
    { Internal wrapper for property @link(TopTexture). This wrapper API may change, we advise to access simpler @link(TopTexture) instead. }
    public property FdTopTexture: TSFNode read FFdTopTexture;
    {  }
    property TopTexture: TAbstractTextureNode read GetTopTexture write SetTopTexture;

{$endif read_interface}

{$ifdef read_implementation}

{ TTextureBackgroundNode ----------------------------------------------- }

function TTextureBackgroundNode.GetBackTexture: TAbstractTextureNode;
begin
  if FdBackTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdBackTexture.Value)
  else
    Result := nil;
end;

procedure TTextureBackgroundNode.SetBackTexture(const Value: TAbstractTextureNode);
begin
  FdBackTexture.Send(Value);
end;

function TTextureBackgroundNode.GetBottomTexture: TAbstractTextureNode;
begin
  if FdBottomTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdBottomTexture.Value)
  else
    Result := nil;
end;

procedure TTextureBackgroundNode.SetBottomTexture(const Value: TAbstractTextureNode);
begin
  FdBottomTexture.Send(Value);
end;

function TTextureBackgroundNode.GetFrontTexture: TAbstractTextureNode;
begin
  if FdFrontTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdFrontTexture.Value)
  else
    Result := nil;
end;

procedure TTextureBackgroundNode.SetFrontTexture(const Value: TAbstractTextureNode);
begin
  FdFrontTexture.Send(Value);
end;

function TTextureBackgroundNode.GetLeftTexture: TAbstractTextureNode;
begin
  if FdLeftTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdLeftTexture.Value)
  else
    Result := nil;
end;

procedure TTextureBackgroundNode.SetLeftTexture(const Value: TAbstractTextureNode);
begin
  FdLeftTexture.Send(Value);
end;

function TTextureBackgroundNode.GetRightTexture: TAbstractTextureNode;
begin
  if FdRightTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdRightTexture.Value)
  else
    Result := nil;
end;

procedure TTextureBackgroundNode.SetRightTexture(const Value: TAbstractTextureNode);
begin
  FdRightTexture.Send(Value);
end;

function TTextureBackgroundNode.GetTopTexture: TAbstractTextureNode;
begin
  if FdTopTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdTopTexture.Value)
  else
    Result := nil;
end;

procedure TTextureBackgroundNode.SetTopTexture(const Value: TAbstractTextureNode);
begin
  FdTopTexture.Send(Value);
end;

class function TTextureBackgroundNode.ClassX3DType: String;
begin
  Result := 'TextureBackground';
end;

procedure TTextureBackgroundNode.CreateNode;
begin
  inherited;

  FFdBackTexture := TSFNode.Create(Self, True, 'backTexture', [TAbstractTextureNode]);
   FdBackTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBackTexture);

  FFdBottomTexture := TSFNode.Create(Self, True, 'bottomTexture', [TAbstractTextureNode]);
   FdBottomTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBottomTexture);

  FFdFrontTexture := TSFNode.Create(Self, True, 'frontTexture', [TAbstractTextureNode]);
   FdFrontTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdFrontTexture);

  FFdLeftTexture := TSFNode.Create(Self, True, 'leftTexture', [TAbstractTextureNode]);
   FdLeftTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdLeftTexture);

  FFdRightTexture := TSFNode.Create(Self, True, 'rightTexture', [TAbstractTextureNode]);
   FdRightTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdRightTexture);

  FFdTopTexture := TSFNode.Create(Self, True, 'topTexture', [TAbstractTextureNode]);
   FdTopTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTopTexture);
end;

{$endif read_implementation}
