/* 
 
Copyright 2006 Rene Grothmann, modified by Eric Hakenholz

This file is part of C.a.R. software.

    C.a.R. is a free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, version 3 of the License.

    C.a.R. is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 
 */
 
 
 package rene.zirkel.constructors;

// file: QuadricConstructor.java

import java.awt.event.MouseEvent;

import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.gui.Global;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.QuadricObject;

public class QuadricConstructor extends ObjectConstructor {
	PointObject P[];
	int NPoints;
	static PointObject previewPoint = null;
	static QuadricObject previewQuadric = null;

	public static void deletePreview(final ZirkelCanvas zc) {
		if (previewQuadric != null) {
			zc.delete(previewQuadric);
			previewPoint = null;
			previewQuadric = null;
			zc.reset();
		}
	}

	private void arrangeP() {
		if (NPoints < 5) {
			P[4] = previewPoint;
			for (int i = 3; i >= NPoints; i--) {
				P[i] = P[0];
			}
		}
	}

	@Override
	public void mousePressed(final MouseEvent e, final ZirkelCanvas zc) {
		if (!zc.Visual)
			return;
		if (previewPoint == null)
			previewPoint = new PointObject(zc.getConstruction(), "PrevPoint");
		if (previewQuadric != null)
			previewQuadric.setHidden(true);
		final PointObject p = zc.selectCreatePoint(e.getX(), e.getY(), e.isAltDown());
		if (previewQuadric != null)
			previewQuadric.setHidden(false);
		if (p != null) {
			P[NPoints++] = p;
			p.setSelected(true);
			arrangeP();
			if (previewQuadric == null) {
				previewQuadric = new QuadricObject(zc.getConstruction(), P);
				zc.addObject(previewQuadric);
			}
			
			previewQuadric.setDefaults();
			zc.repaint();
		}
		showStatus(zc);
		if (NPoints == 5) {
			final QuadricObject Q = new QuadricObject(zc.getConstruction(), P);
			zc.addObject(Q);
			Q.setDefaults();
			zc.clearSelected();
			deletePreview(zc);
		}
	}

	@Override
	public void mouseMoved(final MouseEvent e, final ZirkelCanvas zc,
			final boolean simple) {
		if (previewPoint != null) {
			previewQuadric.validate();
			previewPoint.move(zc.x(e.getX()), zc.y(e.getY()));
			zc.repaint();
		}
		super.mouseMoved(e, zc, simple);
	}

	@Override
	public void showStatus(final ZirkelCanvas zc) {
		zc.showStatus(Global.name("message.quadric") + " " + (NPoints + 1));
	}

	@Override
	public void reset(final ZirkelCanvas zc) {
		super.reset(zc);
		if (zc.Visual) {
			P = new PointObject[5];
			NPoints = 0;
			showStatus(zc);
		} else {
			zc.setPrompt(Global.name("prompt.quadric"));
		}
	}

	@Override
	public boolean construct(final XmlTree tree, final Construction c)
	throws ConstructionException {
		if (!testTree(tree, "Quadric"))
			return false;
		final XmlTag tag = tree.getTag();
		for (int i = 0; i < 5; i++)
			if (!tag.hasParam("point" + (i + 1)))
				throw new ConstructionException("Quadric points missing!");
		try {
			final PointObject P[] = new PointObject[5];
			for (int i = 0; i < 5; i++)
				P[i] = (PointObject) c.find(tag.getValue("point" + (i + 1)));
			final QuadricObject p = new QuadricObject(c, P);
			setName(tag, p);
			set(tree, p);
			c.add(p);
			setConditionals(tree, c, p);
		} catch (final ConstructionException e) {
			throw e;
		} catch (final Exception e) {
			throw new ConstructionException("Quadric points illegal!");
		}
		return true;
	}

	public String getPrompt() {
		return Global.name("prompt.quadric");
	}

	@Override
	public String getTag() {
		return "Quadric";
	}

	@Override
	public void construct(final Construction c, final String name,
			final String params[], final int nparams)
	throws ConstructionException {
		if (nparams != 5)
			throw new ConstructionException(Global.name("exception.nparams"));
		final ConstructionObject P[] = new PointObject[5];
		for (int i = 0; i < 5; i++) {
			P[i] = c.find(params[i]);
			if (P[i] == null)
				throw new ConstructionException(Global.name("exception.notfound")
						+ " " + params[i]);
			if (!(P[i] instanceof PointObject))
				throw new ConstructionException(Global.name("exception.type")
						+ " " + params[i]);
		}
		final QuadricObject s = new QuadricObject(c, (PointObject[]) P);
		if (!name.equals(""))
			s.setNameCheck(name);
		c.add(s);
		s.setDefaults();
	}

}
