/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// generated by Fast Light User Interface Designer (fluid) version 1.0104

#include <config.h>
#include <global.hpp>

#include <cairo/cairo.h>
#include <pango/pangocairo.h>
#include <cairo_t_singleton.hpp>
#include <glib.h>


#include <FL/Fl.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Value_Slider.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Image.H>
#include <FL/Fl_Pixmap.H>
#include <FL/fl_draw.H>
#include <FL/Fl_Scroll.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Menu_Item.H>
#include <FL/Fl_Toggle_Button.H>
#include <FL/Fl_Menu_Button.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_File_Chooser.H>
#include <FL/Fl_Light_Button.H>
#include <FL/Fl_Color_Chooser.H>
#include <FL/Fl_Help_Dialog.H>




#include <interfacce.hpp>
#include <legame.hpp>
#include <etichetta.hpp>
#include <multiline_label.hpp>
#include <multifont_label.hpp>
#include <paragraph_text.hpp>
#include <atomo.hpp>
#include <procedura.hpp>
#include <gruppo.hpp>
#include <immagine.hpp>
#include <bist_plugin.hpp>
#include <mol_canvas.hpp>

#include <util.hpp>
#include <arc_prop.hpp>

#include <finestra_pr.hpp>
#include <editor.hpp>


extern finestra_pr* MainWindow;

//
// called by clicking "Color" button
// allow to choose and set up the color
//
void Arc_Prop::setColor(unsigned int r, unsigned int g, unsigned int b)
{
    _arc->cr(r);
    _arc->cg(g);
    _arc->cb(b);
}

void arc_prop_color_cb(Fl_Widget* w, void* d){
  unsigned char r,g,b;
  int pushd=fl_color_chooser(_("pick a color..."), r, g, b);
  editor* ed=dynamic_cast<editor*>(MainWindow);
  if (pushd){
    Arc_Prop* prop = dynamic_cast<Arc_Prop*>(w->parent());
    prop->setColor(r,g,b);
    ed->redraw();
  }
    
}

void arc_prop_ok_cb(Fl_Widget* w, void* d){
  Fl_Window* win=dynamic_cast<Fl_Window*>(w->parent());
  win->hide();

}

void arc_prop_cancel_cb(Fl_Widget* w, void* d){
  Fl_Window* wi=dynamic_cast<Fl_Window*>(w->parent());
  wi->hide();
}

//
// callback used for setting up arc width
//
void Arc_Prop::setWidth(int width)
{
  if (width > 0){
    _arc->spessore(width);
  }
}
void arc_prop_width_cb(Fl_Widget* w, void* d){
  Fl_Value_Slider* sl=dynamic_cast<Fl_Value_Slider*>(w);
  Arc_Prop* arrp=dynamic_cast<Arc_Prop*>(w->parent());
  editor* ed=dynamic_cast<editor*>(MainWindow);
  arrp->setWidth(sl->value());
  ed->redraw();
}

//
// callback used to setting up arc thickness
//
void Arc_Prop::setThick(int thick)
{
  if (thick > 0){
    _arc->dash(thick);
  }
}
void arc_prop_thick_cb(Fl_Widget* w, void* d){

  Fl_Value_Slider* sl=dynamic_cast<Fl_Value_Slider*>(w);
  Arc_Prop* arrp=dynamic_cast<Arc_Prop*>(w->parent());
  editor* ed=dynamic_cast<editor*>(MainWindow);
  arrp->setThick(static_cast<int>(sl->value()));
  ed->redraw();
}

Arc_Prop::~Arc_Prop(){

}
/*
 * initializing gui elements
 * of arc properties window.
 */
Arc_Prop::Arc_Prop(proc_arc* arr)
  :Fl_Double_Window(400, 171),
   _arc(arr)
 {
      
   Fl_Box* arcPropBox = new Fl_Box(5, 20, 395, 110, _("Arc properties"));
   arcPropBox->box(FL_ENGRAVED_BOX);
   arcPropBox->align(FL_ALIGN_TOP_LEFT);
     
   
     Fl_Value_Slider* thickSlider = new Fl_Value_Slider(100, 25, 250, 25, _("Thickness:"));
     thickSlider->type(1);
     thickSlider->step(0.01);
     thickSlider->align(FL_ALIGN_LEFT);
     thickSlider->range(0, 30);
     thickSlider->precision(0);
     thickSlider->value(_arc->dash());
     thickSlider->callback(arc_prop_thick_cb);
     
    
     Fl_Value_Slider* widthSlider = new Fl_Value_Slider(100, 52, 250, 25, _("Width:"));
     widthSlider->type(1);
     widthSlider->step(0.01);
     widthSlider->align(FL_ALIGN_LEFT);
     widthSlider->range(0, 10);
     widthSlider->precision(0);
     widthSlider->value(_arc->spessore());
     widthSlider->callback(arc_prop_width_cb);
   

   
   Fl_Button* colorButton=new Fl_Button(w()/2-LARG_BUTTON_DEFAULT*2, 92, 
                                   LARG_BUTTON_DEFAULT*2, LARG_BUTTON_DEFAULT, _("Color"));
   colorButton->callback(arc_prop_color_cb);
   add(colorButton);
   
   Fl_Button* okButton=new Fl_Button(w()/2, 92, 
                               LARG_BUTTON_DEFAULT*2, LARG_BUTTON_DEFAULT, _("OK"));
   okButton->callback(arc_prop_ok_cb);
   add(okButton);

   Fl_Button* cancelButton=new Fl_Button(w()/2-LARG_BUTTON_DEFAULT*3/2, h()-LARG_BUTTON_DEFAULT-10, 
                                    LARG_BUTTON_DEFAULT*3, LARG_BUTTON_DEFAULT, _("Cancel"));
   cancelButton->callback(arc_prop_cancel_cb);
   add(cancelButton);
   
   end();
   set_modal();
   dialog_position(this);
}

void arc_win(proc_arc* at){
  Arc_Prop win(at);
  win.show();

  while(win.shown()){
    Fl::wait();
  }

  
}
