#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2015 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2019 BetaRays
# SPDX-FileCopyrightText: © 2020 HS-157
set -o errexit

###
# SNK Neo Geo games:
# - King of the Monsters
# - Baseball Stars 2
# - Fatal Fury Special
# - Art of Fighting 2
# - Samurai Shodown 2
# - Metal Slug 2
# - Metal Slug 3
# - The King of Fighters 2000
# - Sengoku 3
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250708.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID_KINGOFTHEMONSTERS='king-of-the-monsters'
GAME_NAME_KINGOFTHEMONSTERS='King of the Monsters'

GAME_ID_BASEBALLSTARS2='baseball-stars-2'
GAME_NAME_BASEBALLSTARS2='Baseball Stars 2'

GAME_ID_FATALFURYSPECIAL='fatal-fury-special'
GAME_NAME_FATALFURYSPECIAL='Fatal Fury Special'

GAME_ID_ARTOFFIGHTING2='art-of-fighting-2'
GAME_NAME_ARTOFFIGHTING2='Art of Fighting 2'

GAME_ID_SAMURAISHODOWN2='samurai-shodown-2'
GAME_NAME_SAMURAISHODOWN2='Samurai Shodown II'

GAME_ID_METALSLUG2='metal-slug-2'
GAME_NAME_METALSLUG2='Metal Slug 2'

GAME_ID_METALSLUG3='metal-slug-3'
GAME_NAME_METALSLUG3='Metal Slug 3'

GAME_ID_THEKINGOFFIGHTERS2000='the-king-of-fighter-2000'
GAME_NAME_THEKINGOFFIGHTERS2000='The King of Fighters 2000'

GAME_ID_SENGOKU3='sengoku-3'
GAME_NAME_SENGOKU3='Sengoku 3'

ARCHIVE_BASE_KINGOFTHEMONSTERS_0_NAME='KingOfTheMonsters_jan2016.sh'
ARCHIVE_BASE_KINGOFTHEMONSTERS_0_MD5='7a82ccaada86bd1c4637f0e088afbfa3'
ARCHIVE_BASE_KINGOFTHEMONSTERS_0_VERSION='1.0-humblejan2016'
ARCHIVE_BASE_KINGOFTHEMONSTERS_0_SIZE='36000'
ARCHIVE_BASE_KINGOFTHEMONSTERS_0_URL='https://www.humblebundle.com/store/neogeo-classics-pack-4'

ARCHIVE_BASE_BASEBALLSTARS2_0_NAME='BaseballStars2_jan2016.sh'
ARCHIVE_BASE_BASEBALLSTARS2_0_MD5='efe7f4d90cc2e5db0efd00e7b32d8114'
ARCHIVE_BASE_BASEBALLSTARS2_0_SIZE='36000'
ARCHIVE_BASE_BASEBALLSTARS2_0_VERSION='1.0-humblejan2016'
ARCHIVE_BASE_BASEBALLSTARS2_0_URL='https://www.humblebundle.com/store/neogeo-classics-pack-1'

ARCHIVE_BASE_FATALFURYSPECIAL_0_NAME='FatalFurySpecial_jan2016.sh'
ARCHIVE_BASE_FATALFURYSPECIAL_0_MD5='b13a53d2944281ef2d139719ac727ef3'
ARCHIVE_BASE_FATALFURYSPECIAL_0_SIZE='43000'
ARCHIVE_BASE_FATALFURYSPECIAL_0_VERSION='1.0-humblejan2016'
ARCHIVE_BASE_FATALFURYSPECIAL_0_URL='https://www.humblebundle.com/store/fatal-fury-special'

ARCHIVE_BASE_ARTOFFIGHTING2_0_NAME='ArtOfFighting2_jan2016.sh'
ARCHIVE_BASE_ARTOFFIGHTING2_0_MD5='f50a3d75ecea5a1fbbfde30cd876d674'
ARCHIVE_BASE_ARTOFFIGHTING2_0_SIZE='44000'
ARCHIVE_BASE_ARTOFFIGHTING2_0_VERSION='1.0-humble.2016.01'
ARCHIVE_BASE_ARTOFFIGHTING2_0_URL='https://www.humblebundle.com/store/neogeo-classics-pack-1'

ARCHIVE_BASE_SAMURAISHODOWN2_0_NAME='SamuraiShodown2_jan2016.sh'
ARCHIVE_BASE_SAMURAISHODOWN2_0_MD5='11a6642f250c9ec322bc8d1a9f0f9b49'
ARCHIVE_BASE_SAMURAISHODOWN2_0_SIZE='48000'
ARCHIVE_BASE_SAMURAISHODOWN2_0_VERSION='1.0-humblejan2016'
ARCHIVE_BASE_SAMURAISHODOWN2_0_URL='https://www.humblebundle.com/store/neogeo-classics-pack-4'

ARCHIVE_BASE_METALSLUG2_0_NAME='MetalSlug2_jan2016.sh'
ARCHIVE_BASE_METALSLUG2_0_MD5='c6ee0e16787b4ec5d497f96f9474ce80'
ARCHIVE_BASE_METALSLUG2_0_SIZE='49000'
ARCHIVE_BASE_METALSLUG2_0_VERSION='1.0-humblejan2016'
ARCHIVE_BASE_METALSLUG2_0_URL='https://www.humblebundle.com/store/metal-slug-2'

ARCHIVE_BASE_METALSLUG3_0_NAME='MetalSlug3_jan2016.sh'
ARCHIVE_BASE_METALSLUG3_0_MD5='a6854b31e7757f447c9c05281b28f57a'
ARCHIVE_BASE_METALSLUG3_0_SIZE='110000'
ARCHIVE_BASE_METALSLUG3_0_VERSION='1.0-humble1601'
ARCHIVE_BASE_METALSLUG3_0_URL='https://www.humblebundle.com/store/neogeo-classics-pack-3'

ARCHIVE_BASE_THEKINGOFFIGHTERS2000_0_NAME='KingOfFighters2000_jan2016.sh'
ARCHIVE_BASE_THEKINGOFFIGHTERS2000_0_MD5='98f3d87cd286c868f184fefe1c4222b9'
ARCHIVE_BASE_THEKINGOFFIGHTERS2000_0_SIZE='120000'
ARCHIVE_BASE_THEKINGOFFIGHTERS2000_0_VERSION='1.0-humblejan2016'
ARCHIVE_BASE_THEKINGOFFIGHTERS2000_0_URL='https://www.humblebundle.com/store/the-king-of-fighters-2000'

ARCHIVE_BASE_SENGOKU3_0_NAME='Sengoku3_jan2016.sh'
ARCHIVE_BASE_SENGOKU3_0_MD5='5ecd65661e4b35c1badebcb146c8a261'
ARCHIVE_BASE_SENGOKU3_0_SIZE='76000'
ARCHIVE_BASE_SENGOKU3_0_VERSION='1.0-humblejan2016'
ARCHIVE_BASE_SENGOKU3_0_URL='https://www.humblebundle.com/store/sengoku-3'

CONTENT_PATH_DEFAULT='data'
CONTENT_LIBS_BIN_FILES='
libRocketControls.so.1
libRocketCore.so.1
libRocketDebugger.so.1'
## Using system-provided SDL2 instead of the shipped one,
## the game menu fails to render.
CONTENT_LIBS_BIN_FILES="$CONTENT_LIBS_BIN_FILES
libSDL2-2.0.so.0"
CONTENT_LIBS_BIN64_RELATIVE_PATH='x86_64/lib64'
CONTENT_LIBS_BIN64_FILES="$CONTENT_LIBS_BIN_FILES"
CONTENT_LIBS_BIN32_RELATIVE_PATH='x86/lib'
CONTENT_LIBS_BIN32_FILES="$CONTENT_LIBS_BIN_FILES"
CONTENT_GAME_BIN64_RELATIVE_PATH='x86_64'
CONTENT_GAME_BIN64_FILES='
NeogeoEmu.bin.x86_64'
CONTENT_GAME_BIN32_RELATIVE_PATH='x86'
CONTENT_GAME_BIN32_FILES='
NeogeoEmu.bin.x86'
CONTENT_GAME_DATA_RELATIVE_PATH='noarch'
CONTENT_GAME_DATA_FILES='
*.brm
*.dat
*.ini
*.png
*.rcss
*.rml
*.tga
*.txt
*.wav
*.xor
*.zip'
CONTENT_FONTS_DATA_RELATIVE_PATH='noarch'
CONTENT_FONTS_DATA_FILES='
LiberationSerif-BoldItalic.ttf
LiberationSerif-Bold.ttf
LiberationSerif-Italic.ttf
LiberationSerif-Regular.ttf
TimesNewRomanPSBold.ttf'

USER_PERSISTENT_FILES='
*.ini
*.rml
*.txt'

APP_MAIN_EXE_BIN64='NeogeoEmu.bin.x86_64'
APP_MAIN_EXE_BIN32='NeogeoEmu.bin.x86'
APP_MAIN_ICON_KINGOFTHEMONSTERS='noarch/KingOfTheMonsters.png'
APP_MAIN_ICON_BASEBALLSTARS2='noarch/BaseballStars2.png'
APP_MAIN_ICON_FATALFURYSPECIAL='noarch/FatalFurySpecial.png'
APP_MAIN_ICON_ARTOFFIGHTING2='noarch/ArtOfFighting2.png'
APP_MAIN_ICON_SAMURAISHODOWN2='noarch/SamuraiShodown2.png'
APP_MAIN_ICON_METALSLUG2='noarch/MetalSlug2.png'
APP_MAIN_ICON_METALSLUG3='noarch/MetalSlug3.png'
APP_MAIN_ICON_THEKINGOFFIGHTERS2000='noarch/KingOfFighters2000.png'
APP_MAIN_ICON_SENGOKU3='noarch/Sengoku3.png'
## The shipped build of SDL2 has no support for the wayland backend.
APP_MAIN_PRERUN='
# The shipped build of SDL2 has no support for the wayland backend
if [ "${SDL_VIDEODRIVER:-}" = "wayland" ]; then
	unset SDL_VIDEODRIVER
fi
'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libfreetype.so.6
libgcc_s.so.1
libm.so.6
libpthread.so.0
libstdc++.so.6'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

PKG_DATA_ID_KINGOFTHEMONSTERS="${GAME_ID_KINGOFTHEMONSTERS}-data"
PKG_DATA_ID_BASEBALLSTARS2="${GAME_ID_BASEBALLSTARS2}-data"
PKG_DATA_ID_FATALFURYSPECIAL="${GAME_ID_FATALFURYSPECIAL}-data"
PKG_DATA_ID_ARTOFFIGHTING2="${GAME_ID_ARTOFFIGHTING2}-data"
PKG_DATA_ID_SAMURAISHODOWN2="${GAME_ID_SAMURAISHODOWN2}-data"
PKG_DATA_ID_METALSLUG2="${GAME_ID_METALSLUG2}-data"
PKG_DATA_ID_METALSLUG3="${GAME_ID_METALSLUG3}-data"
PKG_DATA_ID_THEKINGOFFIGHTERS2000="${GAME_ID_THEKINGOFFIGHTERS2000}-data"
PKG_DATA_ID_SENGOKU3="${GAME_ID_SENGOKU3}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# The game engine looks for fonts in a hardcoded path.

fonts_source=$(path_fonts_ttf)
fonts_destination="$(package_path 'PKG_DATA')$(path_game_data)"
ln --symbolic --target-directory="$fonts_destination" \
	"${fonts_source}/LiberationSerif-Regular.ttf" \
	"${fonts_source}/LiberationSerif-Bold.ttf" \
	"${fonts_source}/LiberationSerif-BoldItalic.ttf" \
	"${fonts_source}/LiberationSerif-Italic.ttf" \
	"${fonts_source}/TimesNewRomanPSBold.ttf"

# Write launchers

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
