#ifndef TRANSLATOR_H
#define TRANSLATOR_H

#include "database.h"


//========================================================================
// $Id: translator.h,v 1.12 2001/03/11 22:41:46 radnev Exp $
//========================================================================


class Translator {

public:
	Translator(const int wordLength, const int wordNumber);
	~Translator();
	bool createDictionary(const char *dataDir, const int dictionary, const long fixedLastWordPointer = 0);
	bool findWord(const char *word, char **result);
	bool goToNextWord();
	char *getWord(const bool lowerCase = true, const bool legalLatinInput = true);
	char *getResult();
	bool testWord(const char *word);
	char *getNextRandomWord();
	void setTestParameters(const int dictionary, const int level);
	bool setAdvancedSearchText(const char *word);
	bool searchNextWord();
	char *extractText(const char *text);

	static const int ENG_BUL;
	static const int BUL_ENG;

	bool separateMeanings;
	bool latinOutput;
	bool latinInput;
	bool boldDecoration;
	bool htmlOutput;

	bool advancedSearchState;
	bool advancedSearchHighlight;
	bool advancedSearchWholeWord;
	bool advancedSearchExactPhrase;

private:
	static const int  MAX_DATA_LEN;

	static const int  FILE_NAME_LEN;
	static const char ENG_BUL_FILE_NAME[];
	static const char BUL_ENG_FILE_NAME[];

	static const char ENG_CHARS[];
	static const char BUL_CHARS[];
	static const char LATIN_OUTPUT_CHARS[32][4];
	static const char ENG_SUFFIXS[3][4];
	static const char BOLD_START[];
	static const char BOLD_END[];
	static const char TRANSCRIPTION_START[];
	static const char TRANSCRIPTION_END[];
	static const char A_S_HL_HTML_START[];
	static const char A_S_HL_HTML_END[];
	static const char A_S_HL_NORMAL_START[];
	static const char A_S_HL_NORMAL_END[];
	static const char BREAK_LINE[];
	static const char NON_ALPHA_CHARS[];
	static const char TEST_DELIMITER;

	Database *dicEB;
	Database *dicBE;
	Database *currentDic;

	char *dataBuffer;
	char *wordBuffer;
	char *tempBuffer;
	char *dataBuffer2;
	char *wordBuffer2;
	bool *wordPlus;

	int maxWordLength;
	int maxWordNumber;

	int currentDictionary;
	int testDictionary;

	int wordNumber;

	int testLevel;

	bool firstTimeAdvancedSearch;
	bool firstDataBaseAdvancedSearch;

	char *toLowerCase(const char *word, char *buf);
	char *toUpperCase(const char *word, char *buf);
	char *toLegalDictionaryWord(const char *word, char *buf);
	char *trimWord(const char *word, char *buf);
	char *toLatin(const char *word, char *buf, const bool legalLatinInput = true);
	bool isEnglishWordWithoutSuffix(const char *word, char *buf);
	bool isLatinInput(const char *word, char *buf, const bool ignoreSpace = false);
	char *transformResult(const char *result);
	int appendString(const char *data, const int currentPointer);
	void setCurrentDictionary(const char c);
	char *search(char *text, const char *word, const bool exactSearch);
	bool isAlphaChar(const char c);

}; // End of class Translator

#endif
