//
// ========================================================================
// Copyright (c) 1995 Mort Bay Consulting Pty Ltd and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// https://www.eclipse.org/legal/epl-2.0, or the Apache License, Version 2.0
// which is available at https://www.apache.org/licenses/LICENSE-2.0.
//
// SPDX-License-Identifier: EPL-2.0 OR Apache-2.0
// ========================================================================
//

package org.eclipse.jetty.tests.ccd.common;

public class Property
{
    private String name;
    private String value;

    public Property()
    {
    }

    public Property(String name, String value)
    {
        this.name = name;
        this.value = value;
    }

    public static Property parse(String line)
    {
        String[] parts = line.split("\\|");
        String name = parts[1];
        String value = null;
        if (parts.length > 2)
            value = parts[2];
        return new Property(name, value);
    }

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    public String getValue()
    {
        return value;
    }

    public void setValue(String value)
    {
        this.value = value;
    }

    @Override
    public String toString()
    {
        return "Property{" +
            "name='" + name + '\'' +
            ", value='" + value + '\'' +
            '}';
    }
}
