#!/bin/sh
set -e

# runlevel no more supported (LP: #2095042)
# /etc/os-release is not part of the source but the target systems
# shellcheck source=/dev/null
VERSION_ID_YY=$(. /etc/os-release && echo "$VERSION_ID" | cut -d"." -f1)
if [ -n "${VERSION_ID_YY}" ] && [ "${VERSION_ID_YY}" -ge 25 ]; then
    # wait for systemd to consider itself no more initializing
    systemctl is-system-running --wait
else
    # Wait for runlevel 2 (upstart) or 5 (systemd)
    while :; do
        runlevel="$(runlevel|awk '{print $2}')"
        if [ "$runlevel" = 2 ] || [ "$runlevel" = 5 ]; then
            break;
        fi
        sleep "$UVTOOL_WAIT_INTERVAL"
    done
fi

# Wait for cloud-init's signal
while [ ! -e /var/lib/cloud/instance/boot-finished ]; do sleep "$UVTOOL_WAIT_INTERVAL"; done
