/*
    mingw.h - mingw32 specific functions
    Copyright (C) 2011 Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/

#ifdef __MINGW2
#ifndef __MINGW2_H
#define __MINGW2_H
#undef stdout
#define stdout mingw_stderr
#undef stderr
#define stderr mingw_stderr
extern FILE *mingw_stderr;
#endif
#endif

#ifndef __TUCNAK_MINGW_H
#define __TUCNAK_MINGW_H

#include <winsock2.h>
#include <windows.h>
    
#include "regex_.h"

#define tmkdir(dir, mode) mkdir(dir)
#define SO4 (char *)
#define __attribute__(attr)

typedef int socklen_t;
typedef int speed_t;

struct tm;
time_t timegm(struct tm *tm);
int init_mingw(void);

#define timegm mkgmtime

/* termios */

#define  B50    0000001
#define  B75    0000002
#define  B110   0000003
#define  B134   0000004
#define  B150   0000005
#define  B200   0000006
#define  B300   0000007
#define  B600   0000010
#define  B1200  0000011
#define  B1800  0000012
#define  B2400  0000013
#define  B4800  0000014
#define  B9600  0000015
#define  B19200 0000016
#define  B38400 0000017

#define IGNBRK  0000001
#define BRKINT  0000002
#define IGNPAR  0000004
#define PARMRK  0000010
#define INPCK   0000020
#define ISTRIP  0000040
#define INLCR   0000100
#define IGNCR   0000200
#define ICRNL   0000400
#define IXON    0002000

#define OPOST   0000001

#define ISIG    0000001
#define ICANON  0000002
#define ECHO    0000010
#define ECHOE   0000020
#define ECHONL  0000100
#define IEXTEN  0100000

#define CSIZE   0000060
#define   CS8   0000060
#define CSTOPB  0000100
#define CREAD   0000200
#define PARENB  0000400
#define PARODD  0001000
#define CLOCAL  0004000
#define TCSANOW         0
#define INPCK   0000020
#define CRTSCTS  020000000000
#define VTIME 5
#define VMIN 6
#define WNOHANG         1

#define TCIFLUSH        0

#define NCCS 32
struct termios{
	int c_iflag, c_oflag, c_cflag, c_lflag;
	char c_cc[NCCS];
};


/* file */

#define O_RDONLY             00
#define O_WRONLY             01
#define O_RDWR               02
#define O_CREAT            0100
#define O_EXCL             0200
#define O_NOCTTY           0400
#define O_SYNC           010000


//char *wokna(char *file);
//int open(const char *pathname, int flags);
//int close(int fd);
//int read(int fd, void *buf, int count);
//int write(int fd, const void *buf, int count);
//int pipe(int *fds);
//int fsync(int fd);
//int lockf(int fd, int cmd, off_t len);
//int ftruncate(int fd, off_t length);
//int tcgetattr(int fd, struct termios *termios_p);
//int tcsetattr(int fd, int optional_actions, const struct termios *termios_p);
//int tcflush(int fd, int queue_selector);
//int cfsetispeed(struct termios *termios_p, speed_t speed);
//int cfsetospeed(struct termios *termios_p, speed_t speed);
//void cfmakeraw(struct termios *termios_p);
//int _dup(int fd);
//int _dup2(int oldfd, int newfd);

/* ioctl */

#define TIOCM_DTR       0x002
#define TIOCM_RTS       0x004
#define TIOCGWINSZ      0x5413
#define TIOCSWINSZ      0x5414
#define TIOCMBIS        0x5416
#define TIOCMBIC        0x5417
#define TIOCLINUX       0x541C

int ioctl(int d, int request, ...);

/* fcntl */

#define F_SETFL         4 
#define O_NONBLOCK        04000
        
int fcntl(int fd, int cmd, long arg);

/* signal */

#define SIGHUP          1
#define SIGPIPE         13
#define SIGCHLD         17

typedef struct siginfo_t {
	int dommy;
}siginfo_t;

typedef int sigset_t;

struct sigaction {
    void     (*sa_handler)(int);
    void     (*sa_sigaction)(int, siginfo_t *, void *);
    sigset_t   sa_mask;
    int        sa_flags;
    void     (*sa_restorer)(void);
};

int sigaction(int signum, const struct sigaction *act, struct sigaction *oldact);
int sigfillset(sigset_t *set);

/* socket */
#define sock_errno WSAGetLastError()
char *sock_strerror_r(int err, char *errstr, int size);

/* misc */
char *strtok_r(char *str, const char *delim, char **saveptr);


#endif
