/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2010  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"

#define HTML_QSO_STR(item) zg_string_eprintfa("h", gs, "<td>%s </td> ", item);
#define HTML_QSO_INT(item) g_string_sprintfa(gs, "<td align=\"right\">%d </td> ", item);

#define HTML_HDR(item) g_string_sprintfa(gs, "<th bgcolor=\"#e4b97c\"><font color=\"#800000\">%s</font></th>\n", item);

static int bandrefi = 0;
gchar *qh(GString *gs, gchar *s){
	char *c;

    g_string_truncate(gs,0);
    if (!s) return gs->str;
    
	for (c=s; *c!='\0'; c++) {
        switch (*c){
            case '<':
                g_string_append(gs, "&lt;");
                break;
            case '>':
                g_string_append(gs, "&gt;");
                break;
            case '"':
                g_string_append(gs, "&quot;");
                break;
            case '&':
                g_string_append(gs, "&amp;");
                break;
            case '\'':
                g_string_append(gs, "&#39;");
                break;
            default:
                g_string_append_c(gs, *c);    
        }
    }
	return gs->str;
} 
  
void html_style(GString *gs){
    g_string_sprintfa(gs, 
"body {\n"
"    font-size: 12pt;\n"
/*"    font-family: Tahoma, Helvetica, Arial, sans-serif}\n"*/
"    font-family: Courier, Courier-new}\n"

"a {\n"
"    font-weight: bold}\n"

"h1, h2, h3, h4 {\n"
"    font-family: Tahoma, Helvetica, Arial, sans-serif;\n"
"    color: #f8f8f8};\n"

"h2 {\n"
"    margin-top: 20;\n"
"    margin-bottom: 5;\n"
"    margin-left:10 }\n"
/*
input {                                                                        
    padding: 2px;
    margin: 2px;
    font-weight: normal; 
    font-size: 12px; 
    color: #000000; 
    font-family: sans-serif}                                                                               

li {
    margin-bottom: 20px
}

p.stress{
    font-style: italic}
      */
"table.qsos {\n"
"    border: black 2px solid;\n"
"    padding: 5px;\n"
"    background: #606060}\n"

"th {\n"
"    padding-left: 5px;\n"
"    padding-right: 5px}\n"

"td {\n"
"    padding-left: 5px;\n"
"    padding-right: 5px}\n"
);
}

void html_header(GString *gs, gchar *title, int flags){
   

    g_string_sprintfa(gs, 
"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n"
"<html><head>\n"
"<meta http-equiv=\"content-type\" content=\"text/html; charset=iso-8859-2\">\n"
"<style type=\"text/css\">\n"
    );

    html_style(gs);

    g_string_sprintfa(gs, "</style>");
    zg_string_eprintfa("h", gs, "<title>%s</title>\n", title);
    g_string_sprintfa(gs, "</head>\n<body text=\"#ffffff\" bgcolor=\"#3f4e66\" link=\"#ddad6a\" vlink=\"#cd9d5a\" alink=\"#edbd7a\">");
    g_string_sprintfa(gs, "<h1>");
    if (flags & HTML_ICON) g_string_sprintfa(gs, "<img src=\"/tucnak64.png\" alt=\"Happy penguin\">");
    zg_string_eprintfa("h", gs, "%s</h1></center>\n", title);
    

}

    
void html_ref_header(GString *gs){
    zg_string_eprintfa("h", gs, "<p>Locator: %S</p>\n", ctest->pwwlo);
    g_string_sprintfa(gs, "<table class=\"qsos\">\n");
    g_string_sprintfa(gs, "<tr>");
    g_string_sprintfa(gs, "<th>Band</th><th>QSOs</th><th>Points</th><th>AVG</th></tr>\n");
}

void html_band_ref(GString *gs, struct band *b, struct config_band *confb){
    if (bandrefi++%2)
        g_string_sprintfa(gs, "<tr bgcolor=\"#505050\">\n");
    else
        g_string_sprintfa(gs, "<tr bgcolor=\"#606060\">\n");
    zg_string_eprintfa("h", gs, "<td><a href=\"#%c\">%s</a></td>\n", b->bandchar, b->bandname);
    g_string_sprintfa(gs, "<td align=\"right\">%d</td>\n", b->stats->nqsos);
    g_string_sprintfa(gs, "<td align=\"right\">%d</td>\n", b->stats->ntotal);
    if (b->stats->nqsos){ // happened always
        g_string_sprintfa(gs, "<td align=\"right\">%5.1f</td>\n", (double)b->stats->ntotal/(double)b->stats->nqsos);
    }
    g_string_sprintfa(gs, "</tr>\n");
}
    
void html_ref_footer(GString *gs, struct band *b, struct config_band *confb){
    g_string_sprintfa(gs, "</table>\n");
}

void html_band_header(GString *gs, struct band *b, struct config_band *confb, int flags, struct subwin *map, struct subwin *chart){
    int w, h;

    zg_string_eprintfa("h", gs, "<a name=\"%c\"></a><h2>Band %s</h2>\n", b->bandchar, b->bandname);
    g_string_sprintfa(gs, "<p>QSOs: %d<br>\n", b->stats->nqsos);
    g_string_sprintfa(gs, "Points: %d<br>\n", b->stats->ntotal);
    g_string_sprintfa(gs, "WWLs: %d<br>\n", g_hash_table_size(b->stats->wwls));
    g_string_sprintfa(gs, "DXCCs: %d<br>\n", g_hash_table_size(b->stats->dxcs));
    if (b->stats->nqsos){
        g_string_sprintfa(gs, "AVG: %5.2f pts/qso<br>\n", (double)b->stats->ntotal/(double)b->stats->nqsos);
    }
    g_string_sprintfa(gs, "</p>\n");
#ifdef HAVE_SDL
    w = 640;
    h = 480;
    if (map && map->screen) {
        w = map->screen->w;
        h = map->screen->h;
    }
    g_string_sprintfa(gs, "<p><img src=\"%smap%c.png\" width=\"%d\" height=\"%d\" alt=\"Polar map for %s\"></p>\n",
            flags & HTML_IMG_ROOT ? "/" : "", b->bandchar, w, h, b->bandname);
    w = 640;
    h = 480;
    if (chart && chart->screen) {
        w = chart->screen->w;
        h = chart->screen->h;
    }
    g_string_sprintfa(gs, "<p><img src=\"%schart%c.png\" width=\"%d\" height=\"%d\" alt=\"Chart for %s\"></p>\n",
            flags & HTML_IMG_ROOT ? "/" : "", b->bandchar, w, h, b->bandname);
#endif
	g_string_sprintfa(gs, "<br><br>\n\n<table class=\"qsos\">\n");
	g_string_sprintfa(gs, "<tr>\n");
    HTML_HDR("DATE");
	/*HTML_HDR("BAND");*/
	HTML_HDR("MODE");
	HTML_HDR("TIME");
	HTML_HDR("CALLSIGN");
	HTML_HDR("TX");
	HTML_HDR("RX");
	HTML_HDR("LOCATOR");
	HTML_HDR("QRB");
	HTML_HDR("OPERATOR");
	HTML_HDR("REMARK");
	g_string_sprintfa(gs, "</tr>\n");
}

void html_band_footer(GString *gs){
    g_string_sprintfa(gs,"</table>\n\n");
}
    
void html_footer(GString *gs){
    g_string_sprintfa(gs, "<p>Created by <a href=\"http://tucnak.nagano.cz\">TUCNAK</a> ver. %s</p>\n", VERSION_STRING);

    g_string_sprintfa(gs, 
"<p>\n"
"<a href=\"http://validator.w3.org/check/referer\">\n"
"<img border=\"0\" src=\"http://tucnak.nagano.cz/valid-html401.png\"\n"
"     alt=\"Valid HTML 4.01!\" height=\"31\" width=\"88\"></a>&nbsp;\n"
"\n"

"<a href=\"http://www.anybrowser.org/campaign/\">"
"<img src=\"http://tucnak.nagano.cz/bestviewed.gif\" alt=\"Viewable with any browser\"" 
"     width=\"80\" height=\"31\" border=\"0\"></a>&nbsp;"
"</p><br><br>\n"
"</body></html>\n");
}

void html_qsos(GString *gs, struct band *b, struct config_band *confb){
    struct qso *q;
    GString *gs2;
    int i,j;
	char *html_modes[]={
		"?",
		"SSB",
		"CW",
		"CWs",
		"CWr",
		"AM",
		"FM",
		"RTTY",
		"SSTV",
		"ATV"
	};
		

    gs2 = g_string_new("");
    
    
    j=0;
    for (i=0; i<b->qsos->len; i++){
        char time[10];
        gchar *c;
        
        q = get_qso(b, i); 
        if (q->error) continue;
		
		if (j++%2)
            g_string_sprintfa(gs, "<tr bgcolor=\"#505050\">\n");
        else
     		g_string_sprintfa(gs, "<tr bgcolor=\"#606060\">\n");

        strcpy(time, q->time_str);
        time[2]='.'; time[3]=q->time_str[2]; time[4]=q->time_str[3]; time[5]='\0';
        
		HTML_QSO_STR(q->date_str);
     	HTML_QSO_STR(html_modes[abs(q->mode)%10]);
		HTML_QSO_STR(time);
        HTML_QSO_STR(q->callsign);

        c = g_strdup_printf("%s %s", q->rsts, q->qsonrs);
		HTML_QSO_STR(c);
        g_free(c);
        
        c = g_strdup_printf("%s %s", q->rstr, q->qsonrr);
		HTML_QSO_STR(c);
        g_free(c);

		HTML_QSO_STR(q->locator);
		HTML_QSO_INT((int)q->qrb);
		HTML_QSO_STR(q->operator_);
		HTML_QSO_STR(q->remark);
        
		g_string_sprintfa(gs, "</tr>\n");
    }
    
    g_string_free(gs2, TRUE);
}

void html_complete(GString *gs, int flags){
    struct band *band;
    struct config_band *confb;
    int i;
    GString *gs2, *title;
    int header_saved=0;
    struct subwin *map = NULL;
    struct subwin *chart = NULL;
    struct band *oldaband;


    gs2 = g_string_sized_new(100);
    title = g_string_sized_new(100);
    
    for (i = 0; i < gses->subwins->len; i++){
        struct subwin *sw = (struct subwin*)g_ptr_array_index(gses->subwins, i);
        if (sw->type == SWT_MAP) map = sw;
        if (sw->type == SWT_CHART) chart = sw;
    }
    oldaband = aband;

	bandrefi = 0;
    for (i=0; i<ctest->bands->len; i++){
        band = (struct band*)g_ptr_array_index(ctest->bands, i);
        confb = (struct config_band*)get_config_band_by_bandchar(band->bandchar);

        stats_thread_join(band);
        if (band->stats->nqsos <=0) continue;
#if defined(HAVE_SDL) && defined(HAVE_LIBPNG) && !defined(_MSC_VER) // pod msvc pad ulozeni do PNG
		if (sdl && map && (flags & HTML_MAP)){
			char *filename;
            aband = band;
            map->gdirty = 1;
            map_for_photo(map);
			sw_map_redraw(map, HTML_FOR_PHOTO);
			filename = g_strdup_printf("%s/map%c.png", ctest->directory, tolower(band->bandchar));
			do_png_save(map->screen, filename);
			g_free(filename);
		}
		if (sdl && chart && (flags & HTML_CHART)){
			char *filename;
            aband = band;
            chart->gdirty = 1;
            sw_chart_recalc_extremes(chart);
			sw_chart_redraw(chart, HTML_FOR_PHOTO);
			filename = g_strdup_printf("%s/chart%c.png", ctest->directory, tolower(band->bandchar));
			do_png_save(chart->screen, filename);
			g_free(filename);
		}
#endif

        if (!header_saved){
            g_string_sprintf(title, "%s", ctest->pcall);
            uc(title->str);
            g_string_sprintfa(title, " - %s", ctest->tname);
            html_header(gs, title->str, 0);
            html_ref_header(gs);
            header_saved=1;
        }

        html_band_ref(gs, band, confb);
    }
    html_ref_footer(gs, band, confb);

    for (i=0; i<ctest->bands->len; i++){
        band = (struct band*)g_ptr_array_index(ctest->bands, i);
        confb = (struct config_band*)get_config_band_by_bandchar(band->bandchar);

        if (band->stats->nqsos <=0) continue;

        html_band_header(gs, band, confb, flags, map, chart);
        html_qsos  (gs, band, confb);
        html_band_footer(gs);
    }
    html_footer(gs);
    aband = oldaband;
    
    g_string_free(gs2, 1);
    g_string_free(title, 1);
}

int export_all_bands_html(void){
    gchar *filename;
    FILE *f;
    char callbuf[20];
    GString *gs;
    
    if (!ctest) return -1;
    
    dbg("export_all_bands_html()\n");
	
    gs = g_string_sized_new(300000);
	html_complete(gs, HTML_MAP | HTML_CHART);
    filename = g_strdup_printf("%s/%s_%s.html",
					ctest->directory,
					ctest->cdate,
					uc(get_raw_call(callbuf,ctest->pcall)));
        
	f=fopen(filename,"wt");
	if (!f) {
		errbox(VTEXT(T_CANT_WRITE), errno);
		g_free(filename);
        g_string_free(gs, 1);
		return -1;
	}

    if (fprintf(f, "%s", gs->str) <= 0){
		errbox(VTEXT(T_CANT_WRITE), 0); 
        g_free(filename);
        g_string_free(gs, 1);
		return -1;
	}
	fclose(f);

	log_addf(VTEXT(T_SAVED_S), filename);
	g_free(filename);
    g_string_free(gs, 1);
    return 0;
}

